/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.expr;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.agent.expr.Expression;
import inform.agent.expr.Term;
import java.io.IOException;

public class FieldTerm
extends Term {
    protected int datasourceId = 0;
    protected int[] fieldIdPath = null;

    public FieldTerm(Expression expr) {
        super(expr);
    }

    public FieldTerm(int elementId, int datasourceId, int fieldId, Expression expr) {
        super(expr);
        this.id = elementId;
        this.datasourceId = datasourceId;
        this.fieldIdPath = new int[]{fieldId};
    }

    @Override
    public Term createClone(Expression e) {
        FieldTerm o = new FieldTerm(e);
        o.datasourceId = this.datasourceId;
        o.fieldIdPath = this.fieldIdPath;
        return o;
    }

    @Override
    public Expression.Token getToken() {
        return Expression.Token.field;
    }

    @Override
    public Expression.Priority getPriority() {
        return Expression.Priority.OPERAND;
    }

    @Override
    public final void loadTag(TaggedReader in) throws IOException {
        switch (in.getCurrentTag()) {
            case 12: {
                this.datasourceId = in.getInt();
                break;
            }
            case 13: {
                this.fieldIdPath = new int[1];
                this.fieldIdPath[0] = in.getInt();
                break;
            }
            case 14: {
                if (in.getCurrentTagSize() == 0) break;
                this.fieldIdPath = LittleEndian.toIntArray(in.getRaw());
                break;
            }
            default: {
                super.loadTag(in);
            }
        }
    }

    @Override
    public void afterLoad() {
    }

    public int getDatasourceId() {
        return this.datasourceId;
    }

    public int[] getFieldIdPath() {
        return this.fieldIdPath;
    }
}

