/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.expr;

import inform.adt.taggedio.TaggedReader;
import inform.agent.expr.Expression;
import inform.agent.expr.Term;
import inform.agent.scripts.Parameter;
import java.io.IOException;

public class ParameterTerm
extends Term {
    protected int paramId = 0;
    protected Parameter parameter = null;

    public ParameterTerm(Expression expr) {
        super(expr);
    }

    public ParameterTerm(int elementId, int paramId, Expression expr) {
        super(expr);
        this.id = elementId;
        this.paramId = paramId;
    }

    @Override
    public final Term createClone(Expression e) {
        ParameterTerm o = new ParameterTerm(e);
        o.id = this.id;
        o.name = this.name;
        o.ignored = this.ignored;
        return o;
    }

    @Override
    public Expression.Priority getPriority() {
        return Expression.Priority.OPERAND;
    }

    @Override
    public Expression.Token getToken() {
        return Expression.Token.param;
    }

    @Override
    public void loadTag(TaggedReader in) throws IOException {
        switch (in.getCurrentTag()) {
            case 11: {
                this.paramId = in.getInt();
                break;
            }
            default: {
                super.loadTag(in);
            }
        }
    }

    @Override
    public void afterLoad() {
        this.parameter = this.expression.getParameters().get(this.paramId);
    }

    public int getParamId() {
        return this.paramId;
    }

    public void setParameter(Parameter parameter) {
        this.parameter = parameter;
    }

    public Parameter getParameter() {
        return this.parameter;
    }
}

