/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.expr;

import inform.adt.taggedio.TaggedReader;
import inform.agent.expr.Expression;
import inform.agent.expr.Term;
import java.io.IOException;

public class SymbolTerm
extends Term {
    protected Expression.Token token = Expression.Token.invalid;
    protected int symbolId = -1;
    public static final int SYNBOL_LEFT_BRACE = 0;
    public static final int SYNBOL_RIGHT_BRACE = 1;
    private static final int SYNBOL_COMMA = 2;
    private static final int SYNBOL_SPACE = 3;

    public SymbolTerm(Expression expr) {
        super(expr);
    }

    public SymbolTerm(Expression expr, int symbolId) {
        super(expr);
        this.setSymbolId(symbolId);
    }

    @Override
    public final Term createClone(Expression e) {
        SymbolTerm t = new SymbolTerm(e);
        t.token = this.token;
        t.symbolId = this.symbolId;
        return t;
    }

    @Override
    public Expression.Priority getPriority() {
        return Expression.Priority.NONE;
    }

    @Override
    public Expression.Token getToken() {
        return this.token;
    }

    @Override
    public void loadTag(TaggedReader in) throws IOException {
        switch (in.getCurrentTag()) {
            case 5: {
                this.setSymbolId(in.getInt());
                break;
            }
            default: {
                super.loadTag(in);
            }
        }
    }

    @Override
    public void afterLoad() {
    }

    public int getSymbolId() {
        return this.symbolId;
    }

    public void setSymbolId(int symbolId) {
        this.symbolId = symbolId;
        switch (symbolId) {
            case 0: {
                this.token = Expression.Token.openBrace;
                break;
            }
            case 1: {
                this.token = Expression.Token.closeBrace;
                break;
            }
            case 2: {
                this.token = Expression.Token.comma;
                break;
            }
            default: {
                this.token = Expression.Token.invalid;
            }
        }
    }
}

