/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.expr;

import inform.adt.taggedio.TaggedReader;
import inform.agent.db.types.DataType;
import inform.agent.expr.Expression;
import inform.agent.expr.Term;
import inform.agent.scripts.ScriptableValue;
import java.io.IOException;
import java.util.ArrayList;

public class ValueTerm
extends Term
implements ScriptableValue {
    protected DataType type = DataType.STRING;
    protected final ArrayList<Object> values = new ArrayList();

    public ValueTerm(Expression expr) {
        super(expr);
    }

    @Override
    public final Term createClone(Expression e) {
        ValueTerm o = new ValueTerm(e);
        o.values.addAll(this.values);
        o.type = this.type;
        return o;
    }

    @Override
    public Expression.Priority getPriority() {
        return Expression.Priority.OPERAND;
    }

    @Override
    public Expression.Token getToken() {
        return Expression.Token.value;
    }

    @Override
    public void loadTag(TaggedReader in) throws IOException {
        switch (in.getCurrentTag()) {
            case 7: {
                this.type = DataType.STRING;
                this.values.add(in.getString());
                break;
            }
            case 17: {
                this.type = DataType.FLOAT;
                this.values.add(in.getDouble());
                break;
            }
            case 18: {
                this.type = DataType.DATE_TIME;
                this.values.add(in.getDouble());
                break;
            }
            case 19: {
                this.type = DataType.BOOLEAN;
                this.values.add(in.getBoolean());
                break;
            }
            case 20: {
                this.values.add(null);
                break;
            }
            case 28: 
            case 29: {
                this.type = DataType.INTEGER;
                this.values.add(in.getInt());
                break;
            }
            case 21: {
                this.type = DataType.getDataTypeById(in.getInt());
                break;
            }
            default: {
                super.loadTag(in);
            }
        }
    }

    @Override
    public void afterLoad() {
    }

    public void setValue(DataType type, Object value) {
        this.type = type;
        this.values.clear();
        if (value instanceof Object[]) {
            for (Object v : (Object[])value) {
                this.values.add(v);
            }
        } else {
            this.values.add(value);
        }
    }

    public DataType getType() {
        return this.type;
    }

    public Object getValue() {
        if (this.values.isEmpty()) {
            return null;
        }
        return this.values.get(0);
    }

    @Override
    public Object getRawValue() {
        if (this.values.isEmpty()) {
            return null;
        }
        if (this.values.size() == 1) {
            return this.values.get(0);
        }
        return this.values.toArray();
    }

    public int valueCount() {
        if (this.values.isEmpty()) {
            return 1;
        }
        if (this.values.size() == 1) {
            return 1;
        }
        return this.values.size();
    }

    @Override
    public boolean getIsIgnored() {
        return false;
    }
}

