/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.files.request;

import inform.adt.Strings;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.types.DataType;
import inform.agent.files.BFS;
import java.util.ArrayList;
import java.util.HashMap;

public class BlobFSDiagnostics
extends Request {
    private static final int TAG_CHECK_SUM = 1;
    private static final int TAG_DEL_WASTE_FILES = 2;
    private static final int TAG_CLEAR_BAD_REFS = 3;
    private final boolean cleanup;

    public BlobFSDiagnostics(RequestHeader rq, boolean cleanup) {
        super(rq, RequestDuration.COMPLEX);
        this.cleanup = cleanup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        boolean checkSum = false;
        boolean delWaste = false;
        boolean clearRefs = false;
        TaggedReader reader = this.createRequestContentReader();
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    checkSum = true;
                    break;
                }
                case 2: {
                    delWaste = true;
                    break;
                }
                case 3: {
                    clearRefs = true;
                }
            }
        }
        TableDescriptor table = TableDescriptor.get(this.getNodeID());
        HashMap<String, BlobFS> checkList = new HashMap<String, BlobFS>();
        for (FieldDescriptor field : table.getFields()) {
            String mountPoint;
            if (field.getType() != DataType.FILE || Strings.isVoid(mountPoint = field.getBlobFS())) continue;
            BlobFS bfs = (BlobFS)checkList.get(mountPoint);
            if (bfs == null) {
                bfs = new BlobFS(mountPoint);
                checkList.put(mountPoint, bfs);
            }
            bfs.fields.add(field);
        }
        if (checkList.isEmpty()) {
            this.putRequestStateLog("\u0422\u0430\u0431\u043b\u0438\u0446\u0430 " + table.toString() + " \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043f\u043e\u043b\u0435\u0439, \u0445\u0440\u0430\u043d\u044f\u0449\u0438\u0445\u0441\u044f \u0432 \u0444\u0430\u043b\u043e\u0432\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435");
            this.sendResult();
            return;
        }
        this.putRequestStateInstruction("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0444\u0430\u0439\u043b\u043e\u0432\u043e\u0433\u043e \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0430");
        try (DatabaseConnection connection = table.getDatabaseDescriptor().connect(this, "rq:BlobFSDiagnostics");){
            for (BlobFS bfs : checkList.values()) {
                this.putRequestStateText(bfs.name);
                BFS.cleanup(null, connection, table, bfs.name, bfs.fields, this.cleanup, checkSum, delWaste, clearRefs, this);
            }
            connection.commit();
        }
    }

    private static class BlobFS {
        final String name;
        final ArrayList<FieldDescriptor> fields = new ArrayList();

        private BlobFS(String name) {
            this.name = name;
        }
    }
}

