/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.files.request;

import inform.adt.LittleEndian;
import inform.adt.Strings;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.types.BlobValueId;
import inform.agent.files.BFS;

public class BlobFileSize
extends Request {
    public BlobFileSize(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        long blobSize;
        BlobValueId blobId = new BlobValueId(this.getRequestContent());
        TableDescriptor table = TableDescriptor.get(blobId.getTableId());
        FieldDescriptor field = table.getExistingFieldDescriptor(blobId.getFieldId());
        BFS.checkBlobFSField(table, field);
        try (DatabaseConnection connection = table.getDatabaseDescriptor().connect(this, "BlobFileSize");){
            String blobPoint = BFS.selectBlobPath(null, connection, table, field, blobId.getRowId());
            blobSize = Strings.isVoid(blobPoint) ? 0L : BFS.getFileSize(field, blobPoint);
            connection.commit();
        }
        this.sendResult(LittleEndian.longToBinary(blobSize));
    }
}

