/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.files.request;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.files.BFS;
import java.io.File;
import java.io.FileInputStream;
import java.security.MessageDigest;
import java.util.Arrays;

public class GetUploadBlobFileInfo
extends Request {
    public GetUploadBlobFileInfo(RequestHeader rq) {
        super(rq, RequestDuration.COMPLEX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        byte[] uploadDigest;
        File filePath;
        TableDescriptor table = TableDescriptor.get(this.getNodeID());
        int fieldId = 0;
        byte[] digest = null;
        long fileSize = 0L;
        int chunkSize = 0;
        TaggedReader in = this.createRequestContentReader();
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    fileSize = in.getLong();
                    break;
                }
                case 2: {
                    chunkSize = in.getInt();
                    break;
                }
                case 3: {
                    digest = in.getRaw();
                    break;
                }
                case 4: {
                    fieldId = in.getInt();
                }
            }
        }
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        MessageDigest cd = MessageDigest.getInstance("SHA-1");
        FieldDescriptor field = table.getExistingFieldDescriptor(fieldId);
        BFS.checkBlobFSField(table, field);
        String blobPath = field.getBlobFS() + ":/" + BFS.getFullTempPath(table, field, digest);
        String sourcePath = Core.blobfs.resolvePath(blobPath);
        String fixedPath = sourcePath + ".blob";
        boolean hasFixedFile = false;
        if (BFS.useHardLink) {
            File file = new File(fixedPath);
            if (file.exists()) {
                filePath = file;
                hasFixedFile = true;
                if (file.length() != fileSize) {
                    throw new InformException("\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u0431\u043b\u043e\u0431-\u0444\u0430\u0439\u043b\u0430 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043d\u043e\u0439").detail(fixedPath);
                }
            } else {
                filePath = new File(sourcePath);
            }
        } else {
            filePath = new File(sourcePath);
        }
        if (!filePath.exists()) {
            this.sendResult();
            return;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        byte[] chunk = new byte[chunkSize];
        fileSize = 0L;
        try (FileInputStream file = new FileInputStream(filePath);){
            int size;
            while ((size = file.read(chunk)) >= 0) {
                if (size == 0) continue;
                fileSize += (long)size;
                md.update(chunk, 0, size);
                cd.update(chunk, 0, size);
                uploadDigest = cd.digest();
                out.putRaw(5, uploadDigest);
                out.flush();
                this.sendChunk(result.internalBuffer(), result.size());
                result.reset();
                out.reset(result);
            }
        }
        uploadDigest = md.digest();
        if (hasFixedFile && !Arrays.equals(digest, uploadDigest)) {
            throw new InformException("\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u0431\u043b\u043e\u0431-\u0444\u0430\u0439\u043b\u0430 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043d\u043e\u0439").detail(fixedPath);
        }
        out.putLong(1, fileSize);
        out.putRaw(3, uploadDigest);
        out.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }
}

