/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.js;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.collections.IntHashMap;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import java.io.IOException;
import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;

public class Deserialization {
    private final IntHashMap<NativeObject> objectsTable = new IntHashMap();
    private Context cx;
    private Scriptable scope;

    public Deserialization(Context cx, Scriptable scope) {
        this.cx = cx;
        this.scope = scope;
    }

    public Object Deserialize(TaggedReader reader) throws IOException, TaggedReaderException {
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 5: {
                    return this.ReadField(reader);
                }
                case 3: {
                    return this.ReadArray(reader);
                }
                case 1: {
                    return this.ReadObject(reader);
                }
            }
        }
        return new Object();
    }

    public Object DeserializeCurrent(TaggedReader reader) throws IOException, TaggedReaderException {
        switch (reader.getCurrentTag()) {
            case 5: {
                return this.ReadField(reader);
            }
            case 3: {
                return this.ReadArray(reader);
            }
            case 1: {
                return this.ReadObject(reader);
            }
        }
        throw new InformException("Unexpected tag: " + reader.getCurrentTag());
    }

    private Object ReadField(TaggedReader reader) throws IOException, TaggedReaderException {
        switch (reader.getNextTag()) {
            case 10: {
                double d = reader.getDouble();
                reader.skip();
                return d;
            }
            case 9: {
                String s = reader.getString();
                reader.skip();
                return s;
            }
            case 12: {
                double date = reader.getDouble();
                reader.skip();
                Object[] ctorArgs = new Object[]{DateTime.toUnixTime(date)};
                return this.cx.newObject(this.scope, "Date", ctorArgs);
            }
            case 11: {
                boolean bool = reader.getBoolean();
                reader.skip();
                return bool;
            }
            case 15: {
                reader.skip();
                reader.skip();
                return null;
            }
        }
        reader.skip();
        return null;
    }

    private Object ReadArray(TaggedReader reader) throws IOException, TaggedReaderException {
        ArrayList<Object> arr = new ArrayList<Object>();
        while (reader.getNextTag() != 4) {
            switch (reader.getCurrentTag()) {
                case 5: {
                    arr.add(this.ReadField(reader));
                    break;
                }
                case 3: {
                    arr.add(this.ReadArray(reader));
                    break;
                }
                case 1: {
                    arr.add(this.ReadObject(reader));
                }
            }
        }
        Scriptable result = this.cx.newArray(this.scope, arr.toArray());
        reader.skip();
        return result;
    }

    private Object ReadObject(TaggedReader reader) throws IOException, TaggedReaderException {
        NativeObject nativeObj = (NativeObject)this.cx.newObject(this.scope);
        String fieldName = "";
        Object obj = null;
        int index = -1;
        while (reader.getNextTag() != 2) {
            switch (reader.getCurrentTag()) {
                case 7: {
                    index = reader.getInt();
                    if (this.objectsTable.contains(index)) {
                        reader.skip();
                        return this.objectsTable.get(index);
                    }
                    this.objectsTable.put(index, nativeObj);
                    break;
                }
                case 5: {
                    fieldName = reader.getString();
                    nativeObj.defineProperty(fieldName, this.ReadField(reader), 0);
                    break;
                }
                case 3: {
                    fieldName = reader.getString();
                    nativeObj.defineProperty(fieldName, this.ReadArray(reader), 0);
                    break;
                }
                case 1: {
                    fieldName = reader.getString();
                    nativeObj.defineProperty(fieldName, this.ReadObject(reader), 0);
                }
            }
        }
        reader.skip();
        return nativeObj;
    }
}

