/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd;

import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.DoubleSet;
import inform.adt.taggedio.LittleEndianDataInputStream;
import inform.adt.taggedio.LittleEndianDataOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.Core;
import inform.agent.mtd.AclEntry;
import inform.agent.mtd.CalculateAccessMask;
import inform.common.Empty;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.sql.SQLException;

public class Acl {
    public static final double USER_ID_ALL = -1.0;
    public static final double USER_ID_OWNER = -2.0;
    private DoubleHash<AclEntry> list = new DoubleHash();

    public AclEntry get(double id) {
        return this.list.get(id);
    }

    public void replace(AclEntry entry) {
        this.list.add(entry);
    }

    public boolean isEmpty() {
        return this.list.empty();
    }

    public void updateAccessMasks(CalculateAccessMask masks, double ... users) {
        for (AclEntry entry : this.list) {
            for (double userId : users) {
                if (entry.getUserId() != userId) continue;
                entry.updateAccessMask(masks);
            }
        }
    }

    public void updateAccessMasks(CalculateAccessMask masks, Iterable<Cursor.Double> users) {
        for (Cursor.Double c : users) {
            AclEntry entry = this.list.get(c.value);
            if (entry == null) continue;
            entry.updateAccessMask(masks);
        }
    }

    public void load(byte[] data) throws IOException {
        LittleEndianDataInputStream stream = new LittleEndianDataInputStream(new ByteArrayInputStream(data));
        while (stream.available() > 0) {
            AclEntry entry = new AclEntry(stream);
            this.list.add(entry);
        }
    }

    public void load(TaggedReader reader) throws IOException, TaggedReaderException {
        this.load(reader.getRaw());
    }

    public byte[] getContent() throws IOException {
        if (this.isEmpty()) {
            return Empty.byteArray;
        }
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        LittleEndianDataOutputStream stream = new LittleEndianDataOutputStream(content);
        for (AclEntry entry : this.list) {
            entry.store(stream);
        }
        stream.flush();
        return content.toByteArray();
    }

    public void setAllUserFullControl() {
        if (!this.list.empty()) {
            this.list = new DoubleHash();
        }
        this.list.add(new AclEntry(-1.0, -1, 0));
    }

    public static void loadRoles(byte[] data, DoubleSet set) throws IOException, SQLException, InterruptedException {
        if (data == null || data.length == 0) {
            return;
        }
        LittleEndianDataInputStream stream = new LittleEndianDataInputStream(new ByteArrayInputStream(data));
        while (stream.available() > 0) {
            double roleId = stream.readDouble();
            stream.readInt();
            stream.readInt();
            set.add(roleId);
        }
    }

    public static void tryLoadRoles(byte[] data, DoubleSet set) throws IOException {
        if (data == null || data.length == 0) {
            return;
        }
        try {
            LittleEndianDataInputStream stream = new LittleEndianDataInputStream(new ByteArrayInputStream(data));
            while (stream.available() > 0) {
                double roleId = stream.readDouble();
                stream.readInt();
                stream.readInt();
                set.add(roleId);
            }
        }
        catch (EOFException ex) {
            Core.logger.error(null, ex);
        }
    }

    public static byte[] replaceRole(byte[] data, double sourceRole, double replaceRole) throws IOException {
        if (data == null || data.length == 0) {
            return Empty.byteArray;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        LittleEndianDataOutputStream out = new LittleEndianDataOutputStream(result);
        LittleEndianDataInputStream stream = new LittleEndianDataInputStream(new ByteArrayInputStream(data));
        while (stream.available() > 0) {
            double roleId = stream.readDouble();
            int d1 = stream.readInt();
            int d2 = stream.readInt();
            if (roleId == sourceRole) {
                roleId = replaceRole;
            }
            out.writeDouble(roleId);
            out.writeInt(d1);
            out.writeInt(d2);
        }
        out.flush();
        return result.toByteArray();
    }

    public static boolean containRole(byte[] data, double nodeId) throws IOException, SQLException, InterruptedException {
        if (data == null || data.length == 0) {
            return false;
        }
        LittleEndianDataInputStream stream = new LittleEndianDataInputStream(new ByteArrayInputStream(data));
        while (stream.available() > 0) {
            double roleId = stream.readDouble();
            if (roleId == nodeId) {
                return true;
            }
            stream.readInt();
            stream.readInt();
        }
        return false;
    }

    public Integer simpleAccess() {
        if (this.list.size() != 1) {
            return null;
        }
        AclEntry entry = (AclEntry)this.list.iterator().next();
        if (entry != null && entry.isAllUser()) {
            return entry.getMask();
        }
        return null;
    }
}

