/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd;

import inform.adt.collections.DoubleHash;
import inform.adt.taggedio.LittleEndianDataInputStream;
import inform.adt.taggedio.LittleEndianDataOutputStream;
import inform.agent.mtd.CalculateAccessMask;
import java.io.IOException;

public class AclEntry
implements DoubleHash.Entry {
    private final double userId;
    private int allowMask;
    private int denyMask;

    public AclEntry(double userId, int allowMask, int denyMask) {
        this.userId = userId;
        this.allowMask = allowMask;
        this.denyMask = denyMask;
    }

    public AclEntry(LittleEndianDataInputStream stream) throws IOException {
        this.userId = stream.readDouble();
        this.allowMask = stream.readInt();
        this.denyMask = stream.readInt();
    }

    public void store(LittleEndianDataOutputStream stream) throws IOException {
        stream.writeDouble(this.userId);
        stream.writeInt(this.allowMask);
        stream.writeInt(this.denyMask);
    }

    public double getUserId() {
        return this.userId;
    }

    public boolean isAllUser() {
        return this.userId == -1.0;
    }

    public static AclEntry createAllFullControl() {
        return new AclEntry(-1.0, -1, 0);
    }

    public void updateAccessMask(CalculateAccessMask masks) {
        masks.allowed |= this.allowMask;
        masks.denied |= this.denyMask;
    }

    public int getMask() {
        return this.allowMask & ~this.denyMask;
    }

    @Override
    public double key() {
        return this.userId;
    }
}

