/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleDoubleMap;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.DoubleSet;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.LogContext;
import inform.agent.PhaThread;
import inform.agent.ServerSideHost;
import inform.agent.db.ClosableResult;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.Connector;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.DatabaseType;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.connect.Statement;
import inform.agent.db.schema.Restructure;
import inform.agent.mtd.FailedLogins;
import inform.agent.mtd.LockEngine;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.MtdCache;
import inform.agent.mtd.NodeLock;
import inform.agent.mtd.NodeRecord;
import inform.agent.mtd.SchemeLockList;
import inform.agent.mtd.SyncNodeRecord;
import inform.agent.mtd.TableDirectoryDependencis;
import inform.agent.mtd.nodes.AccountNode;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.NodeHashTable;
import inform.agent.mtd.nodes.ServerNode;
import inform.agent.mtd.nodes.SymLinkNodeCache;
import inform.agent.mtd.nodes.UserNode;
import inform.agent.mtd.nodes.VirtualUser;
import inform.agent.mtd.request.NodeStatus;
import inform.agent.net.AlertingEngine;
import inform.agent.net.Client;
import inform.agent.net.Security;
import inform.agent.scripts.SSContext;
import inform.common.Base64BinString;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class MtdEngine {
    public static final int MAX_PATH_SIZE = 1024;
    public static final String NO_NODE_ERROR = "\u0423\u0437\u0435\u043b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d";
    public static final String NO_ROOT_NODE_ERROR = "\u041a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u0443\u0437\u0435\u043b \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d";
    public static final String OBSERVER_DENY_ERROR = "\u041e\u0431\u043e\u0437\u0440\u0435\u0432\u0430\u0442\u0435\u043b\u0438 \u043d\u0435 \u0438\u043c\u0435\u044e\u0442 \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439";
    public static final String MODIFY_NODE_DENY_ERROR = "\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u043e\u0432 \u0443\u0437\u043b\u0430";
    public static final int MHOP_CREATE_NODE = 1;
    public static final int MHOP_UPDATE_NODE = 2;
    public static final int MHOP_DELETE_NODE = 3;
    public static final int MHOP_SET_CONTENT = 4;
    public static final double AGENT_APP_OBSOLETE_INTERVAL = 0.008333333333333333;
    public static final long AGENT_APP_OBSOLETE_TIMEOUT = 1920000L;
    public static final long AGENT_APP_ACTIVITY_TIMEOUT = 150000L;
    public static final double LOCK_OBSOLETE_INTERVAL = 0.008333333333333333;
    public static final long LOCK_OBSOLETE_TIMEOUT = 1200000L;
    private static final byte[] NOTIFICATION_INVALIDATE_NODE_CACHE = new byte[]{5, 0};
    private static final long RELOAD_NODES_INTERVAL_MSEC = 3060000L;
    private static final long SYNC_NODES_INTERVAL_MSEC = 60000L;
    private static final long SYNC_NODES_DELTA_MSEC = 900000L;
    private static final long GET_NODE_TIME_MSEC = 10000L;
    private static volatile MtdCache engineCache = null;
    private static MtdCache reloadCache = null;
    private static final Object nodesMutex = new Object();
    private static long reloadTime = 0L;
    private static long syncTime = 0L;
    private static Timestamp syncTimestamp = null;
    private static long checkAgentAppTime = 0L;
    private static long checkAgentActivityTime = 0L;
    private static long checkLocksTime = 0L;
    private static long checkConnectionPoolTime = 0L;
    private static final SchemeLockList SchemesLocks = new SchemeLockList();
    private static DoubleHash<Node> unsettedContentAttrNodes = null;
    private static final FailedLogins failedLogins = new FailedLogins();
    private static final DoubleDoubleMap pinCache = new DoubleDoubleMap();
    private static UserNode safeModeUser = null;
    private static UserNode builtInServiceUser = null;

    public static void initNodeCache() throws Exception {
        if (!Ini.ReadonlyMode) {
            MtdEngine.createSystemTables();
        }
        Core.getApplicationId();
        Core.logger.info("Loading metadata tree ...");
        long time = System.currentTimeMillis();
        int nodeCount = MtdEngine.reload();
        time = (System.currentTimeMillis() - time) / 1000L;
        unsettedContentAttrNodes = MtdEngine.getMtdCache().getUnsettedContentAttrNodes();
        Core.logger.info("Metadata tree loaded {} nodes by {} seconds", (Object)nodeCount, (Object)time);
    }

    public static void startNodeCache() {
        PhaThread.daemonize(new MtdUpdater());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MtdCache getMtdCache() throws InformException {
        MtdCache cache = engineCache;
        if (cache != null) {
            return cache;
        }
        Object object = nodesMutex;
        synchronized (object) {
            while (engineCache == null) {
                try {
                    nodesMutex.wait();
                }
                catch (InterruptedException ex) {
                    throw InformException.wrap(ex);
                }
            }
            return engineCache;
        }
    }

    public static Node getNode(double id) throws InformException {
        try {
            MtdCache mtdCache = MtdEngine.getMtdCache();
            NodeHashTable cache = mtdCache.getNodes();
            Node node = cache.get(id);
            return node;
        }
        catch (Throwable ex) {
            throw InformException.wrap(ex);
        }
    }

    public static Node getValidNode(double id) throws InformException {
        Node node = MtdEngine.getNode(id);
        if (node == null) {
            MtdEngine.throwError(id, "\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node getValidNodeSync(SSContext ssContext, double id) throws InformException, SQLException {
        MtdCache mtdCache = MtdEngine.getMtdCache();
        NodeHashTable cache = mtdCache.getNodes();
        Node node = cache.get(id);
        if (node != null) {
            return node;
        }
        NodeRecord record = new NodeRecord();
        try (DatabaseConnection connection = DatabaseDescriptor.getMetabase().connectPrivileged("MetadataNodeReader.checkNodeExists");){
            if (!MetadataNodeReader.loadNodeRecord(ssContext, connection, id, record)) {
                MtdEngine.throwError(id, "\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
        }
        mtdCache.checkNodeRecord(record);
        node = mtdCache.createTypedNode(record);
        if (!record.isAttributesEmpty()) {
            node.load(mtdCache, record.createAttributesReader());
        }
        mtdCache.putNode(node);
        node.setLoadNodeTime(System.currentTimeMillis());
        Node parent = cache.get(node.getParentId());
        if (parent != null) {
            parent.dropChildrenCache();
        }
        if (node instanceof AccountNode) {
            node.checkLoaded();
        }
        return node;
    }

    public static BasicNode getTranslatedNode(double id) throws InformException {
        Node node = MtdEngine.getNode(id);
        if (node == null) {
            return null;
        }
        return node.getRefNode();
    }

    public static BasicNode getValidTranslatedNode(double id) throws InformException {
        BasicNode node = MtdEngine.getValidNode(id).getRefNode();
        if (node == null) {
            MtdEngine.throwError(id, "\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        return node;
    }

    public static AccountNode getAccountNode(double id) throws InformException {
        if (id == 2.0) {
            return UserNode.SystemUsersHelper.SERVER_USER;
        }
        Node node = MtdEngine.getNode(id);
        if (safeModeUser == null && (node == null || node.getType() == 3) && MtdEngine.serverNode().descriptor().useUsersTable) {
            try {
                VirtualUser virtualUser = VirtualUser.getUser(id);
                if (virtualUser != null) {
                    return virtualUser;
                }
            }
            catch (IOException | SQLException e) {
                throw InformException.wrap(e);
            }
        }
        if (!(node instanceof AccountNode)) {
            return null;
        }
        return (AccountNode)node;
    }

    public static AccountNode getValidAccountNode(double id) throws InformException {
        AccountNode node = MtdEngine.getAccountNode(id);
        if (node == null) {
            MtdEngine.throwDetailError("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0438\u043b\u0438 \u0433\u0440\u0443\u043f\u043f\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b", id);
        }
        return node;
    }

    public static AccountNode getValidAccountMetadataNode(double id) throws InformException {
        Node node = MtdEngine.getNode(id);
        if (node == null || !(node instanceof AccountNode)) {
            MtdEngine.throwDetailError("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0438\u043b\u0438 \u0433\u0440\u0443\u043f\u043f\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b", id);
        }
        return (AccountNode)node;
    }

    public static AccountNode.StartupInfo getGroupStartupInfo(double id) {
        Node node = MtdEngine.getNode(id);
        if (node == null) {
            return null;
        }
        if (!(node instanceof AccountNode)) {
            return null;
        }
        return ((AccountNode)node).findStartupInfo();
    }

    public static UserNode getUserNode(double id) throws InformException {
        Node node;
        if (MtdEngine.serverNode().descriptor().useUsersTable) {
            try {
                node = VirtualUser.getUser(id);
                if (node != null) {
                    return node;
                }
            }
            catch (IOException | SQLException e) {
                throw InformException.wrap(e);
            }
        }
        if (!((node = MtdEngine.getNode(id)) instanceof UserNode)) {
            return null;
        }
        return (UserNode)node;
    }

    public static Node getNodeByIdent(String ident) throws InformException {
        return MtdEngine.getMtdCache().getNodeByIdent(ident);
    }

    public static DoubleHash<AccountNode> getAccountsWithName(String name) {
        return MtdEngine.getMtdCache().getAccountsWithName(name);
    }

    public static UserNode getUserNodeByName(String name) throws InformException {
        return MtdEngine.getMtdCache().getUserNodeByName(name, !Ini.SafeMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserNode createSafeModeUser() {
        Object object = nodesMutex;
        synchronized (object) {
            if (safeModeUser == null) {
                safeModeUser = UserNode.createSafeModeUser();
            }
        }
        MtdEngine.getMtdCache().putNode(safeModeUser);
        return safeModeUser;
    }

    public static UserNode getAcitiveDirectoryUserNodes(String name) throws InformException {
        return MtdEngine.getMtdCache().getAcitiveDirectoryUserNodes(name);
    }

    public static double getUserIdByName(String name) throws InformException {
        return MtdEngine.getMtdCache().getUserIdByName(name);
    }

    public static ServerNode serverNode() throws InformException {
        Node node = MtdEngine.getNode(2.0);
        if (!(node instanceof ServerNode)) {
            MtdEngine.throwDetailError("\u0423\u0437\u0435\u043b \"\u0421\u0435\u0440\u0432\u0435\u0440\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", 2.0);
        }
        return (ServerNode)node;
    }

    public static SymLinkNodeCache getSymlinkCache() throws InformException {
        MtdCache cache = MtdEngine.getMtdCache();
        return cache.getSymlinkCache();
    }

    public static AccountNode[] getAccounts() throws InformException {
        MtdCache cache = MtdEngine.getMtdCache();
        return cache.getAccounts();
    }

    public static void checkNodeRecord(NodeRecord record) throws InformException {
        MtdCache cache = MtdEngine.getMtdCache();
        cache.checkNodeRecord(record);
    }

    public static void throwDetailError(String msg, double id) throws InformException {
        throw new InformException(msg).detail("\u0443\u0437\u0435\u043b [" + NumberConverter.doubleToString(id) + "] ");
    }

    public static void throwError(double id, String msg) throws InformException {
        throw new InformException("\u0423\u0437\u0435\u043b [" + NumberConverter.doubleToString(id) + "] " + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateNodes(SSContext context, Node.ModifyNodeArg arg) throws SQLException, InformException {
        MtdCache cache = MtdEngine.getMtdCache();
        MetadataNodeReader.updateNodes(context, arg);
        long loadTime = System.currentTimeMillis();
        for (Node node : arg.modifiedNodes) {
            boolean needInvalidateSecurity = false;
            if (node.hasSignificantChanges()) {
                needInvalidateSecurity = true;
            }
            node.applyChanges();
            node.setLoadNodeTime(loadTime);
            Object object = nodesMutex;
            synchronized (object) {
                cache.putNode(node);
                if (cache != reloadCache && reloadCache != null) {
                    reloadCache.putModifiedNode(node);
                }
            }
            if (!needInvalidateSecurity) continue;
            AccountNode.invalidateSecurity();
        }
        for (Cursor.Double modifiedParent : arg.modifiedParents) {
            Node node = cache.getNode(modifiedParent.value);
            if (node == null) continue;
            node.dropChildrenCache();
            AccountNode.invalidateSecurity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createNewNode(SSContext ssContext, Connector connector, Node node, String comment) throws InformException, SQLException {
        MtdCache cache = MtdEngine.getMtdCache();
        MetadataNodeReader.createNode(ssContext, connector, node, comment);
        Node parentNode = cache.getNode(node.getParentId());
        if (parentNode != null) {
            parentNode.dropChildrenCache();
        }
        long loadTime = System.currentTimeMillis();
        node.applyChanges();
        node.setLoadNodeTime(loadTime);
        Object object = nodesMutex;
        synchronized (object) {
            cache.putNode(node);
            if (cache != reloadCache && reloadCache != null) {
                reloadCache.syncNewNode(node);
            }
        }
    }

    public static boolean lockScheme(NodeLock lock) {
        return SchemesLocks.lock(lock);
    }

    public static ArrayList<NodeLock> getUsersSchemeEdit(Double nodeId) {
        return SchemesLocks.getUsersSchemeEdit(nodeId);
    }

    public static void unlockScheme(NodeLock lock) {
        SchemesLocks.unlock(lock);
    }

    public static void unlockClientSchemeLocks(Client client) {
        SchemesLocks.unlockAll(client);
    }

    public static Client getSchemeLocker(NodeLock lock) {
        return SchemesLocks.getClient(lock);
    }

    public static boolean isSchemeLockes(double nodeId, double lockId) {
        return SchemesLocks.isLocked(nodeId, lockId);
    }

    public static boolean isNodeInTrash(double nodeId) throws InformException {
        while (nodeId != 0.0) {
            Node node = MtdEngine.getNode(nodeId);
            if (node == null) {
                return false;
            }
            if (node.isInTrash()) {
                return true;
            }
            nodeId = node.getParentId();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheAccountContents(DatabaseConnection connection, MtdCache mtdCache) throws InformException, SQLException {
        try (PreparedStatement ps = connection.prepareStatement("getContent", "SELECT ID,MOD_CONTENT_TIME,RAW_CONTENT,DSL_CONTENT  FROM " + MetadataNodeReader.mtdTreeTableName + " WHERE NODE_TYPE IN (3,4)");
             ResultSet rs = ps.executeQuery(null);){
            while (rs.next()) {
                double nodeId = rs.getDouble(1);
                Timestamp t = rs.getTimestamp(2);
                long time = t == null ? 0L : t.getTime();
                byte[] content = rs.getBlobBytes(3);
                String dslContent = rs.getString(4);
                Node node = mtdCache.getNode(nodeId);
                if (node != null && node instanceof BasicNode) {
                    ((BasicNode)node).cacheContent(time, content, dslContent);
                }
                if (!(node instanceof AccountNode)) continue;
                node.checkLoaded();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int reload(DatabaseConnection connection) throws InformException, SQLException, InterruptedException {
        boolean checkTree;
        MtdCache mtdCache = new MtdCache();
        Object object = nodesMutex;
        synchronized (object) {
            checkTree = engineCache == null;
            reloadCache = mtdCache;
        }
        int nodeCount = 0;
        NodeRecord record = new NodeRecord();
        long loadTime = System.currentTimeMillis();
        try (ClosableResult closableResult = MetadataNodeReader.getReloadNodesResultSet(null, connection);){
            ResultSet fetch = closableResult.getResultSet();
            MetadataNodeReader.FieldsIndexes fidxs = new MetadataNodeReader.FieldsIndexes(fetch);
            while (fetch.next()) {
                ++nodeCount;
                record.clear();
                MetadataNodeReader.loadNodeRecord(fetch, fidxs, record);
                mtdCache.checkNodeRecord(record);
                Node node = mtdCache.createTypedNode(record);
                if (!record.isAttributesEmpty()) {
                    node.load(mtdCache, record.createAttributesReader());
                }
                if (mtdCache.putNode(node)) {
                    // empty if block
                }
                node.setLoadNodeTime(loadTime);
                if (!Core.isAgentStopped()) continue;
                int n = -1;
                return n;
            }
        }
        MtdEngine.cacheAccountContents(connection, mtdCache);
        if (Core.isAgentStopped()) {
            return -1;
        }
        mtdCache.afterLoad(connection, checkTree);
        if (Core.isAgentStopped()) {
            return -1;
        }
        if (builtInServiceUser != null) {
            mtdCache.putNode(builtInServiceUser);
        } else if (Ini.builtInServiceUser) {
            builtInServiceUser = UserNode.createBuiltInServiceUser();
            mtdCache.putNode(builtInServiceUser);
        }
        Object object2 = nodesMutex;
        synchronized (object2) {
            engineCache = mtdCache;
            syncTime = reloadTime = loadTime;
            nodesMutex.notifyAll();
        }
        AccountNode.invalidateSecurity();
        mtdCache.getNodes().buildRoles();
        return nodeCount;
    }

    private static int reload() throws SQLException, InformException, InterruptedException {
        try (DatabaseConnection connection = DatabaseDescriptor.getMetabase().connectPrivileged("MtdEngine::reload");){
            int reloadNodeCount = MtdEngine.reload(connection);
            connection.commit();
            int n = reloadNodeCount;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncUser(String login) throws SQLException, InformException, InterruptedException, IOException {
        boolean hasContentChanges = false;
        try (DatabaseConnection connection = DatabaseDescriptor.getMetabase().connectPrivileged("MtdEngine::syncUser");){
            connection.markAsReadonly();
            if (engineCache == null) {
                return;
            }
            long loadTime = System.currentTimeMillis();
            double syncTime = DateTime.currentDateTime() - 0.010416666666666666;
            MtdCache mtdCache = MtdEngine.getMtdCache();
            try (ClosableResult closableResult = MetadataNodeReader.syncUserResultSet(null, login, connection, syncTime, Core.getApplicationId());){
                hasContentChanges = MtdEngine.sync(closableResult, loadTime, mtdCache);
            }
            connection.commit();
        }
        if (hasContentChanges && !Core.isAgentStopped()) {
            AlertingEngine.sendChangeNotification(null, NOTIFICATION_INVALIDATE_NODE_CACHE, NOTIFICATION_INVALIDATE_NODE_CACHE.length, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sync() throws SQLException, InformException, InterruptedException, IOException {
        if (DatabaseType.get(Core.getMetadataDBKind()) == DatabaseType.H2) {
            return;
        }
        boolean hasContentChanges = false;
        try (DatabaseConnection connection = DatabaseDescriptor.getMetabase().connectPrivileged("MtdEngine::sync");){
            if (engineCache == null) {
                return;
            }
            long loadTime = System.currentTimeMillis();
            if (syncTimestamp == null) {
                syncTimestamp = new Timestamp(loadTime - 900000L);
            } else {
                syncTimestamp.setTime(loadTime - 900000L);
            }
            MtdCache mtdCache = MtdEngine.getMtdCache();
            try (ClosableResult closableResult = MetadataNodeReader.getSyncNodesResultSet(null, connection, syncTimestamp, Core.getApplicationId());){
                hasContentChanges = MtdEngine.sync(closableResult, loadTime, mtdCache);
            }
            Object object = nodesMutex;
            synchronized (object) {
                syncTime = loadTime;
            }
            connection.commit();
        }
        if (hasContentChanges && !Core.isAgentStopped()) {
            AlertingEngine.sendChangeNotification(null, NOTIFICATION_INVALIDATE_NODE_CACHE, NOTIFICATION_INVALIDATE_NODE_CACHE.length, 0L);
        }
    }

    public static boolean sync(ClosableResult closableResult, long loadTime, MtdCache mtdCache) throws SQLException, InformException, InterruptedException, IOException {
        Node node;
        boolean hasContentChanges = false;
        int nodeCount = 0;
        NodeRecord record = new NodeRecord();
        ArrayList<NodeRecord> newNodes = new ArrayList<NodeRecord>();
        ArrayList<SyncNodeRecord> modifiedNodes = new ArrayList<SyncNodeRecord>();
        ResultSet fetch = closableResult.getResultSet();
        while (fetch.next()) {
            ++nodeCount;
            record.clear();
            MetadataNodeReader.loadNodeRecordTime(fetch, record);
            Node node2 = mtdCache.getNode(record.getId());
            if (node2 != null && node2.dropContentIfNeed(record)) {
                hasContentChanges = true;
            }
            if (node2 == null) {
                MetadataNodeReader.loadNodeRecordExceptTime(fetch, record);
                newNodes.add(new NodeRecord(record));
            } else if (!node2.isSameTime(record)) {
                MetadataNodeReader.loadNodeRecordExceptTime(fetch, record);
                modifiedNodes.add(new SyncNodeRecord(node2, record));
                if (node2.getModificationContentTime() != record.getModificationContentTime()) {
                    hasContentChanges = true;
                }
            } else if (node2.dropContentIfNeed(record)) {
                hasContentChanges = true;
                if (node2.getType() == 12) {
                    TableDirectoryDependencis.invalidate(node2.getId());
                }
            }
            if (!Core.isAgentStopped()) continue;
            return false;
        }
        DoubleSet parents = new DoubleSet();
        for (SyncNodeRecord syncNodeRecord : modifiedNodes) {
            node = mtdCache.createTypedNode(syncNodeRecord);
            if (!syncNodeRecord.isAttributesEmpty()) {
                node.load(mtdCache, syncNodeRecord.createAttributesReader());
            }
            mtdCache.syncNode(node);
            node.setLoadNodeTime(loadTime);
            AccountNode.invalidateSecurity();
            parents.add(node.getParentId());
            parents.add(syncNodeRecord.node.getParentId());
            if (node instanceof AccountNode) {
                node.checkLoaded();
            }
            if (node.getType() == 12) {
                TableDirectoryDependencis.invalidate(node.getId());
            }
            if (!Core.isAgentStopped()) continue;
            return false;
        }
        for (NodeRecord nodeRecord : newNodes) {
            node = mtdCache.createTypedNode(nodeRecord);
            if (!nodeRecord.isAttributesEmpty()) {
                node.load(mtdCache, nodeRecord.createAttributesReader());
            }
            mtdCache.syncNode(node);
            node.setLoadNodeTime(loadTime);
            AccountNode.invalidateSecurity();
            parents.add(node.getParentId());
            if (node.getType() == 12) {
                TableDirectoryDependencis.invalidate(node.getId());
            }
            if (!Core.isAgentStopped()) continue;
            return false;
        }
        for (Cursor.Double double_ : parents) {
            node = mtdCache.getNode(double_.value);
            if (node == null) continue;
            node.dropChildrenCache();
            AccountNode.invalidateSecurity();
        }
        return hasContentChanges;
    }

    public static void appendNodeNameForLog(StringBuilder msg, double nodeId) throws InformException {
        msg.append(" [").append(NumberConverter.doubleToString(nodeId)).append("] ");
        Node info = MtdEngine.getNode(nodeId);
        if (info == null) {
            msg.append("???");
        } else {
            msg.append(info.getName());
        }
    }

    public static void appendUserNameForLog(StringBuilder msg, double nodeId) throws InformException {
        msg.append(" [").append(NumberConverter.doubleToString(nodeId)).append("] ");
        UserNode info = MtdEngine.getUserNode(nodeId);
        if (info == null) {
            msg.append("???");
        } else {
            msg.append(info.getName());
        }
    }

    public static byte[] getNodeContent(double nodeId) throws InformException {
        return MtdEngine.getValidNode(nodeId).getRealNode().getContent();
    }

    public static BasicNode getRealNode(double nodeId) {
        return MtdEngine.getValidNode(nodeId).getRealNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setNodeContent(SSContext context, ServerSideHost ssHost, double nodeId, long contentStamp, byte[] content, String dslContent, double modUserId, double sessionId, Security security) throws InformException, SQLException {
        BasicNode node = MtdEngine.getValidNode(nodeId).getRealNode();
        node.lockBarrier(sessionId);
        try (Connector.Metabase connector = new Connector.Metabase();){
            Node.ModifyNodeArg arg = new Node.ModifyNodeArg(ssHost, connector, NodeStatus.MODIFIED, security);
            arg.userId = modUserId;
            arg.sessionId = sessionId;
            arg.ssContext = context;
            arg.contentStamp = contentStamp;
            node = arg.modifyNode(node);
            node.setContent(content, dslContent, arg);
            node.setModificationAttributeTime(arg.contentModificationTime);
            MtdEngine.updateNodes(context, arg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSystemTables() throws Exception {
        DatabaseDescriptor dd = DatabaseDescriptor.getMetabase();
        try (DatabaseConnection connection = dd.connectPrivileged("MtdEngine::createSystemTables");
             Statement statement = connection.createStatement();){
            Restructure.upcreateTable(null, connection.openScheme(), statement, TableDescriptor.getSystemMtdTree(), Restructure.DDL_LOGGER, false);
            connection.commit();
            Restructure.upcreateTable(null, connection.openScheme(), statement, TableDescriptor.getSystemMtdConfNodes(), Restructure.DDL_LOGGER, false);
            connection.commit();
            Restructure.upcreateTable(null, connection.openScheme(), statement, TableDescriptor.getSystemMtdConf(), Restructure.DDL_LOGGER, false);
            connection.commit();
            String logScheme = Core.getMetadataLogScheme();
            if (logScheme == null || logScheme.isEmpty()) {
                logScheme = dd.getScheme();
            }
            Restructure.upcreateTable(null, connection.openScheme(logScheme), statement, TableDescriptor.getSystemMtdTreeLog(), Restructure.DDL_LOGGER, false);
            connection.commit();
            Restructure.upcreateTable(null, connection.openScheme(), statement, TableDescriptor.getSystemMtdAgents(), Restructure.DDL_LOGGER, false);
            connection.commit();
            Restructure.upcreateTable(null, connection.openScheme(), statement, TableDescriptor.getSystemMtdLocks(), Restructure.DDL_LOGGER, false);
            connection.commit();
            Restructure.upcreateTable(null, connection.openScheme(), statement, TableDescriptor.getSystemMtdTickets(), Restructure.DDL_LOGGER, false);
            connection.commit();
            Restructure.upcreateTable(null, connection.openScheme(), statement, TableDescriptor.getSystemMtdPersistentSessions(), Restructure.DDL_LOGGER, false);
            connection.commit();
        }
    }

    public static String getMtdTableName(boolean history) {
        return history ? MetadataNodeReader.mtdTreeLogTableName : MetadataNodeReader.mtdTreeTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerMtdOperation(SSContext ssContext, DatabaseConnection connection, double nodeId, double userId, double sessionId, String comment, int opCode, boolean isContentChanged, int nodeType) throws SQLException, InformException {
        if (nodeType == 16) {
            return;
        }
        double logId = Core.generateId();
        String mtdLog = MetadataNodeReader.mtdTreeLogTableName;
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(mtdLog);
        sql.append(" (ID,OP_CODE,OP_TIME,USER_ID, SESSION_ID, NODE_ID,PARENT_ID,NODE_TYPE,NODE_NAME,IDENT_NAME,NODE_DESCRIPTION,OWNER_ID,ORDER_NO,CREATION_TIME,MOD_ATTRS_TIME,MOD_CONTENT_TIME,ATTRS_B64,MOD_USER_ID,REPL_ID,REPL_NODE_ID");
        if (isContentChanged) {
            sql.append(",RAW_CONTENT,DSL_CONTENT");
        }
        sql.append(") select ");
        sql.append('?');
        sql.append(',').append(opCode);
        sql.append(',').append('?');
        sql.append(',').append('?');
        sql.append(',').append('?');
        sql.append(",ID,PARENT_ID,NODE_TYPE,NODE_NAME,IDENT_NAME,NODE_DESCRIPTION,OWNER_ID,ORDER_NO,CREATION_TIME,MOD_ATTRS_TIME,MOD_CONTENT_TIME,ATTRS_B64,MOD_USER_ID,REPL_ID,REPL_NODE_ID");
        if (isContentChanged) {
            sql.append(",RAW_CONTENT,DSL_CONTENT ");
        }
        sql.append(" from ");
        sql.append(MetadataNodeReader.mtdTreeTableName).append(" where ID=?");
        try (PreparedStatement ps = connection.prepareStatement("Metadata.registerMtdOperation", sql.toString());){
            ps.setDouble(1, logId);
            ps.setDateTime(2, DateTime.currentDateTime());
            ps.setDouble(3, userId);
            ps.setDouble(4, sessionId);
            ps.setDouble(5, nodeId);
            ps.executeUpdate(ssContext);
        }
        if (comment != null && !comment.isEmpty()) {
            if (comment.length() > 512) {
                comment = comment.substring(0, 512);
            }
            sql = new StringBuilder();
            sql.append("update ").append(mtdLog).append(" set ENTRY_COMMENT=? where ID=?");
            ps = connection.prepareStatement("Metadata.registerMtdOperation comment", sql.toString());
            try {
                ps.setString(1, comment);
                ps.setDouble(2, logId);
                ps.executeUpdate(ssContext);
            }
            finally {
                ps.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runUpdateNodes() throws SQLException, InformException, InterruptedException, IOException {
        block37: {
            long nextCheckLocks;
            long nextCheckActivity;
            long nextCheckApp;
            long nextSyncTime;
            long nextTime;
            DoubleHash<Node> unsetted;
            boolean forceReload = false;
            Object object = nodesMutex;
            synchronized (object) {
                if (reloadTime == 0L) {
                    forceReload = true;
                }
            }
            if (forceReload) {
                Core.logger.info("Reloading metadata tree ...");
                MtdEngine.reload();
                Core.logger.info("Metadata tree loaded");
                AlertingEngine.sendChangeNotification(null, NOTIFICATION_INVALIDATE_NODE_CACHE, NOTIFICATION_INVALIDATE_NODE_CACHE.length, 0L);
                return;
            }
            Object object2 = nodesMutex;
            synchronized (object2) {
                unsetted = unsettedContentAttrNodes;
                unsettedContentAttrNodes = null;
            }
            if (unsetted != null) {
                try (DatabaseConnection connection = DatabaseDescriptor.getMetabase().connectPrivileged("MtdEngine::runUpdateNodes");){
                    MetadataNodeReader.createContentAttributes(unsetted, connection, null);
                    connection.commit();
                }
            }
            long nextCheckConnectionPoolTime = checkConnectionPoolTime + (long)Ini.ConnectionCheckInterval;
            Object object3 = nodesMutex;
            synchronized (object3) {
                nextTime = reloadTime;
                nextSyncTime = syncTime;
                nextCheckApp = checkAgentAppTime;
                nextCheckActivity = checkAgentActivityTime;
                nextCheckLocks = checkLocksTime;
            }
            nextTime += 3060000L;
            nextSyncTime += 60000L;
            nextCheckApp += 1920000L;
            nextCheckActivity += 150000L;
            nextCheckLocks += 1200000L;
            long time = System.currentTimeMillis();
            if (time > nextTime) {
                MtdEngine.reload();
                AlertingEngine.sendChangeNotification(null, NOTIFICATION_INVALIDATE_NODE_CACHE, NOTIFICATION_INVALIDATE_NODE_CACHE.length, 0L);
            } else if (time > nextSyncTime) {
                MtdEngine.sync();
            }
            if (time > nextCheckConnectionPoolTime) {
                DatabaseDescriptor.checkPools();
                checkConnectionPoolTime = System.currentTimeMillis();
            }
            if (time > nextCheckActivity || time > nextCheckLocks || time > nextCheckApp) {
                Connector.Metabase connector = new Connector.Metabase();
                try {
                    try {
                        Object object4;
                        if (time > nextCheckActivity) {
                            MetadataNodeReader.updateAgentApplicationActivity(connector.connection(), Core.getApplicationId());
                            time = System.currentTimeMillis();
                            object4 = nodesMutex;
                            synchronized (object4) {
                                checkAgentActivityTime = time;
                            }
                        }
                        if (time > nextCheckApp) {
                            MetadataNodeReader.deleteObsoleteAgentApplications(connector.connection(), Core.getApplicationId());
                            time = System.currentTimeMillis();
                            object4 = nodesMutex;
                            synchronized (object4) {
                                checkAgentAppTime = time;
                            }
                        }
                        if (time <= nextCheckLocks) break block37;
                        LockEngine.deleteObsoleteLocks(connector.connection());
                        time = System.currentTimeMillis();
                        object4 = nodesMutex;
                        synchronized (object4) {
                            checkLocksTime = time;
                        }
                    }
                    finally {
                        connector.close();
                    }
                }
                catch (SQLException e) {
                    throw InformException.wrap(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateNodeHistoryEntry(MetadataNodeReader.NodeHistoryEntry entry, int changed_fields) throws InformException, SQLException {
        if (entry == null) {
            return;
        }
        DatabaseConnection conn = DatabaseDescriptor.getMetabase().connectPrivileged("MtdEngine::UpdateNodeHistoryEntry");
        String sql = String.format("UPDATE %s SET ENTRY_COMMENT = ? WHERE ID = ?", MetadataNodeReader.mtdTreeLogTableName);
        PreparedStatement stmt = conn.prepareStatement(sql);
        try {
            stmt.setString(1, entry.comment);
            stmt.setDouble(2, entry.id);
            stmt.executeUpdate(null);
            conn.commit();
        }
        finally {
            stmt.close();
            conn.close();
        }
    }

    public static int getNodePlacement(double nodeId) throws InformException {
        if (MtdEngine.isNodeInTrash(nodeId)) {
            return 1;
        }
        Node node = MtdEngine.getNode(nodeId);
        if (node == null) {
            return -1;
        }
        return 0;
    }

    public static String getNodeName(double nodeId) throws InformException {
        Node node = MtdEngine.getNode(nodeId);
        if (node == null) {
            return null;
        }
        return node.getName();
    }

    public static String tryGetNodeName(double nodeId) {
        try {
            return MtdEngine.getNodeName(nodeId);
        }
        catch (InformException ex) {
            Core.logger.error(null, ex);
            return null;
        }
    }

    public static String tryGetUserName(double nodeId) {
        try {
            UserNode node = MtdEngine.getUserNode(nodeId);
            if (node == null) {
                return null;
            }
            return node.getName();
        }
        catch (InformException ex) {
            Core.logger.error(null, ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidate() {
        Object object = nodesMutex;
        synchronized (object) {
            reloadTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean wasLoaded() {
        boolean result = false;
        Object object = nodesMutex;
        synchronized (object) {
            result = reloadTime != 0L;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NodeRecord innerRestoreDeletedNode(double id, double parent, double user_id) throws InformException, SQLException {
        NodeRecord nr = null;
        DatabaseConnection conn = DatabaseDescriptor.getMetabase().connectPrivileged("MtdEngine::InnerRestoreDeletedNode #0");
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT into ").append(MetadataNodeReader.mtdTreeTableName);
        sql.append(" (ID, PARENT_ID, NODE_TYPE, NODE_NAME, IDENT_NAME,");
        sql.append(" NODE_DESCRIPTION, OWNER_ID, ORDER_NO, CREATION_TIME, MOD_ATTRS_TIME, MOD_CONTENT_TIME,");
        sql.append(" MOD_USER_ID, ATTRS_B64, RAW_CONTENT, DSL_CONTENT) select NODE_ID, ?,");
        sql.append(" NODE_TYPE, NODE_NAME, IDENT_NAME, NODE_DESCRIPTION, OWNER_ID, ORDER_NO, CREATION_TIME,");
        sql.append(" MOD_ATTRS_TIME, MOD_CONTENT_TIME, ?, ATTRS_B64, RAW_CONTENT, DSL_CONTENT from ");
        sql.append(MetadataNodeReader.mtdTreeLogTableName).append(" where ID = ?");
        PreparedStatement ps = conn.prepareStatement("Metadata.innerRestoreDeletedNode", sql.toString());
        try {
            ps.setDouble(1, parent);
            ps.setDouble(2, user_id);
            ps.setDouble(3, id);
            ps.executeUpdate(null);
        }
        finally {
            ps.close();
            conn.close();
        }
        conn = DatabaseDescriptor.getMetabase().connectPrivileged("MtdEngine::innerRestoreDeletedNode #1");
        sql = new StringBuilder();
        sql.append("SELECT NODE_ID, PARENT_ID, NODE_TYPE, NODE_NAME, IDENT_NAME, NODE_DESCRIPTION, ");
        sql.append("OWNER_ID, ORDER_NO, CREATION_TIME, MOD_ATTRS_TIME, MOD_CONTENT_TIME, ATTRS_B64, ");
        sql.append("RAW_CONTENT, DSL_CONTENT FROM ").append(MetadataNodeReader.mtdTreeLogTableName);
        sql.append(" where ID = ?");
        ps = conn.prepareStatement("Metadata.innerRestoreDeletedNode #2", sql.toString());
        try {
            ps.setDouble(1, id);
            try (ResultSet rs = ps.executeQuery(null);){
                if (rs.next()) {
                    nr = new NodeRecord(NodeStatus.MODIFIED);
                    int index = 1;
                    nr.setId(rs.getDouble(index++));
                    nr.setParentId(rs.getDouble(index++));
                    nr.setType(rs.getInt(index++));
                    nr.setName(rs.getString(index++));
                    nr.setIdentName(rs.getString(index++));
                    nr.setDescription(rs.getString(index++));
                    nr.setOwnerId(rs.getDouble(index++));
                    nr.setOrderNo(rs.getInt(index++));
                    Timestamp time = rs.getTimestamp(index++);
                    nr.setCreationTime(time == null ? System.currentTimeMillis() : time.getTime());
                    time = rs.getTimestamp(index++);
                    nr.setModificationAttributeTime(time == null ? System.currentTimeMillis() : time.getTime());
                    time = rs.getTimestamp(index++);
                    nr.setModificationContentTime(time == null ? System.currentTimeMillis() : time.getTime());
                    nr.setRawAttributes(Base64BinString.Decode(rs.getString(index++)));
                    byte[] content = rs.getBlobBytes(index++);
                    String dslContent = rs.getString(index++);
                    nr.setContent(content, dslContent);
                }
            }
        }
        finally {
            ps.close();
            conn.close();
        }
        return nr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node RestoreDeletedNode(double id, double parent, ServerSideHost ssHost) throws InformException, SQLException {
        NodeRecord record = MtdEngine.innerRestoreDeletedNode(id, parent, ssHost.getUserID());
        if (record != null) {
            MtdEngine.checkNodeRecord(record);
            Node node = MtdCache.createNodeInstance(record);
            try (Connector.Metabase connector = new Connector.Metabase();){
                MtdEngine.createNewNode(null, connector, node, null);
                if (record.getRawContent() != null && record.getRawContent().length != 0) {
                    MtdEngine.setNodeContent(null, ssHost, node.getId(), 0L, record.getRawContent(), record.getDslContent(), ssHost.getUserID(), ssHost.getSessionID(), ssHost.security());
                }
            }
            return node;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeRecord GetLogEntryAttrs(double id) throws InformException, SQLException {
        NodeRecord rec = null;
        DatabaseConnection conn = DatabaseDescriptor.getMetabase().connectPrivileged("MtdEngine::GetLogEntryAttrs");
        StringBuilder sql = new StringBuilder();
        sql.append("select NODE_ID, NODE_TYPE, NODE_NAME, PARENT_ID ");
        sql.append(" from ").append(MetadataNodeReader.mtdTreeLogTableName).append(" where ID = ?");
        try (PreparedStatement ps = conn.prepareStatement("Metadata.InnerRestoreDeletedNode2", sql.toString());){
            ps.setDouble(1, id);
            try (ResultSet rs = ps.executeQuery(null);){
                if (rs.next()) {
                    rec = new NodeRecord();
                    int i = 1;
                    rec.setId(rs.getDouble(i++));
                    rec.setType(rs.getInt(i++));
                    rec.setName(rs.getString(i++));
                    rec.setParentId(rs.getDouble(i++));
                }
            }
        }
        return rec;
    }

    public static void registerFailedLoginCount(double userId, boolean success) {
        if (success) {
            failedLogins.dropLogin(userId);
        } else {
            failedLogins.registerLogin(userId);
        }
    }

    public static boolean isFailedLoginCountExceed(double userId, LogContext.Builder cause) {
        int flc;
        int count = failedLogins.getCount(userId);
        if (count <= 0) {
            return false;
        }
        try {
            flc = MtdEngine.serverNode().descriptor().failedLoginCount;
        }
        catch (InformException e) {
            Core.logger.error(null, e);
            return false;
        }
        if (flc <= 0) {
            failedLogins.clear();
            return false;
        }
        if (count >= flc) {
            if (cause != null) {
                cause.append("failed-login-count-exceed", count);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPin(double nodeId, double pinId) {
        DoubleDoubleMap doubleDoubleMap = pinCache;
        synchronized (doubleDoubleMap) {
            if (pinId == 0.0) {
                pinCache.remove(nodeId);
            } else {
                pinCache.put(nodeId, pinId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getPin(double nodeId) {
        DoubleDoubleMap doubleDoubleMap = pinCache;
        synchronized (doubleDoubleMap) {
            return pinCache.get(nodeId, 0.0);
        }
    }

    private static class MtdUpdater
    implements Runnable {
        private MtdUpdater() {
        }

        @Override
        public void run() {
            try {
                while (!Core.isAgentStopped()) {
                    try {
                        MtdEngine.runUpdateNodes();
                    }
                    catch (Throwable ex) {
                        Core.logger.error("MtdUpdater", ex);
                    }
                    if (!Core.isAgentStopped()) {
                        TimeUnit.SECONDS.sleep(1L);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ex) {
                Core.logger.error("MtdUpdater interrupt", ex);
            }
        }
    }
}

