/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd;

import inform.adt.taggedio.TaggedReader;
import inform.agent.mtd.NodeRecordIntf;
import inform.agent.mtd.request.NodeStatus;
import java.io.ByteArrayInputStream;
import java.util.Arrays;

public class NodeRecord
implements NodeRecordIntf {
    private double id = -1.0;
    private double parentId = 0.0;
    private int type = -1;
    private String name = "";
    private String identName = "";
    private String description = "";
    private double ownerId = 0.0;
    private int orderNo = 0;
    private long creationTime = 0L;
    private long modificationAttributeTime = 0L;
    private long modificationContentTime = 0L;
    private double modificationUserId = 0.0;
    private long applicationTime = 0L;
    private double applicationId = 0.0;
    private double sessionId = 0.0;
    private byte[] rawAttributes = null;
    private byte[] rawContent = null;
    private String dslContent = null;
    private NodeStatus status = null;
    private byte[] contentAttr = null;
    private double replId = 0.0;
    private double replNodeId = 0.0;

    public NodeRecord() {
    }

    public NodeRecord(NodeStatus status) {
        this.status = status;
    }

    public NodeRecord(NodeRecord r) {
        this.id = r.id;
        this.parentId = r.parentId;
        this.type = r.type;
        this.name = r.name;
        this.identName = r.identName;
        this.description = r.description;
        this.ownerId = r.ownerId;
        this.orderNo = r.orderNo;
        this.creationTime = r.creationTime;
        this.modificationAttributeTime = r.modificationAttributeTime;
        this.modificationContentTime = r.modificationContentTime;
        this.modificationUserId = r.modificationUserId;
        this.applicationTime = r.applicationTime;
        this.applicationId = r.applicationId;
        this.sessionId = r.sessionId;
        this.rawAttributes = r.rawAttributes;
        this.contentAttr = r.contentAttr;
        this.rawContent = r.rawContent;
        this.dslContent = r.dslContent;
        this.replId = r.replId;
        this.replNodeId = r.replNodeId;
    }

    public byte[] getRawAttributes() {
        return this.rawAttributes;
    }

    @Override
    public void setRawAttributes(byte[] rawAttributes) {
        this.rawAttributes = rawAttributes;
    }

    public byte[] getContentAttr() {
        return this.contentAttr;
    }

    @Override
    public void setContentAttr(byte[] contentAttr) {
        this.contentAttr = contentAttr;
    }

    public byte[] getRawContent() {
        return this.rawContent;
    }

    public String getDslContent() {
        return this.dslContent;
    }

    public void setContent(byte[] rawContent, String dslContent) {
        this.rawContent = rawContent;
        this.dslContent = dslContent;
    }

    public boolean isAttributesEmpty() {
        return this.rawAttributes == null || this.rawAttributes.length == 0;
    }

    public TaggedReader createAttributesReader() {
        return new TaggedReader(new ByteArrayInputStream(this.rawAttributes));
    }

    public double getApplicationId() {
        return this.applicationId;
    }

    @Override
    public void setApplicationId(double applicationId) {
        this.applicationId = applicationId;
    }

    public long getApplicationTime() {
        return this.applicationTime;
    }

    @Override
    public void setApplicationTime(long applicationTime) {
        this.applicationTime = applicationTime;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        if (description == null) {
            description = "";
        }
        this.description = description;
    }

    public double getId() {
        return this.id;
    }

    public void setId(double id) {
        this.id = id;
    }

    public String getIdentName() {
        return this.identName;
    }

    @Override
    public void setIdentName(String identName) {
        if (identName == null) {
            identName = "";
        }
        this.identName = identName;
    }

    public long getModificationAttributeTime() {
        return this.modificationAttributeTime;
    }

    @Override
    public void setModificationAttributeTime(long modificationAttributeTime) {
        this.modificationAttributeTime = modificationAttributeTime;
    }

    public double getSessionId() {
        return this.sessionId;
    }

    @Override
    public void setSessionId(double sessionId) {
        this.sessionId = sessionId;
    }

    public long getModificationContentTime() {
        return this.modificationContentTime;
    }

    @Override
    public void setModificationContentTime(long modificationContentTime) {
        this.modificationContentTime = modificationContentTime;
    }

    public double getModificationUserId() {
        return this.modificationUserId;
    }

    @Override
    public void setModificationUserId(double modificationUserId) {
        this.modificationUserId = modificationUserId;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            name = "";
        }
        this.name = name;
    }

    public int getOrderNo() {
        return this.orderNo;
    }

    @Override
    public void setOrderNo(int orderNo) {
        this.orderNo = orderNo;
    }

    public double getOwnerId() {
        return this.ownerId;
    }

    @Override
    public void setOwnerId(double ownerId) {
        this.ownerId = ownerId;
    }

    public double getParentId() {
        return this.parentId;
    }

    @Override
    public void setParentId(double parentId) {
        this.parentId = parentId;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    public boolean isSame(NodeRecord r) {
        if (r.id != this.id) {
            return false;
        }
        if (r.parentId != this.parentId) {
            return false;
        }
        if (r.type != this.type) {
            return false;
        }
        if (!r.name.equals(this.name)) {
            return false;
        }
        if (!r.identName.equals(this.identName)) {
            return false;
        }
        if (!r.description.equals(this.description)) {
            return false;
        }
        if (r.orderNo != this.orderNo) {
            return false;
        }
        return Arrays.equals(r.rawAttributes, this.rawAttributes);
    }

    public void clear() {
        this.id = -1.0;
        this.parentId = 0.0;
        this.type = -1;
        this.name = "";
        this.identName = "";
        this.description = "";
        this.ownerId = 0.0;
        this.orderNo = 0;
        this.creationTime = 0L;
        this.modificationAttributeTime = 0L;
        this.modificationContentTime = 0L;
        this.modificationUserId = 0.0;
        this.applicationTime = 0L;
        this.applicationId = 0.0;
        this.sessionId = 0.0;
        this.rawAttributes = null;
        this.rawContent = null;
        this.dslContent = null;
        this.contentAttr = null;
        this.replId = -1.0;
        this.replNodeId = 0.0;
    }

    public NodeStatus getStatus() {
        return this.status;
    }

    public double getReplId() {
        return this.replId;
    }

    @Override
    public void setReplId(double replId) {
        this.replId = replId;
    }

    public double getReplNodeId() {
        return this.replNodeId;
    }

    @Override
    public void setReplNodeId(double replNodeId) {
        this.replNodeId = replNodeId;
    }
}

