/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd;

import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.db.connect.Connector;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseType;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.net.Client;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class TicketEngine {
    public static final int TICKET_EXPIRE_INTERVAL_SENONDS = 60;
    public static final double TICKET_EXPIRE_INTERVAL = 6.944444444444445E-4;
    public static final int TICKET_OBSOLETE_INTERVAL_SENONDS = 1800;
    public static final double TICKET_OBSOLETE_INTERVAL = 0.020833333333333332;
    public static final int TICKET_DELETE_COUNTER = 8;
    public static final int OPEN_NODE_CODE = 1;
    private static AtomicInteger atomicInt = null;
    public static boolean deletingTickets = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ticket getNewTicket(double nodeId, int code, Client client) throws SQLException, NoSuchAlgorithmException {
        try (Connector.Metabase connector = new Connector.Metabase();){
            Ticket ticket = new Ticket(nodeId, code, client);
            if (ticket.insert(connector.connection())) {
                Ticket ticket2 = ticket;
                return ticket2;
            }
            Ticket ticket3 = null;
            return ticket3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Double> findTicket(double nodeId, int code, String key) throws SQLException {
        ArrayList<Double> res = new ArrayList<Double>();
        if (key == null || key.isEmpty()) {
            return res;
        }
        try (Connector.Metabase connector = new Connector.Metabase();){
            DatabaseConnection connection = connector.connection();
            DatabaseCaps caps = connection.getDescriptor().getDatabaseType().caps();
            StringBuilder sql = new StringBuilder();
            sql.append("select ");
            caps.fetchLimitBeginning(1, sql);
            sql.append("ID").append(',');
            sql.append("USER_ID");
            sql.append(" from ").append(MetadataNodeReader.mtdTicketsTableName);
            sql.append(" where ").append("NODE_ID").append("=?");
            sql.append(" and ").append("OP_CODE").append("=?");
            sql.append(" and ").append("KEY").append("=?");
            sql.append(" and ((");
            if (connection.getDescriptor().getDatabaseType() == DatabaseType.H2) {
                sql.append("DATEDIFF('SECOND', ").append("CREATION_TIME").append(", ").append(caps.currentDateTime()).append(")");
            } else {
                caps.daysBetween(sql, caps.currentDateTime(), "CREATION_TIME");
            }
            sql.append(") < ?)");
            sql.append(" order by ").append("CREATION_TIME").append(" desc");
            sql = caps.fetchLimitEnding(1, sql);
            try (PreparedStatement statement = connection.prepareStatement("TicketEngine.findTicket", sql.toString());){
                statement.setDouble(1, nodeId);
                statement.setInt(2, code);
                statement.setString(3, key);
                if (connection.getDescriptor().getDatabaseType() == DatabaseType.H2) {
                    statement.setDouble(4, 60.0);
                } else {
                    statement.setDouble(4, 6.944444444444445E-4);
                }
                try (ResultSet resultSet = statement.executeQuery(connection.getSSContext());){
                    if (resultSet.next()) {
                        res.add(resultSet.getAsDouble(1));
                        res.add(resultSet.getAsDouble(2));
                    }
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteExpireAndObsoleteTickets(double pid) throws SQLException {
        try (Connector.Metabase connector = new Connector.Metabase();){
            DatabaseConnection connection = connector.connection();
            DatabaseCaps caps = connection.getDescriptor().getDatabaseType().caps();
            StringBuilder sql = new StringBuilder();
            sql.append("delete from ");
            sql.append(MetadataNodeReader.mtdTicketsTableName).append(" where (");
            sql.append("ID").append("=?)");
            boolean withOldTickets = false;
            if (deletingTickets) {
                withOldTickets = true;
                deletingTickets = false;
            }
            if (withOldTickets) {
                sql.append(" or ((");
                if (connection.getDescriptor().getDatabaseType() == DatabaseType.H2) {
                    sql.append("DATEDIFF('SECOND', ").append("CREATION_TIME").append(", ").append(caps.currentDateTime()).append(")");
                } else {
                    caps.daysBetween(sql, caps.currentDateTime(), "CREATION_TIME");
                }
                sql.append(") > ?)");
            }
            try (PreparedStatement statement = connection.prepareStatement("TicketEngine.deleteObsoleteTickets", sql.toString());){
                statement.setDouble(1, pid);
                if (withOldTickets) {
                    if (connection.getDescriptor().getDatabaseType() == DatabaseType.H2) {
                        statement.setDouble(2, 1800.0);
                    } else {
                        statement.setDouble(2, 0.020833333333333332);
                    }
                }
                statement.executeUpdate(connection.getSSContext());
            }
            connection.commit();
        }
    }

    public static class Ticket {
        private final double _nodeId;
        private final String _ipAddress;
        private final int _opCode;
        private final double _userId;
        private final double _sessionId;
        private String _key;

        Ticket(double nodeId, int code, Client client) {
            this._nodeId = nodeId;
            this._ipAddress = client.getSession().socketAddress().getAddress().getHostAddress();
            this._opCode = code;
            this._userId = client.getUserId();
            this._sessionId = client.getSessionId();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean insert(DatabaseConnection connection) throws SQLException, NoSuchAlgorithmException {
            DatabaseCaps caps = connection.getDescriptor().getDatabaseType().caps();
            String sql = "insert into " + MetadataNodeReader.mtdTicketsTableName + " (ID, IP_ADDRESS, OP_CODE, NODE_ID, USER_ID, SESSION_ID, KEY, CREATION_TIME) values (?, ?, ?, ?, ?, ?, ?," + caps.currentDateTime() + ")";
            double genID = Core.generateId();
            String message = String.valueOf(genID);
            MessageDigest md5 = MessageDigest.getInstance("md5");
            md5.update(message.getBytes(TaggedWriter.ANSI));
            if (atomicInt == null) {
                atomicInt = new AtomicInteger(0);
                deletingTickets = true;
            }
            atomicInt.incrementAndGet();
            if (!deletingTickets) {
                deletingTickets = atomicInt.intValue() % 8 == 0;
            }
            message = String.valueOf(atomicInt.intValue());
            md5.update(message.getBytes(TaggedWriter.ANSI));
            this._key = new String(Core.base64ToStr(md5.digest())).replaceAll("\\+", "_");
            try (PreparedStatement statement = connection.prepareStatement("TicketEngine.insertLock", sql);){
                statement.setDouble(1, genID);
                statement.setString(2, this._ipAddress);
                statement.setInt(3, this._opCode);
                statement.setDouble(4, this._nodeId);
                statement.setDouble(5, this._userId);
                statement.setDouble(6, this._sessionId);
                statement.setString(7, this._key);
                try {
                    statement.executeUpdate(connection.getSSContext());
                    connection.commit();
                    boolean bl = true;
                    return bl;
                }
                catch (SQLException e) {
                    Core.logger.error(null, e);
                    try {
                        connection.rollback();
                    }
                    catch (Throwable t) {
                        Core.logger.error(null, t);
                    }
                    boolean bl = false;
                    statement.close();
                    return bl;
                }
            }
        }

        public double getNodeId() {
            return this._nodeId;
        }

        public String getIpAddress() {
            return this._ipAddress;
        }

        public String getKey() {
            return this._key;
        }

        public int getOpCode() {
            return this._opCode;
        }

        public double getUserId() {
            return this._userId;
        }

        public double getSessionId() {
            return this._sessionId;
        }
    }
}

