/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.collections.DoubleSet;
import inform.adt.collections.IntHashMap;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.ClosableResult;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.Row;
import inform.agent.db.RowsetAccessor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.commit.AuditInfo;
import inform.agent.db.commit.AuditModification;
import inform.agent.db.commit.TableDataAudit;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.types.SqlDataType;
import inform.agent.db.utils.SqlParameter;
import inform.agent.db.utils.SqlParameterList;
import inform.agent.db.utils.SqlStringBuilder;
import inform.agent.mtd.AuditJournal;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.RolesTable;
import inform.agent.mtd.SystemTable;
import inform.agent.mtd.nodes.ServerNode;
import inform.agent.mtd.nodes.UserNode;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.BlobField;
import inform.agent.scripts.DatasetField;
import inform.agent.scripts.SSContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.BitSet;

public class UsersTable
extends SystemTable {
    private final FieldDescriptor[] fields = new FieldDescriptor[22];
    private FieldDescriptor primaryKey = null;
    private SqlParameter[] values = null;
    public static final int utfID = 0;
    public static final int utfLogin = 1;
    public static final int utfGroup = 2;
    public static final int utfSettings = 3;
    public static final int utfLocked = 4;
    public static final int utfFIO = 5;
    public static final int utfIsValid = 6;
    public static final int utfIcon = 7;
    public static final int utfPhone = 8;
    public static final int utfEMail = 9;
    public static final int utfCardID = 10;
    public static final int utfDeleted = 11;
    public static final int utfServiceAccount = 12;
    public static final int utfActiveDirectory = 13;
    public static final int utfInheritedStartup = 14;
    public static final int utfRootNode = 15;
    public static final int utfStartNode = 16;
    public static final int utfStartAction = 17;
    public static final int utfStartScript = 18;
    public static final int utfStartWebNode = 19;
    public static final int utfServerManaged = 20;
    public static final int utfServerManagedEndDate = 21;
    public static final int utfCount = 22;
    private static final SystemTable.SystemFieldDesc[] UTF_DESC = new SystemTable.SystemFieldDesc[]{new SystemTable.SystemFieldDesc("ID", keyTypes), new SystemTable.SystemFieldDesc("\u0418\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f", strTypes), new SystemTable.SystemFieldDesc("\u0413\u0440\u0443\u043f\u043f\u0430", metaTypes), new SystemTable.SystemFieldDesc("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438", blobTypes), new SystemTable.SystemFieldDesc("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d", boolTypes), new SystemTable.SystemFieldDesc("\u0424.\u0418.\u041e.", strTypes), new SystemTable.SystemFieldDesc("\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0437\u0430\u043f\u0438\u0441\u0438", boolTypes), new SystemTable.SystemFieldDesc("\u0420\u0438\u0441\u0443\u043d\u043e\u043a", intTypes), new SystemTable.SystemFieldDesc("\u0422\u0435\u043b\u0435\u0444\u043e\u043d", strTypes), new SystemTable.SystemFieldDesc("e-mail", strTypes), new SystemTable.SystemFieldDesc("Card ID", keyTypes), new SystemTable.SystemFieldDesc("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0443\u0434\u0430\u043b\u0435\u043d", boolTypes), new SystemTable.SystemFieldDesc("\u0421\u043b\u0443\u0436\u0435\u0431\u043d\u0430\u044f \u0443\u0447\u0435\u0442\u043d\u0430\u044f \u0437\u0430\u043f\u0438\u0441\u044c", boolTypes), new SystemTable.SystemFieldDesc("\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u0434\u043e\u043c\u0435\u043d\u043d\u043e\u0439 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438", boolTypes), new SystemTable.SystemFieldDesc("\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u043d\u0430\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0442\u0430\u0440\u0442\u043e\u0432\u044b\u0445 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a", boolTypes), new SystemTable.SystemFieldDesc("\u041a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u0443\u0437\u0435\u043b", metaTypes), new SystemTable.SystemFieldDesc("\u0421\u0442\u0430\u0440\u0442\u043e\u0432\u044b\u0439 \u0443\u0437\u0435\u043b", metaTypes), new SystemTable.SystemFieldDesc("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u0434\u043b\u044f \u0441\u0442\u0430\u0440\u0442\u043e\u0432\u043e\u0433\u043e \u0443\u0437\u043b\u0430", intTypes), new SystemTable.SystemFieldDesc("\u0421\u0442\u0430\u0440\u0442\u043e\u0432\u044b\u0439 \u0441\u0446\u0435\u043d\u0430\u0440\u0438\u0439", metaTypes), new SystemTable.SystemFieldDesc("\u0421\u0442\u0430\u0440\u0442\u043e\u0432\u044b\u0439 \u0443\u0437\u0435\u043b (web)", metaTypes), new SystemTable.SystemFieldDesc("\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c: \u043f\u0440\u0438\u0437\u043d\u0430\u043a", boolTypes), new SystemTable.SystemFieldDesc("\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c: \u0434\u0430\u0442\u0430 \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438", dateTypes)};

    public UsersTable() throws IOException {
        this(((ServerNode)MtdEngine.getValidNode(2.0)).descriptor(), true);
    }

    public UsersTable(boolean throwExceptions) throws IOException {
        this(((ServerNode)MtdEngine.getValidNode(2.0)).descriptor(), throwExceptions);
    }

    public UsersTable(ServerNode.Descriptor descriptor) throws IOException {
        this(descriptor, true);
    }

    public UsersTable(ServerNode.Descriptor descriptor, boolean throwExceptions) throws IOException {
        int utf;
        assert (UTF_DESC.length == 22);
        byte[] content = descriptor.usersTable;
        if (content == null || content.length == 0) {
            return;
        }
        TaggedReader in = new TaggedReader(content);
        BitSet loadedUtf = new BitSet();
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    double tableId = in.getNodeID();
                    if (tableId == 0.0) {
                        return;
                    }
                    this.table = TableDescriptor.getIfExists(tableId);
                    if (this.table != null) break;
                    if (throwExceptions) {
                        throw new InformException("\u0422\u0430\u0431\u043b\u0438\u0446\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 [" + (long)tableId + "]");
                    }
                    return;
                }
                case 2: {
                    if (this.table == null) {
                        return;
                    }
                    utf = in.getInt();
                    loadedUtf.set(utf);
                    if (utf < 0 || this.fields.length <= utf) break;
                    int fieldId = in.getInt(3);
                    this.fields[utf] = this.table.getFieldDescriptor(fieldId);
                    break;
                }
                case 4: {
                    this.enabled = in.getBoolean();
                }
            }
        }
        for (utf = 0; utf < this.fields.length; ++utf) {
            FieldDescriptor field = this.fields[utf];
            SystemTable.SystemFieldDesc d = UTF_DESC[utf];
            if (field == null) {
                if (!UsersTable.isImportantField(utf)) continue;
                TableDescriptor t = this.table;
                this.table = null;
                if (throwExceptions) {
                    if (loadedUtf.get(utf)) {
                        throw new InformException("\u0412 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043e \u043f\u043e\u043b\u0435 " + d.name + " (\u0442\u0430\u0431\u043b\u0438\u0446\u0430 " + t.toString() + ")");
                    }
                    throw new InformException("\u0412 \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0435 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043f\u043e\u043b\u0435 " + d.name + " (\u0442\u0430\u0431\u043b\u0438\u0446\u0430 " + t.toString() + ")");
                }
                return;
            }
            if (d.isValid(field.getType().toInt())) continue;
            TableDescriptor t = this.table;
            this.table = null;
            if (throwExceptions) {
                throw new InformException("\u041f\u043e\u043b\u0435 " + field.getCaption() + "(" + d.name + ") \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f (\u0442\u0430\u0431\u043b\u0438\u0446\u0430: " + t.toString() + ")");
            }
            return;
        }
        this.primaryKey = this.table.getRecordIdField();
    }

    private boolean isExtraInsertableProp(int utf) {
        switch (utf) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                return false;
            }
        }
        return 0 <= utf && utf < 22 && this.fields[utf] != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertUserEx(SSContext ssContext, ServerSideHost ssHost, double userId, String login, double parentGroupId, SqlParameter[] props) throws SQLException {
        if (this.table == null) {
            throw new InformException("\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u0430 \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439");
        }
        SqlStringBuilder sql = new SqlStringBuilder();
        this.selectSql(sql);
        sql.append(" where ").append(this.fields[0]).append("=? or ").append(this.fields[1]).append("=?");
        try (DatabaseConnection connection = this.table.getDatabaseDescriptor().connect(ssHost, "UsersTable.insertUser");){
            int utf;
            double recordId = userId;
            AuditModification auditModification = null;
            boolean dedicId = this.fields[0] != this.primaryKey;
            TableDataAudit audit = new TableDataAudit(ssContext, connection, ssHost.getUserID(), ssHost.getEffectiveUserID(), 0.0, 0.0, ssHost.getSessionID());
            audit.setOwnerId(ssHost.getNodeID());
            SqlParameter[] parameters = null;
            try (PreparedStatement statement = connection.prepareStatement("UsersTable.insertUser", sql.toString());){
                statement.setDouble(1, userId);
                statement.setString(2, login);
                try (ResultSet fetch = statement.executeQuery(ssContext);){
                    FieldDescriptor isValidField = this.fields[6];
                    while (fetch.next()) {
                        this.readSelect(fetch);
                        if (isValidField == null || this.values[6].getAsBoolean()) {
                            if (this.values[0].getDouble() == userId) {
                                throw new InformException("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0441 \u0442\u0430\u043a\u0438\u043c id \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
                            }
                            throw new InformException("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u043c\u0435\u043d\u0435\u043c \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
                        }
                        if (parameters == null || this.values[3].isBlobEmpty() && !parameters[3].isBlobEmpty()) {
                            parameters = this.values;
                        }
                        if (!dedicId) continue;
                        recordId = fetch.getDouble(fetch.getColumnCount());
                    }
                }
            }
            if (parameters != null && props == null) {
                auditModification = AuditModification.MODIFY;
                sql = new SqlStringBuilder();
                sql.append("update ").appendFull(this.table).append(" set ").append(this.fields[1]).append("=?,").append(this.fields[2]).append("=?,");
                if (this.fields[6] != null) {
                    sql.append(this.fields[6]).append("=?,");
                }
                sql.append(" where ").append(this.fields[0]).append("=?");
                AuditInfo auditInfo = new AuditInfo(audit, this.table, recordId, auditModification);
                statement = connection.prepareStatement("UsersTable.insertUser", sql.toString());
                try {
                    int i = 0;
                    statement.setString(++i, login);
                    auditInfo.setField(this.fields[1]).setString(login);
                    if (parentGroupId == 0.0) {
                        statement.setNull(++i, SqlDataType.DOUBLE);
                        auditInfo.setField(this.fields[2]).setNull();
                    } else {
                        statement.setDouble(++i, parentGroupId);
                        auditInfo.setField(this.fields[2]).setNumber(parentGroupId);
                    }
                    if (this.fields[6] != null) {
                        statement.setBoolean(++i, true);
                        auditInfo.setField(this.fields[2]).setNumber(1.0);
                    }
                    statement.setDouble(++i, userId);
                    statement.executeUpdate(ssContext);
                }
                finally {
                    statement.close();
                }
            }
            auditModification = AuditModification.APPEND;
            sql = new SqlStringBuilder();
            sql.append("insert into ").appendFull(this.table).append(" (").append(this.fields[0]).append(',').append(this.fields[1]).append(',').append(this.fields[4]);
            if (this.fields[6] != null) {
                sql.append(',').append(this.fields[6]);
            }
            if (parentGroupId != 0.0) {
                sql.append(',').append(this.fields[2]);
            }
            if (dedicId) {
                sql.append(',').append(this.primaryKey);
            }
            if (this.fields[11] != null) {
                sql.append(',').append(this.fields[11]);
            }
            if (this.fields[12] != null) {
                sql.append(',').append(this.fields[12]);
            }
            boolean initialLocked = true;
            if (props != null) {
                for (SqlParameter prop : props) {
                    utf = prop.getId();
                    if (this.isExtraInsertableProp(utf)) {
                        sql.append(',').append(this.fields[utf]);
                        continue;
                    }
                    if (utf != 4) continue;
                    initialLocked = prop.getAsBoolean();
                }
            }
            sql.append(") values (?,?,?");
            if (this.fields[6] != null) {
                sql.append(",?");
            }
            if (parentGroupId != 0.0) {
                sql.append(",?");
            }
            if (dedicId) {
                recordId = Core.generateId();
                sql.append(",?");
            }
            if (this.fields[11] != null) {
                sql.append(",?");
            }
            if (this.fields[12] != null) {
                sql.append(",?");
            }
            if (props != null) {
                for (SqlParameter prop : props) {
                    utf = prop.getId();
                    if (!this.isExtraInsertableProp(utf)) continue;
                    sql.append(",?");
                }
            }
            AuditInfo auditInfo = new AuditInfo(audit, this.table, recordId, auditModification);
            sql.append(")");
            statement = connection.prepareStatement("UsersTable.insertUser", sql.toString());
            try {
                int i = 0;
                statement.setDouble(++i, userId);
                auditInfo.setField(this.fields[0]).setNumber(userId);
                statement.setString(++i, login);
                auditInfo.setField(this.fields[1]).setString(login);
                statement.setBoolean(++i, initialLocked);
                auditInfo.setField(this.fields[4]).setNumber(initialLocked ? 1.0 : 0.0);
                if (this.fields[6] != null) {
                    statement.setBoolean(++i, true);
                    auditInfo.setField(this.fields[6]).setNumber(1.0);
                }
                if (parentGroupId != 0.0) {
                    statement.setDouble(++i, parentGroupId);
                    auditInfo.setField(this.fields[2]).setNumber(parentGroupId);
                }
                if (dedicId) {
                    statement.setDouble(++i, recordId);
                }
                if (this.fields[11] != null) {
                    statement.setBoolean(++i, false);
                    auditInfo.setField(this.fields[11]).setNumber(0.0);
                }
                if (this.fields[12] != null) {
                    statement.setBoolean(++i, false);
                    auditInfo.setField(this.fields[12]).setNumber(0.0);
                }
                if (props != null) {
                    for (SqlParameter prop : props) {
                        int utf2 = prop.getId();
                        if (!this.isExtraInsertableProp(utf2)) continue;
                        prop.applyTo(i, auditInfo, this.fields[utf2]);
                        prop.applyTo(++i, statement);
                    }
                }
                statement.executeUpdate(ssContext);
            }
            finally {
                statement.close();
            }
            audit.registrateModification(this.table, recordId, auditModification);
            audit.flush();
            connection.commit();
        }
        AuditJournal.registerAuthChangeEvent(ssContext, ssHost.getUserID(), ssHost.getSessionID(), userId);
    }

    public void insertUser(SSContext ssContext, ServerSideHost ssHost, double userId, String login, double parentGroupId) throws SQLException {
        this.insertUserEx(ssContext, ssHost, userId, login, parentGroupId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double readRecordId(SSContext ssContext, DatabaseConnection connection, double userId) throws SQLException {
        if (this.table == null) {
            return userId;
        }
        if (this.fields[0] == this.primaryKey) {
            return userId;
        }
        SqlStringBuilder sql = new SqlStringBuilder();
        sql.append("select ").append(this.primaryKey).append(" from ").appendFull(this.table).append(" where ").append(this.fields[0]).append("=?");
        try (PreparedStatement statement = connection.prepareStatement("UsersTable.readRecordId", sql.toString());){
            statement.setDouble(1, userId);
            try (ResultSet fetch = statement.executeQuery(ssContext);){
                if (fetch.next()) {
                    double d = fetch.getDouble(1);
                    return d;
                }
            }
        }
        return userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getValidRecordId(SSContext ssContext, ServerSideHost ssHost, double userId) throws SQLException {
        if (this.table == null) {
            return userId;
        }
        if (this.fields[0] == this.primaryKey) {
            return userId;
        }
        try (DatabaseConnection connection = this.table.getDatabaseDescriptor().connect(ssHost, "UsersTable.getValidRecordId");){
            Double d;
            try {
                d = this.readValidRecordId(ssContext, connection, userId);
            }
            catch (Throwable throwable) {
                connection.commit();
                throw throwable;
            }
            connection.commit();
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Double readValidRecordId(SSContext ssContext, DatabaseConnection connection, double userId) throws SQLException {
        if (this.table == null) {
            return userId;
        }
        if (this.fields[0] == this.primaryKey) {
            return userId;
        }
        SqlStringBuilder sql = new SqlStringBuilder();
        sql.append("select ").append(this.primaryKey).append(" from ").appendFull(this.table).append(" where ").append(this.fields[0]).append("=?");
        try (PreparedStatement statement = connection.prepareStatement("UsersTable.readRecordId", sql.toString());){
            statement.setDouble(1, userId);
            try (ResultSet fetch = statement.executeQuery(ssContext);){
                if (fetch.next()) {
                    Double d = fetch.getDouble(1);
                    return d;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDelete(SSContext ssContext, ServerSideHost ssHost, double userId, boolean deleted) throws SQLException {
        if (this.table == null || userId == 0.0 || this.fields[11] == null) {
            return;
        }
        SqlStringBuilder sql = new SqlStringBuilder();
        sql.append("update ").appendFull(this.table).append(" set ").append(this.fields[11]).append("=?  where ").append(this.fields[0]).append("=?");
        try (DatabaseConnection connection = this.table.getDatabaseDescriptor().connect(ssHost, "UsersTable.select by userId");){
            Double recordId = this.readValidRecordId(ssContext, connection, userId);
            if (recordId == null) {
                return;
            }
            TableDataAudit audit = new TableDataAudit(ssContext, connection, ssHost.getUserID(), ssHost.getEffectiveUserID(), 0.0, 0.0, ssHost.getSessionID());
            audit.setOwnerId(ssHost.getNodeID());
            try (PreparedStatement statement = connection.prepareStatement("UsersTable.select by userId", sql.toString());){
                AuditInfo auditInfo = new AuditInfo(audit, this.table, recordId, AuditModification.MODIFY);
                auditInfo.setField(this.fields[11]).setNumber(deleted ? 1.0 : 0.0);
                int i = 0;
                statement.setBoolean(++i, deleted);
                statement.setDouble(++i, userId);
                statement.executeUpdate(ssContext);
            }
            audit.registrateModification(this.table, recordId, AuditModification.MODIFY);
            audit.flush();
            connection.commit();
        }
        AuditJournal.registerAuthChangeEvent(ssContext, ssHost.getUserID(), ssHost.getSessionID(), userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateServerManagedEndDate(SSContext ssContext, ServerSideHost ssHost, double userId, double endDate) throws SQLException {
        if (this.table == null || userId == 0.0) {
            return false;
        }
        if (this.fields[21] == null) {
            return false;
        }
        SqlStringBuilder sql = new SqlStringBuilder();
        sql.append("update ").appendFull(this.table).append(" set ").append(this.fields[21]).append("=?");
        sql.append(" where ").append(this.fields[0]).append("=?");
        try (DatabaseConnection connection = this.table.getDatabaseDescriptor().connect(ssHost, "UsersTable.updateServerManagedEndDate");){
            double recordId = this.readRecordId(ssContext, connection, userId);
            TableDataAudit audit = new TableDataAudit(ssContext, connection, ssHost.getUserID(), ssHost.getEffectiveUserID(), 0.0, 0.0, ssHost.getSessionID());
            audit.setOwnerId(ssHost.getNodeID());
            AuditInfo auditInfo = new AuditInfo(audit, this.table, recordId, AuditModification.MODIFY);
            try (PreparedStatement statement = connection.prepareStatement("UsersTable.updateServerManagedEndDate", sql.toString());){
                int i = 0;
                statement.setDateTime(++i, endDate);
                auditInfo.setField(this.fields[21]).setDateTime(endDate);
                statement.setDouble(++i, userId);
                statement.executeUpdate(ssContext);
            }
            audit.registrateModification(this.table, recordId, AuditModification.MODIFY);
            audit.flush();
            connection.commit();
        }
        AuditJournal.registerAuthChangeEvent(ssContext, ssHost != null ? ssHost.getUserID() : 0.0, ssHost != null ? ssHost.getSessionID() : 0.0, userId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(SSContext ssContext, ServerSideHost ssHost, double userId, String login, double parentGroupId, boolean locked, UpdateParams updateParams, RolesTable rolesTable) throws SQLException {
        if (this.table == null || userId == 0.0) {
            return false;
        }
        SqlStringBuilder sql = new SqlStringBuilder();
        sql.append("update ").appendFull(this.table).append(" set ").append(this.fields[1]).append("=?,").append(this.fields[2]).append("=?,").append(this.fields[4]).append("=?,");
        if (this.fields[13] != null) {
            sql.append(this.fields[13]).append("=?,");
        }
        if (this.fields[14] != null) {
            sql.append(this.fields[14]).append("=?,");
        }
        if (this.fields[15] != null) {
            sql.append(this.fields[15]).append("=?,");
        }
        if (this.fields[16] != null) {
            sql.append(this.fields[16]).append("=?,");
        }
        if (this.fields[17] != null) {
            sql.append(this.fields[17]).append("=?,");
        }
        if (this.fields[18] != null) {
            sql.append(this.fields[18]).append("=?,");
        }
        if (this.fields[19] != null) {
            sql.append(this.fields[19]).append("=?,");
        }
        if (updateParams.props != null) {
            if (this.fields[5] != null) {
                sql.append(this.fields[5]).append("=?,");
            }
            if (this.fields[8] != null) {
                sql.append(this.fields[8]).append("=?,");
            }
            if (this.fields[9] != null) {
                sql.append(this.fields[9]).append("=?,");
            }
            if (this.fields[10] != null) {
                sql.append(this.fields[10]).append("=?,");
            }
            if (this.fields[20] != null) {
                sql.append(this.fields[20]).append("=?,");
            }
            if (this.fields[21] != null) {
                sql.append(this.fields[21]).append("=?,");
            }
        }
        sql.append(this.fields[3]).append("=?");
        sql.append(" where ").append(this.fields[0]).append("=?");
        try (DatabaseConnection connection = this.table.getDatabaseDescriptor().connect(ssHost, "UsersTable.select by userId");){
            double recordId = this.readRecordId(ssContext, connection, userId);
            TableDataAudit audit = new TableDataAudit(ssContext, connection, ssHost.getUserID(), ssHost.getEffectiveUserID(), 0.0, 0.0, ssHost.getSessionID());
            AuditInfo auditInfo = new AuditInfo(audit, this.table, recordId, AuditModification.MODIFY);
            try (PreparedStatement statement = connection.prepareStatement("UsersTable.select by userId", sql.toString());){
                int i = 0;
                statement.setString(++i, login);
                auditInfo.setField(this.fields[1]).setString(login);
                if (parentGroupId == 0.0) {
                    statement.setNull(++i, SqlDataType.DOUBLE);
                    auditInfo.setField(this.fields[2]).setNull();
                } else {
                    statement.setDouble(++i, parentGroupId);
                    auditInfo.setField(this.fields[2]).setNumber(parentGroupId);
                }
                statement.setBoolean(++i, locked);
                auditInfo.setField(this.fields[4]).setNumber(locked ? 1.0 : 0.0);
                if (this.fields[13] != null) {
                    statement.setBoolean(++i, updateParams.adLogin);
                    auditInfo.setField(this.fields[13]).setNumber(updateParams.adLogin ? 1.0 : 0.0);
                }
                if (this.fields[14] != null) {
                    statement.setBoolean(++i, updateParams.inheritedStartup);
                    auditInfo.setField(this.fields[14]).setNumber(updateParams.inheritedStartup ? 1.0 : 0.0);
                }
                if (this.fields[15] != null) {
                    statement.setDouble(++i, updateParams.rootNode);
                    auditInfo.setField(this.fields[15]).setNumber(updateParams.rootNode);
                }
                if (this.fields[16] != null) {
                    statement.setDouble(++i, updateParams.startNode);
                    auditInfo.setField(this.fields[16]).setNumber(updateParams.startNode);
                }
                if (this.fields[17] != null) {
                    statement.setInt(++i, updateParams.startAction);
                    auditInfo.setField(this.fields[17]).setNumber(updateParams.startAction);
                }
                if (this.fields[18] != null) {
                    statement.setDouble(++i, updateParams.startScript);
                    auditInfo.setField(this.fields[18]).setNumber(updateParams.startScript);
                }
                if (this.fields[19] != null) {
                    statement.setDouble(++i, updateParams.startWebNode);
                    auditInfo.setField(this.fields[19]).setNumber(updateParams.startWebNode);
                }
                if (updateParams.props != null) {
                    if (this.fields[5] != null) {
                        statement.setString(++i, updateParams.props.getFio());
                        auditInfo.setField(this.fields[5]).setString(updateParams.props.getFio());
                    }
                    if (this.fields[8] != null) {
                        statement.setString(++i, updateParams.props.getPhone());
                        auditInfo.setField(this.fields[8]).setString(updateParams.props.getPhone());
                    }
                    if (this.fields[9] != null) {
                        statement.setString(++i, updateParams.props.getEmail());
                        auditInfo.setField(this.fields[9]).setString(updateParams.props.getEmail());
                    }
                    if (this.fields[10] != null) {
                        if (updateParams.props.getCardId() == 0.0) {
                            statement.setNull(++i, SqlDataType.DOUBLE);
                            auditInfo.setField(this.fields[10]).setNull();
                        } else {
                            statement.setDouble(++i, updateParams.props.getCardId());
                            auditInfo.setField(this.fields[10]).setNumber(updateParams.props.getCardId());
                        }
                    }
                    if (this.fields[20] != null) {
                        statement.setBoolean(++i, updateParams.props.getServerManaged());
                        auditInfo.setField(this.fields[20]).setNumber(updateParams.props.getServerManaged() ? 1.0 : 0.0);
                    }
                    if (this.fields[21] != null) {
                        if (updateParams.props.getServerManagedEndDate() == 0.0) {
                            statement.setNull(++i, SqlDataType.DATE_TIME);
                            auditInfo.setField(this.fields[21]).setNull();
                        } else {
                            statement.setDateTime(++i, updateParams.props.getServerManagedEndDate());
                            auditInfo.setField(this.fields[21]).setDateTime(updateParams.props.getServerManagedEndDate());
                        }
                    }
                }
                statement.setBlob(++i, updateParams.content, updateParams.contentLength);
                auditInfo.setField(this.fields[3]).setBlob(Arrays.copyOf(updateParams.content, updateParams.contentLength));
                statement.setDouble(++i, userId);
                statement.executeUpdate(ssContext);
            }
            if (rolesTable.enabled() && updateParams.roles != null) {
                rolesTable.update(ssContext, ssHost, connection, userId, updateParams.roles, updateParams.rolesPrimaryKeys);
            }
            audit.registrateModification(this.table, recordId, AuditModification.MODIFY);
            audit.flush();
            connection.commit();
        }
        AuditJournal.registerAuthChangeEvent(ssContext, ssHost != null ? ssHost.getUserID() : 0.0, ssHost != null ? ssHost.getSessionID() : 0.0, userId);
        return true;
    }

    public SqlParameter[] selectFromDatasource(RowsetAccessor ra) throws Exception {
        if (this.table == null) {
            return null;
        }
        TableDescriptor t = ra.getTableDescriptor();
        if (t == null || t.getNodeId() != this.table.getNodeId()) {
            return null;
        }
        this.values = new SqlParameter[22];
        block7: for (int utf = 0; utf < this.fields.length; ++utf) {
            FieldDescriptor f = this.fields[utf];
            if (f == null) continue;
            if (f.getId() == -1) {
                Row row = ra.getCurrentRow();
                if (row == null) {
                    return null;
                }
                this.values[utf] = new SqlParameter().setDouble(row.getId());
                continue;
            }
            DatasetField field = ra.findfieldById(f.getId());
            if (field == null) {
                return null;
            }
            SqlDataType type = f.getType().toSqlDataType();
            if (field.getIsNull()) {
                this.values[utf] = new SqlParameter(type);
                continue;
            }
            switch (type) {
                case BOOLEAN: {
                    this.values[utf] = new SqlParameter().setBoolean(field.getAsNumber() != 0.0);
                    continue block7;
                }
                case INTEGER: 
                case DOUBLE: {
                    this.values[utf] = new SqlParameter().setDouble(field.getAsNumber());
                    continue block7;
                }
                case STRING: 
                case UNICODE: {
                    this.values[utf] = new SqlParameter().setString(field.getAsString());
                    continue block7;
                }
                case DATE_TIME: 
                case TIMESTAMP: {
                    this.values[utf] = new SqlParameter().setDateTime(field.getAsNumber());
                    continue block7;
                }
                case BLOB: 
                case GEOMETRY: {
                    if (field instanceof BlobField) {
                        BlobField blobField = (BlobField)field;
                        BinaryObject bin = blobField.getAsBinary();
                        if (bin != null) {
                            this.values[utf] = new SqlParameter().setBlob(bin.toByteArray());
                            continue block7;
                        }
                        this.values[utf].setNull(type);
                        continue block7;
                    }
                    this.values[utf].setNull(type);
                }
            }
        }
        return this.values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlParameter[] select(SSContext ssContext, double userId) throws SQLException {
        if (!this.enabled() || userId == 0.0) {
            return null;
        }
        SqlStringBuilder sql = new SqlStringBuilder();
        this.selectSql(sql);
        sql.append(" where ").append(this.fields[0]).append("=?");
        FieldDescriptor isValidField = this.fields[6];
        if (isValidField != null) {
            sql.append(" and ").append(isValidField).append(" is not null and ").append(isValidField).append("<>?");
        }
        try (DatabaseConnection connection = this.table.getDatabaseDescriptor().connect(null, "UsersTable.select by userId");){
            try (PreparedStatement statement = connection.prepareStatement("UsersTable.select by userId", sql.toString());){
                statement.setDouble(1, userId);
                if (isValidField != null) {
                    statement.setBoolean(2, false);
                }
                try (ResultSet fetch = statement.executeQuery(ssContext);){
                    if (!fetch.next()) {
                        SqlParameter[] sqlParameterArray = null;
                        return sqlParameterArray;
                    }
                    this.readSelect(fetch);
                    if (fetch.next()) {
                        throw new InformException("\u0412 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u0441 ID \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f " + (long)userId);
                    }
                }
            }
            connection.commit();
        }
        return this.values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlParameter[] selectByRecordId(SSContext ssContext, double recordId) throws SQLException {
        if (!this.enabled() || recordId == 0.0) {
            return null;
        }
        SqlStringBuilder sql = new SqlStringBuilder();
        this.selectSql(sql);
        sql.append(" where ").append(this.primaryKey).append("=?");
        try (DatabaseConnection connection = this.table.getDatabaseDescriptor().connect(null, "UsersTable.select by userId");){
            try (PreparedStatement statement = connection.prepareStatement("UsersTable.select by userId", sql.toString());){
                statement.setDouble(1, recordId);
                try (ResultSet fetch = statement.executeQuery(ssContext);){
                    if (!fetch.next()) {
                        SqlParameter[] sqlParameterArray = null;
                        return sqlParameterArray;
                    }
                    this.readSelect(fetch);
                    if (fetch.next()) {
                        throw new InformException("\u0412 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u0441 \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u043c \u043a\u043b\u044e\u0447\u043e\u043c " + (long)recordId);
                    }
                }
            }
            connection.commit();
        }
        return this.values;
    }

    /*
     * Exception decompiling
     */
    public ClosableResult selectAll(SSContext ssContext, String login) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectFiltered(SSContext ssContext, DoubleSet users, boolean deleted, IntHashMap<SqlParameter> filter) throws SQLException {
        FieldDescriptor isValidField;
        if (!this.enabled()) {
            return;
        }
        SqlParameterList params = new SqlParameterList();
        SqlStringBuilder sql = new SqlStringBuilder();
        sql.append("select ");
        sql.append(this.fields[0]).append(" from ").appendFull(this.table);
        SqlStringBuilder filterSql = new SqlStringBuilder();
        String and = "";
        if (this.fields[11] != null) {
            if (deleted) {
                filterSql.append(this.fields[11]).append("<>? and ").append(this.fields[11]).append(" is not null");
            } else {
                filterSql.append(this.fields[11]).append("=? or ").append(this.fields[11]).append(" is null");
            }
            params.add(new SqlParameter().setBoolean(false));
            and = " and ";
        }
        if (filter != null) {
            for (IntHashMap.Cursor<SqlParameter> cursor : filter) {
                FieldDescriptor field = this.table.getExistingFieldDescriptor(((SqlParameter)cursor.value).getId());
                filterSql.append(and).append(field).append("=?");
                and = " and ";
                params.add((SqlParameter)cursor.value);
            }
        }
        if ((isValidField = this.fields[6]) != null) {
            filterSql.append(and).append(isValidField).append(" is not null and ").append(isValidField).append("<>?");
            params.add(new SqlParameter().setBoolean(false));
        }
        if (filterSql.length() != 0) {
            sql.append(" where ").append(filterSql);
        }
        try (DatabaseConnection databaseConnection = this.table.getDatabaseDescriptor().connect(null, "UsersTable.select all");
             PreparedStatement statement = databaseConnection.prepareStatement("UsersTable.select all", sql.toString());){
            params.applyTo(statement);
            try (ResultSet fetch = statement.executeQuery(ssContext);){
                while (fetch.next()) {
                    users.add(fetch.getAsDouble(1));
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public ClosableResult selectAll(SSContext ssContext) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public ClosableResult selectByGroup(SSContext ssContext, double groupID) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlParameter[] select(SSContext ssContext, String login) throws SQLException {
        if (!this.enabled() || Strings.isVoid(login)) {
            return null;
        }
        SqlStringBuilder sql = new SqlStringBuilder();
        this.selectSql(sql);
        sql.append(" where UPPER(").append(this.fields[1]).append(")=?");
        FieldDescriptor isValidField = this.fields[6];
        if (isValidField != null) {
            sql.append(" and ").append(isValidField).append(" is not null and ").append(isValidField).append("<>?");
        }
        try (DatabaseConnection connection = this.table.getDatabaseDescriptor().connect(null, "UsersTable.select by userId");){
            try (PreparedStatement statement = connection.prepareStatement("UsersTable.select by userId", sql.toString());){
                statement.setString(1, login.toUpperCase());
                if (isValidField != null) {
                    statement.setBoolean(2, false);
                }
                try (ResultSet fetch = statement.executeQuery(ssContext);){
                    if (!fetch.next()) {
                        SqlParameter[] sqlParameterArray = null;
                        return sqlParameterArray;
                    }
                    this.readSelect(fetch);
                    if (fetch.next()) {
                        throw new InformException("\u0412 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u0441 \u0438\u043c\u0435\u043d\u0435\u043c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f " + login);
                    }
                }
            }
            connection.commit();
        }
        return this.values;
    }

    /*
     * Exception decompiling
     */
    public ClosableResult selectLoginConflicts(SSContext ssContext, String login, double userId) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public SqlParameter[] getValues(ResultSet resultSet) {
        if (resultSet == null) {
            return null;
        }
        try {
            this.readSelect(resultSet);
        }
        catch (SQLException e) {
            Core.logger.error(null, e);
            return null;
        }
        return this.values;
    }

    public double getTableID() {
        return this.table != null ? this.table.getNodeId() : 0.0;
    }

    public FieldDescriptor field(int utf) {
        return this.fields[utf];
    }

    public FieldDescriptor validField(int utf) {
        FieldDescriptor field = this.fields[utf];
        if (field == null) {
            throw new InformException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043f\u043e\u043b\u0435 \"" + UTF_DESC[utf] + "\" [" + utf + "] \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439");
        }
        return field;
    }

    public FieldDescriptor pkfield() {
        return this.primaryKey;
    }

    private void readSelect(ResultSet fetch) throws SQLException {
        this.values = this.readSelect(fetch, this.fields);
    }

    private void selectSql(SqlStringBuilder sql) {
        int comma = 32;
        sql.append("select");
        for (int utf = 0; utf < this.fields.length; ++utf) {
            FieldDescriptor f = this.fields[utf];
            if (f == null) {
                if (this.values == null) continue;
                this.values[utf] = null;
                continue;
            }
            sql.append((char)comma).append(f);
            comma = 44;
        }
        if (this.fields[0] != this.primaryKey) {
            sql.append(',').append(this.primaryKey);
        }
        sql.append(" from ").appendFull(this.table);
    }

    public static boolean isImportantField(int utf) {
        switch (utf) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public static final class UpdateParams {
        public boolean adLogin;
        public boolean inheritedStartup;
        public double rootNode;
        public double startNode;
        public int startAction;
        public double startScript;
        public double startWebNode;
        public double[] roles;
        public double[] rolesPrimaryKeys;
        public UserNode.Props props;
        public byte[] content;
        public int contentLength;
    }
}

