/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.nodes;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.NodeRecord;
import inform.agent.mtd.nodes.BasicNode;
import java.io.IOException;

public class ConstantsNode
extends BasicNode {
    public static final int TAG_CONST_HEADER = 10;
    public static final int TAG_CONST_NAME = 11;
    public static final int TAG_CONST_TITLE = 12;
    public static final int TAG_CONST_VALUE_INT = 13;
    public static final int TAG_CONST_VALUE_DOUBLE = 14;
    public static final int TAG_CONST_VALUE_STRING = 15;
    public static final int TAG_CONST_VALUE_DATETIME = 16;
    public static final int TAG_CONST_VALUE_NULL = 17;
    public static final int TAG_CONST_ID = 19;
    public static final int TAG_CONST_INHERITED = 20;
    public static final int TAG_CONST_VALUE_DIRECTORY = 22;
    public static final int TAG_CONST_DIRECTORY_FIELD = 23;
    public static final int TAG_CONST_SELECT_DIRECTORY = 24;
    public static final int TAG_CONST_SELECT_FIELD = 25;
    public static final int TAG_CONST_VALUE_IGNORE = 26;
    public static final int TAG_CONST_VALUE_FUNCTION = 27;
    public static final int TAG_CONST_VALUE_PRIMARY_KEY = 28;
    public static final int TAG_CONST_TABLE_ID = 29;
    public static final int TAG_CONST_COMMENT = 30;
    public static final int TAG_CONST_DATA_TYPE = 31;
    public static final int TAG_CONST_ASSOCIATE_FORM = 32;
    public static final int TAG_CONST_DISPLAY_FIELD = 33;
    public static final int TAG_CONST_VALUE_UNICODE = 34;
    public static final int TAG_CONST_ACCESS = 35;
    public static final int TAG_CONST_FORMAT = 36;

    public ConstantsNode(NodeRecord record) {
        super(record);
    }

    public static void getActualContstants(byte[] content, TaggedWriter out, IntegerSet complete) throws InformException, IOException, TaggedReaderException {
        if (content == null || content.length == 0) {
            return;
        }
        TaggedReader in = new TaggedReader(content);
        int[] header = null;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 10: {
                    header = LittleEndian.toIntArray(in.getRaw());
                    if (complete.contains(header[0])) {
                        header = null;
                        break;
                    }
                    out.putInt32(19, header[0]);
                    out.putEmpty(20);
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 22: 
                case 26: 
                case 27: 
                case 28: 
                case 34: {
                    if (header == null) break;
                    in.transferTag(out);
                    header = null;
                }
            }
        }
    }

    public static void getActualContstants(TaggedWriter out, IntegerSet complete) throws InformException, IOException, TaggedReaderException {
        ConstantsNode.getActualContstants(MtdEngine.getNodeContent(3.0), out, complete);
    }

    public String applicationName() throws InformException, IOException, TaggedReaderException {
        TaggedReader r = new TaggedReader(this.getContent());
        while (r.next()) {
            switch (r.getCurrentTag()) {
                case 10: {
                    int[] h = LittleEndian.toIntArray(r.getRaw());
                    if (h[0] != -1) break;
                    r.takeNextTag();
                    r.takeNextTag();
                    r.takeNextTag();
                    return r.getAnsi();
                }
            }
        }
        return null;
    }
}

