/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.nodes;

import inform.adt.InformException;
import inform.adt.collections.DoubleSet;
import inform.adt.taggedio.TaggedReader;
import inform.agent.db.connect.DatabaseCaps;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.NoContentRecordException;
import inform.agent.mtd.request.NodeDependeceEngine;
import inform.common.Empty;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.sql.SQLException;
import java.sql.Timestamp;

class ContentCache {
    private static final long RECHECK_INTERVAL = 300000L;
    private static final long RELOAD_INTERVAL = 3600000L;
    private static final SoftReference<Entry> EMPTY = new SoftReference<Object>(null);
    private final BasicNode node;
    private SoftReference<Entry> entry = EMPTY;
    private long modContentTime;

    ContentCache(BasicNode node) {
        this.node = node;
    }

    private ContentCache(ContentCache cache) {
        this.node = cache.node;
        this.entry = cache.entry;
        this.modContentTime = cache.modContentTime();
    }

    Entry size(double pinId) throws InformException {
        Entry result = this.entry.get();
        if (result == null || pinId != result.pinId || result.recheckNeed(System.currentTimeMillis())) {
            result = this.fetchSize(pinId);
            this.entry = new SoftReference<Entry>(result);
            this.modContentTime(result.modContentTime);
        }
        return result;
    }

    Entry content(double pinId) throws InformException {
        long now;
        Entry result = this.entry.get();
        boolean force = true;
        if (result instanceof Entry.Contented && result.pinId == pinId && !result.reloadNeed(now = System.currentTimeMillis())) {
            if (!result.recheckNeed(now)) {
                return result;
            }
            force = false;
        }
        if (!force) {
            Entry e = this.fetchSize(pinId);
            if (this.modContentTime() == e.modContentTime || e.size() == result.size()) {
                result = new Entry.Contented(pinId, e.modContentTime, ((Entry.Contented)result).content, ((Entry.Contented)result).dslContent, this.node.getType());
                this.entry = new SoftReference<Entry>(result);
                return result;
            }
        }
        result = this.fetchContent(pinId);
        this.entry = new SoftReference<Entry>(result);
        this.modContentTime(result.modContentTime);
        return result;
    }

    double[] tryGetFreshRefs(long modTime) throws IOException {
        Entry result = this.entry.get();
        if (!(result instanceof Entry.Contented)) {
            return null;
        }
        if (result.modContentTime < modTime) {
            return null;
        }
        return ((Entry.Contented)result).refs();
    }

    double[] findAndCacheRefs(long modTime, byte[] content, String dslContent) throws IOException {
        Entry.Contented result = new Entry.Contented(0.0, modTime, content, dslContent, this.node.getType());
        this.entry = new SoftReference<Entry.Contented>(result);
        this.modContentTime(result.modContentTime);
        return result.refs();
    }

    void cacheContent(long time, byte[] content, String dslContent) {
        this.entry = new SoftReference<Entry.Contented>(new Entry.Contented(0.0, time, content, dslContent, this.node.getType()));
        this.modContentTime(time);
    }

    synchronized long modContentTime() {
        return this.modContentTime;
    }

    synchronized void modContentTime(long time) {
        this.modContentTime = time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry fetchSize(double pinId) throws InformException {
        DatabaseDescriptor dd = DatabaseDescriptor.getMetabase();
        DatabaseConnection c = dd.connectPrivileged("ContentCache::fetchSize");
        try {
            Entry.Attributed result;
            c.markAsReadonly();
            DatabaseCaps caps = dd.getDatabaseType().caps();
            try (PreparedStatement ps = c.prepareStatement("getContentSize", "SELECT MOD_CONTENT_TIME," + caps.blobLengthFunction + "(RAW_CONTENT)," + caps.blobLengthFunction + "(DSL_CONTENT)  FROM " + MtdEngine.getMtdTableName(pinId != 0.0) + " WHERE ID=?");){
                ps.setDouble(1, pinId == 0.0 ? this.node.getId() : pinId);
                try (ResultSet rs = ps.executeQuery(null);){
                    if (!rs.next()) {
                        throw new NoContentRecordException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u044b \u0443\u0437\u043b\u0430").detail(String.format("Cannot fetch record from MTD_TREE* for node[%.0f(pin:%.0f)]", this.node.getId(), pinId));
                    }
                    Timestamp t = rs.getTimestamp(1);
                    long time = t == null ? 0L : t.getTime();
                    int size = rs.getInt(2);
                    int dslSize = rs.getInt(3);
                    if (!rs.wasNull() && dslSize != 0) {
                        size = dslSize;
                    }
                    result = new Entry.Attributed(pinId, time, size, this.node.getType());
                }
            }
            c.commit();
            Entry.Attributed attributed = result;
            c.close();
            return attributed;
        }
        catch (Throwable throwable) {
            try {
                c.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw InformException.wrap(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry fetchContent(double pinId) throws InformException {
        DatabaseDescriptor dd = DatabaseDescriptor.getMetabase();
        DatabaseConnection c = dd.connectPrivileged("ContentCache::fetchContent");
        try {
            Entry.Contented result;
            c.markAsReadonly();
            try (PreparedStatement ps = c.prepareStatement("getContent", "SELECT MOD_CONTENT_TIME,RAW_CONTENT,DSL_CONTENT  FROM " + MtdEngine.getMtdTableName(pinId != 0.0) + " WHERE ID=?");){
                ps.setDouble(1, pinId == 0.0 ? this.node.getId() : pinId);
                try (ResultSet rs = ps.executeQuery(null);){
                    if (!rs.next()) {
                        throw new NoContentRecordException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043a\u043e\u043d\u0442\u0435\u043d\u0442 \u0443\u0437\u043b\u0430").detail(String.format("Cannot fetch record from MTD_TREE* for node[%.0f(pin:%.0f)]", this.node.getId(), pinId));
                    }
                    Timestamp t = rs.getTimestamp(1);
                    long time = t == null ? 0L : t.getTime();
                    byte[] content = rs.getBlobBytes(2);
                    String dslCcontent = rs.getString(3);
                    result = new Entry.Contented(pinId, time, content, dslCcontent, this.node.getType());
                }
            }
            c.commit();
            Entry.Contented contented = result;
            c.close();
            return contented;
        }
        catch (Throwable throwable) {
            try {
                c.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw InformException.wrap(e);
            }
        }
    }

    void invalidate() {
        this.entry = EMPTY;
    }

    void set(byte[] content, String dslContent, long modContentTime) {
        this.entry = new SoftReference<Entry.Contented>(new Entry.Contented(this.node.getPinId(), modContentTime, content, dslContent, this.node.getType()));
        this.modContentTime(modContentTime);
    }

    protected ContentCache copy() {
        return new ContentCache(this);
    }

    static abstract class Entry {
        private final long time = System.currentTimeMillis();
        private final double pinId;
        final long modContentTime;
        protected final int nodeType;

        Entry(double pinId, long modContentTime, int nodeType) {
            this.pinId = pinId;
            this.modContentTime = modContentTime;
            this.nodeType = nodeType;
        }

        abstract int size();

        abstract byte[] content();

        abstract String dslContent();

        abstract boolean isDslContent();

        protected boolean recheckNeed(long now) {
            return now - this.time >= 300000L;
        }

        protected boolean reloadNeed(long now) {
            return now - this.time >= 3600000L;
        }

        static class Contented
        extends Entry {
            private final byte[] content;
            private final String dslContent;
            private volatile double[] refs_cache;

            Contented(double pinId, long modContentTime, byte[] content, String dslContent, int nodeType) {
                super(pinId, modContentTime, nodeType);
                this.content = content == null ? Empty.byteArray : content;
                this.dslContent = dslContent;
            }

            @Override
            int size() {
                return this.dslContent != null ? this.dslContent.length() : this.content.length;
            }

            @Override
            byte[] content() {
                return this.content;
            }

            @Override
            String dslContent() {
                return this.dslContent;
            }

            @Override
            boolean isDslContent() {
                return this.dslContent != null;
            }

            double[] refs() throws IOException {
                double[] result = this.refs_cache;
                if (result == null) {
                    byte[] bytes = this.content;
                    if (bytes == null || bytes.length == 0) {
                        this.refs_cache = Empty.doubleArray;
                        return Empty.doubleArray;
                    }
                    if (this.nodeType != 49 && !TaggedReader.containsTag(150, bytes)) {
                        this.refs_cache = Empty.doubleArray;
                        return Empty.doubleArray;
                    }
                    DoubleSet set = new DoubleSet();
                    NodeDependeceEngine.parseContentForDependencies(new TaggedReader(bytes), set);
                    this.refs_cache = result = set.toArray();
                }
                return result;
            }
        }

        static class Attributed
        extends Entry {
            private final int size;

            Attributed(double pinId, long modContentTime, int size, int nodeType) {
                super(pinId, modContentTime, nodeType);
                this.size = size;
            }

            @Override
            int size() {
                return this.size;
            }

            @Override
            byte[] content() {
                throw new UnsupportedOperationException("Not validated");
            }

            @Override
            String dslContent() {
                throw new UnsupportedOperationException("Not validated");
            }

            @Override
            boolean isDslContent() {
                throw new UnsupportedOperationException("Not validated");
            }
        }
    }
}

