/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.nodes;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.NumberConverter;
import inform.adt.TimeZoneHost;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.DoubleList;
import inform.adt.collections.DoubleSet;
import inform.adt.taggedio.LittleEndianDataInputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.ServerSideHost;
import inform.agent.db.connect.Connector;
import inform.agent.mtd.AclEntry;
import inform.agent.mtd.LockEngine;
import inform.agent.mtd.MtdCache;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.NodeRecord;
import inform.agent.mtd.NodeRecordIntf;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Correlations;
import inform.agent.mtd.request.NodeDependeceEngine;
import inform.agent.mtd.request.NodeStatus;
import inform.agent.net.Client;
import inform.agent.net.Security;
import inform.agent.scripts.SSContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.BitSet;

public abstract class Node
implements DoubleHash.Entry {
    static final int ORDER_NO_STEP = 100;
    private final double id;
    private double parentId;
    private final int type;
    private String name;
    private String identName;
    private String description;
    private double ownerId;
    private int orderNo;
    private long creationTime;
    private long modificationAttributeTime;
    private double contentUserId;
    private double applicationId;
    private double sessionId;
    private byte[] rawAttributes;
    protected byte[] contentAttr;
    private double replId = 0.0;
    private double replNodeId = 0.0;
    private long loadNodeTime;
    private double lastAccessTime;
    private int uiStyle;
    protected int uiImageId;
    private double undeletePatentId;
    private double undeleteUserId;
    private int defaultAction;
    private boolean auditEvents;
    private boolean isLoaded = false;
    public static final int NCM_PARENT = 1;
    public static final int NCM_NAME = 2;
    public static final int NCM_ATTRS = 4;
    public static final int NCM_CONTENT_ATTR = 8;
    public static final int NCM_ORDER = 16;
    public static final int NCM_DESCRIPTION = 32;
    public static final int NCM_IDENTIFIER = 64;
    public static final int NCM_OWNER = 128;
    public static final int NCM_CONTENT = 512;
    public static final int NCM_CREATE_NODE = 4096;
    public static final int NCM_SIGNIFICANT = 8192;
    public static final int NCM_AUDITEVENTS = 16384;
    public static final int NCM_ACL = 32768;
    public static final int NCM_REPLICA = -1;
    public NodeStatus status = null;
    private int changeMask = 0;

    public Node(NodeRecord record) {
        this.id = record.getId();
        this.parentId = record.getParentId();
        this.type = record.getType();
        this.name = record.getName();
        this.identName = record.getIdentName();
        this.description = record.getDescription();
        this.ownerId = record.getOwnerId();
        this.orderNo = record.getOrderNo();
        this.creationTime = record.getCreationTime();
        this.modificationAttributeTime = record.getModificationAttributeTime();
        this.contentUserId = record.getModificationUserId();
        this.applicationId = record.getApplicationId();
        this.sessionId = record.getSessionId();
        this.rawAttributes = record.getRawAttributes();
        this.contentAttr = record.getContentAttr();
        this.status = record.getStatus();
        this.replId = record.getReplId();
        this.replNodeId = record.getReplNodeId();
    }

    public final boolean isSame(NodeRecord r) {
        if (r.getId() != this.id) {
            return false;
        }
        if (r.getParentId() != this.parentId) {
            return false;
        }
        if (r.getType() != this.type) {
            return false;
        }
        if (!r.getName().equals(this.name)) {
            return false;
        }
        if (!r.getIdentName().equals(this.identName)) {
            return false;
        }
        if (!r.getDescription().equals(this.description)) {
            return false;
        }
        if (r.getOrderNo() != this.orderNo) {
            return false;
        }
        if (r.getModificationContentTime() != this.getModificationContentTime()) {
            return false;
        }
        return Arrays.equals(r.getRawAttributes(), this.rawAttributes);
    }

    public final boolean isSameTime(NodeRecord r) {
        if (r.getId() != this.id) {
            return false;
        }
        if (r.getModificationAttributeTime() != this.modificationAttributeTime) {
            return false;
        }
        return r.getCreationTime() == this.creationTime;
    }

    public boolean dropContentIfNeed(NodeRecord r) {
        return false;
    }

    public void invalidateContent() {
    }

    public void initNode(MtdCache cache) throws InterruptedException, InformException {
        this.assignName(cache, this.name);
    }

    public Node clone(double appId, NodeStatus status) throws InformException {
        NodeRecord record = new NodeRecord(status);
        this.getNodeRecord(record);
        record.setApplicationId(appId);
        Node node = MtdCache.createNodeInstance(record);
        try {
            if (!record.isAttributesEmpty()) {
                node.load(null, record.createAttributesReader());
            }
            node.afterLoad();
            node.isLoaded = true;
        }
        catch (InformException ex) {
            Core.logger.error(null, ex);
        }
        return node;
    }

    public boolean isAuditEvents() {
        return this.auditEvents || Ini.AuditAll;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getDescription() {
        return this.description;
    }

    public double getId() {
        return this.id;
    }

    public String getIdentName() {
        return this.identName;
    }

    public long getModificationAttributeTime() {
        return this.modificationAttributeTime;
    }

    public double getApplicationId() {
        return this.applicationId;
    }

    public double getSessionId() {
        return this.sessionId;
    }

    public double getModificationUserId() {
        return this.contentUserId;
    }

    public String getName() {
        return this.name;
    }

    public double getOwnerId() {
        return this.ownerId;
    }

    public double getParentId() {
        return this.parentId;
    }

    public int getType() {
        return this.type;
    }

    public int getUiStyle() {
        return this.uiStyle;
    }

    public int getUiImageId() {
        return this.uiImageId;
    }

    protected int getDefaultAction() {
        return this.defaultAction;
    }

    public boolean isInTrash() {
        return this.parentId == 1.0;
    }

    public boolean isInTrashRecursive(MtdCache cache) {
        if (this.parentId == 1.0) {
            return true;
        }
        double parentId = this.parentId;
        for (int level = 32; parentId != 0.0 && level > 0; --level) {
            Node parent = cache.getNode(parentId);
            if (parent == null) {
                return false;
            }
            if (parent.isInTrash()) {
                return true;
            }
            parentId = parent.getParentId();
        }
        return false;
    }

    public boolean isInTrashRecursive() throws InformException {
        if (this.parentId == 1.0) {
            return true;
        }
        double parentId = this.parentId;
        for (int level = 32; parentId != 0.0 && level > 0; --level) {
            Node parent = MtdEngine.getNode(parentId);
            if (parent == null) {
                return false;
            }
            if (parent.isInTrash()) {
                return true;
            }
            parentId = parent.getParentId();
        }
        return false;
    }

    public boolean isChildOf(double parentNodeId, MtdCache cache) {
        if (this.parentId == parentNodeId) {
            return true;
        }
        if (this.parentId == 0.0) {
            return false;
        }
        Node parent = cache.getNode(this.parentId);
        return parent != null && parent.isChildOf(parentNodeId, cache);
    }

    public double getLastAccessTime() {
        return this.lastAccessTime;
    }

    public int getOrderNo() {
        return this.orderNo;
    }

    public double getUndeletePatentId() {
        return this.undeletePatentId;
    }

    public double getUndeleteUserId() {
        return this.undeleteUserId;
    }

    public double getReplNodeId() {
        return this.replNodeId;
    }

    public void getNodeRecord(NodeRecord record) throws InformException {
        record.clear();
        record.setId(this.id);
        record.setParentId(this.parentId);
        record.setType(this.type);
        record.setName(this.name);
        record.setIdentName(this.identName);
        record.setDescription(this.description);
        record.setOwnerId(this.ownerId);
        record.setOrderNo(this.orderNo);
        record.setCreationTime(this.creationTime);
        record.setModificationAttributeTime(this.modificationAttributeTime);
        record.setModificationContentTime(this.getModificationContentTime());
        record.setModificationUserId(this.contentUserId);
        record.setApplicationId(this.applicationId);
        record.setSessionId(this.sessionId);
        record.setRawAttributes(this.rawAttributes);
        record.setContentAttr(this.contentAttr);
        record.setReplId(this.replId);
        record.setReplNodeId(this.replNodeId);
    }

    public String toLogString() {
        return "[" + NumberConverter.doubleToString(this.id) + "] " + this.name;
    }

    public String toString() {
        return String.format("%s: %s(%.0f)", this.name, this.getClass().getSimpleName(), this.id);
    }

    public void storeAttributes(TaggedWriter out) throws InformException, IOException {
        Object[] data;
        if (this.uiImageId != 0 || this.uiStyle != 0) {
            data = new int[]{this.uiStyle, this.uiImageId};
            out.putRaw(10, LittleEndian.intArrayToBinary(data, data.length));
        } else {
            out.putEmpty(10);
        }
        if (this.isInTrash()) {
            data = new double[]{this.undeletePatentId, this.undeleteUserId};
            out.putRaw(15, LittleEndian.doubleArrayToBinary(data, data.length));
        }
        if (this.defaultAction != 0) {
            out.putInt32(13, this.defaultAction);
        }
        out.putBool(33, this.auditEvents);
    }

    protected void replicationStoreAttributes(int mask, TaggedWriter out, Connector connector, Client client) throws InformException, IOException {
        double precedingId;
        out.putAnsiNull(3, this.name);
        out.putDouble(26, DateTime.fromUnixTime(this.creationTime));
        out.putDouble(27, DateTime.fromUnixTime(this.getModificationContentTime()));
        out.putDouble(32, this.contentUserId);
        out.putDouble(28, DateTime.fromUnixTime(this.modificationAttributeTime));
        out.putAnsiNull(8, this.identName);
        if (this.uiImageId != 0 || this.uiStyle != 0) {
            int[] data = new int[]{this.uiStyle, this.uiImageId};
            out.putRaw(10, LittleEndian.intArrayToBinary(data, data.length));
        } else {
            out.putEmpty(10);
        }
        out.putInt32(13, this.defaultAction);
        out.putBool(33, this.auditEvents);
        out.putInt32(22, this.orderNo);
        BasicNode parent = MtdEngine.getTranslatedNode(this.parentId);
        if (parent != null && (precedingId = parent.getPrecedingChildId(this.id, connector)) != 0.0) {
            out.putDouble(20, precedingId);
        }
    }

    protected abstract double replicationStoreContent(TaggedWriter var1, Connector var2, Client var3) throws InformException, IOException;

    public final double replicationStore(TaggedWriter out, int mask, Connector connector, Client client) throws InformException, IOException {
        this.replicationStoreAttributes(mask, out, connector, client);
        double pinId = 0.0;
        if ((mask & 8) != 0) {
            pinId = this.replicationStoreContent(out, connector, client);
        }
        return pinId;
    }

    public void afterSave() throws InformException {
        assert (this.status != null);
    }

    public void beforeLoad() {
    }

    public final void load(MtdCache mtdCache, TaggedReader in) throws InformException {
        try {
            this.beforeLoad();
            while (in.getNextTag() != 0) {
                this.loadTag(null, in);
            }
        }
        catch (Throwable ex) {
            throw InformException.wrap(ex, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0443\u0437\u043b\u0430[" + NumberConverter.doubleToString(this.id) + "]");
        }
    }

    public synchronized void checkLoaded() throws InformException {
        if (this.isLoaded) {
            return;
        }
        this.isLoaded = true;
        this.afterLoad();
    }

    public synchronized void systemLoaded() {
        this.isLoaded = true;
    }

    public boolean needCreateContentAttr() {
        return false;
    }

    public byte[] createContentAttr() {
        this.contentAttr = null;
        return null;
    }

    protected void afterLoad() throws InformException {
    }

    protected void loadTag(MtdCache mtdCache, TaggedReader in) throws InformException, IOException, InterruptedException {
        switch (in.getCurrentTag()) {
            case 16: {
                this.ownerId = in.getDouble();
                break;
            }
            case 3: {
                this.assignName(mtdCache, in.getAnsi());
                break;
            }
            case 8: {
                this.identName = in.getAnsi();
                break;
            }
            case 7: {
                ByteArrayInputStream data = new ByteArrayInputStream(in.getRaw());
                LittleEndianDataInputStream stream = new LittleEndianDataInputStream(data);
                this.creationTime = DateTime.toUnixTime(stream.readDouble());
                this.modificationAttributeTime = DateTime.toUnixTime(stream.readDouble());
                this.setModificationContentTime(this.modificationAttributeTime);
                this.lastAccessTime = DateTime.toUnixTime(stream.readDouble());
                break;
            }
            case 13: {
                this.defaultAction = in.getInt();
                break;
            }
            case 10: {
                int[] data = LittleEndian.toIntArray(in.getRaw());
                if (data == null || data.length != 2) {
                    this.uiImageId = 0;
                    this.uiStyle = 0;
                    break;
                }
                this.uiStyle = data[0];
                this.uiImageId = data[1];
                break;
            }
            case 15: {
                double[] data = LittleEndian.toDoubleArray(in.getRaw());
                if (data == null || data.length != 2) {
                    this.undeleteUserId = 0.0;
                    this.undeletePatentId = 0.0;
                    break;
                }
                this.undeletePatentId = data[0];
                this.undeleteUserId = data[1];
                break;
            }
            case 22: {
                this.orderNo = in.getInt();
                break;
            }
            case 26: {
                this.creationTime = DateTime.toUnixTime(in.getDouble());
                break;
            }
            case 27: {
                this.setModificationContentTime(DateTime.toUnixTime(in.getDouble()));
                break;
            }
            case 32: {
                this.contentUserId = in.getDouble();
                break;
            }
            case 28: {
                this.modificationAttributeTime = DateTime.toUnixTime(in.getDouble());
                break;
            }
            case 29: {
                this.lastAccessTime = in.getDouble();
                break;
            }
            case 33: {
                this.auditEvents = in.getBoolean();
                break;
            }
            case 9: {
                this.description = in.getAnsi();
            }
        }
    }

    protected void loadedCreationTime(double time) {
        this.creationTime = DateTime.toUnixTimeRoundSec(time);
    }

    public synchronized long getLoadNodeTime() {
        return this.loadNodeTime;
    }

    public synchronized void setLoadNodeTime(long loadNodeTime) {
        this.loadNodeTime = loadNodeTime;
    }

    public abstract void getAclContent(TaggedWriter var1) throws InformException;

    public abstract String getNewChildName(Connector var1, String var2) throws InformException;

    public void getNodeInfo(NodeInfoArg arg) throws InformException, IOException, SQLException, InterruptedException {
        arg.out.putDouble(1, this.id);
        arg.out.putDouble(3, this.parentId);
        arg.out.putAnsi(4, this.name);
        arg.out.putInt32(2, this.type);
        if (this.uiStyle != 0) {
            arg.out.putInt32(8, this.uiStyle);
        }
        if (this.uiImageId != 0) {
            arg.out.putInt32(9, this.uiImageId);
        }
        arg.out.putAnsiIf(13, this.identName);
        arg.out.putAnsiIf(12, this.description);
        arg.out.putDouble(46, DateTime.fromUnixTime(this.creationTime));
        arg.out.putDouble(47, DateTime.fromUnixTime(this.getModificationContentTime()));
        arg.out.putDouble(54, this.contentUserId);
        arg.out.putDouble(48, DateTime.fromUnixTime(this.modificationAttributeTime));
        arg.out.putDouble(49, this.lastAccessTime);
        if (this.defaultAction != 0) {
            arg.out.putInt32(16, this.defaultAction);
        }
        arg.out.putBool(56, this.auditEvents || Ini.AuditAll);
        int accessMask = arg.security.accessMask(this);
        arg.out.putInt32(18, accessMask);
        if (this.contentAttr != null && this.contentAttr.length != 0) {
            arg.out.putRaw(28, this.contentAttr);
        }
        if (this.replId != 0.0) {
            arg.out.putDouble(29, this.replId);
        }
        if (this.replNodeId != 0.0) {
            arg.out.putDouble(62, this.replNodeId);
        }
    }

    public void getChildInfo(Node child, NodeInfoArg arg) throws InformException, IOException, SQLException, InterruptedException {
        if (child.parentId != this.id) {
            return;
        }
        child.getNodeInfo(arg);
    }

    public boolean hasChilldren(Connector connector) throws InformException, SQLException {
        double[] children = this.getChildren(connector);
        return children.length > 0;
    }

    public synchronized void dropChildrenCache() {
    }

    public void getNodeStringPath(double rootNodeId, StringBuilder path) throws InformException {
        String[] parents = new String[1024];
        int parentCount = 0;
        double prevNodeId = -1.0;
        if (this.id != 0.0) {
            Node node = MtdEngine.getNode(this.parentId);
            while (node != null && parentCount < parents.length) {
                double nodeId = node.getId();
                if (prevNodeId == 0.0 && nodeId == 0.0) break;
                prevNodeId = nodeId;
                parents[parentCount++] = node.getName();
                if (node.getId() == rootNodeId) break;
                node = MtdEngine.getNode(node.getParentId());
            }
        }
        if (parentCount <= 0) {
            return;
        }
        path.append('/');
        if (--parentCount <= 0) {
            return;
        }
        path.append(parents[--parentCount]);
        while (parentCount > 0) {
            path.append('/').append(parents[--parentCount]);
        }
    }

    public double[] getNodeIDPath(double rootNodeId) throws InformException {
        double[] reversePath = new double[1024];
        int pathCount = 0;
        double prevNodeId = -1.0;
        Node parent = MtdEngine.getNode(this.parentId);
        while (pathCount < reversePath.length && (parent != null && parent instanceof BasicNode || (parent = MtdEngine.getNode(9.0)) != null)) {
            double nodeId = parent.getId();
            if (prevNodeId == 0.0 && nodeId == 0.0) break;
            prevNodeId = nodeId;
            reversePath[pathCount++] = nodeId;
            if (nodeId == rootNodeId) break;
            parent = MtdEngine.getNode(parent.getParentId());
        }
        double[] path = new double[pathCount];
        int i = 0;
        while (pathCount > 0) {
            path[i] = reversePath[--pathCount];
            ++i;
        }
        return path;
    }

    public int getRecordCount() {
        return -1;
    }

    protected void assignName(MtdCache mtdCache, String name) {
        this.name = name;
    }

    protected final void internalSetName(String name) {
        this.name = name;
    }

    public void enumerateChildren(Connector connector, BitSet nodeTypeFilter, DoubleSet children, DoubleSet excludeNodes, DoubleList orderedChildren) throws InformException, SQLException {
        double[] childIds;
        for (double childId : childIds = this.getChildren(connector, nodeTypeFilter)) {
            Node node;
            if (excludeNodes != null && excludeNodes.contains(childId)) continue;
            if (children.add(childId) && orderedChildren != null) {
                orderedChildren.add(childId);
            }
            if ((node = MtdEngine.getNode(childId)) == null) continue;
            node.enumerateChildren(connector, nodeTypeFilter, children, excludeNodes, orderedChildren);
        }
    }

    public void enumerateDependedOn(double dependedId, Connector connector, int tag, TaggedWriter out) throws IOException, SQLException, InterruptedException {
        double[] childIds;
        if (NodeDependeceEngine.isNodeDependedOn(this, dependedId)) {
            out.putDouble(tag, this.getId());
        }
        for (double childId : childIds = this.getChildren(connector)) {
            Node node = MtdEngine.getNode(childId);
            if (node == null) continue;
            node.enumerateDependedOn(dependedId, connector, tag, out);
        }
    }

    public double[] getChildren(Connector connector, BitSet nodeTypeFilter) throws InformException, SQLException {
        if (nodeTypeFilter == null) {
            return this.getChildren(connector);
        }
        return this.getFilteredChildren(connector, nodeTypeFilter);
    }

    public double[] getChildrenByFilters(Connector connector, BitSet nodeTypeFilter, int permissions, Security security) throws InformException, SQLException {
        return this.getFilteredChildren(connector, nodeTypeFilter, permissions, security);
    }

    public boolean containsParent(double nodeId) throws InformException {
        Node node = this;
        while (node != null && node.getId() != node.getParentId()) {
            if (node.getId() == nodeId) {
                return true;
            }
            if (node.getId() == 0.0) break;
            node = MtdEngine.getNode(node.getParentId());
        }
        return false;
    }

    public double getRefNodeId() {
        return this.id;
    }

    protected abstract BasicNode getRefNode(int var1) throws InformException;

    public final BasicNode getRefNode() throws InformException {
        return this.getRefNode(10);
    }

    public abstract BasicNode getRealNode(int var1) throws InformException;

    public final BasicNode getRealNode() throws InformException {
        return this.getRealNode(10);
    }

    public abstract double[] getChildren(Connector var1) throws InformException;

    protected abstract boolean hasFilteredChildren(Connector var1, BitSet var2, DoubleSet var3) throws InformException, SQLException;

    protected abstract double[] getFilteredChildren(Connector var1, BitSet var2) throws InformException, SQLException;

    protected abstract boolean hasFilteredChildren(Connector var1, BitSet var2, int var3, Security var4, DoubleSet var5) throws InformException, SQLException;

    protected abstract double[] getFilteredChildren(Connector var1, BitSet var2, int var3, Security var4) throws InformException, SQLException;

    public byte[] getRawAttributes() {
        return this.rawAttributes;
    }

    protected byte[] getContentAttr() {
        return this.contentAttr;
    }

    @Override
    public double key() {
        return this.id;
    }

    public long lastModificationTime() {
        long time = this.getModificationContentTime();
        if (time < this.creationTime) {
            time = this.creationTime;
        }
        if (time < this.modificationAttributeTime) {
            time = this.modificationAttributeTime;
        }
        return time;
    }

    public int calcLevel() throws InformException {
        int level;
        Node node = this;
        for (level = 0; node != null && node.getId() != 0.0 && level < 1024; ++level) {
            node = MtdEngine.getNode(node.getParentId());
        }
        return level;
    }

    public abstract byte[] replaceDependencies(Correlations var1, byte[] var2) throws InformException;

    public boolean isContentApplicable() {
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: {
                return false;
            }
        }
        return true;
    }

    public void applyChanges() {
        assert (this.status != null);
        this.status = null;
        this.changeMask = 0;
        this.dropChildrenCache();
    }

    public byte[] getModifiedContent() throws InformException {
        return null;
    }

    public String getModifiedDslContent() {
        return null;
    }

    public boolean isModifiedDslContent() {
        return false;
    }

    public boolean isNodeAttrChanged(int value) {
        assert (this.status != null);
        return (this.changeMask & value) != 0;
    }

    public boolean isNodeChangeMask(int value) {
        assert (this.status != null);
        return this.changeMask == value;
    }

    public boolean hasSignificantChanges() {
        assert (this.status != null);
        return (this.changeMask & 0x2000) != 0;
    }

    public void applyUpdates(SSContext context, ModifyNodeArg arg) throws SQLException, IOException {
        MtdEngine.updateNodes(context, arg);
    }

    public void setNodeChangingProps(ModifyNodeArg arg) throws InformException {
        assert (this.status != null);
        if (this.changeMask == 16) {
            return;
        }
        long seconds = System.currentTimeMillis() / 1000L;
        this.modificationAttributeTime = seconds * 1000L;
        this.applicationId = arg.applicationId;
        this.sessionId = arg.sessionId;
        this.changeMask |= 4;
        if ((this.changeMask & 0x200) != 0) {
            this.setModificationContentTime(arg.contentModificationTime);
        }
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(data);
        try {
            this.storeAttributes(out);
            out.flush();
        }
        catch (IOException ex) {
            throw InformException.wrap(ex);
        }
        this.rawAttributes = data.toByteArray();
    }

    public void changeNodeAttributes(double sessionId, byte[] attributes, long time) throws InformException {
        assert (this.status != null);
        if (this.changeMask == 16) {
            return;
        }
        this.modificationAttributeTime = time / 1000L * 1000L;
        this.applicationId = Core.getApplicationId();
        this.sessionId = sessionId;
        this.changeMask |= 4;
        this.rawAttributes = attributes;
    }

    public void getCreationChanges(NodeRecordIntf record) throws InformException {
        assert (this.status != null);
        assert ((this.changeMask & 0x1000) != 0);
        record.setType(this.type);
        record.setParentId(this.parentId);
        record.setName(this.name);
        record.setIdentName(this.identName);
        record.setDescription(this.description);
        record.setOwnerId(this.ownerId);
        record.setOrderNo(this.orderNo);
        record.setCreationTime(this.creationTime);
        record.setModificationAttributeTime(this.creationTime);
        record.setModificationContentTime(this.creationTime);
        record.setModificationUserId(this.contentUserId);
        record.setSessionId(this.sessionId);
        record.setRawAttributes(this.rawAttributes);
        if (this.replId != 0.0) {
            record.setReplId(this.replId);
        }
        if (this.replNodeId != 0.0) {
            record.setReplNodeId(this.replNodeId);
        }
    }

    public void getNodeChanges(NodeRecordIntf record) throws InformException {
        assert (this.status != null);
        if (this.changeMask == 0) {
            return;
        }
        if (this.changeMask == 16) {
            record.setOrderNo(this.orderNo);
            return;
        }
        if ((this.changeMask & 1) != 0) {
            record.setParentId(this.parentId);
        }
        if ((this.changeMask & 2) != 0) {
            record.setName(this.name);
        }
        if ((this.changeMask & 0x40) != 0) {
            record.setIdentName(this.identName);
        }
        if ((this.changeMask & 0x20) != 0) {
            record.setDescription(this.description);
        }
        if ((this.changeMask & 0x80) != 0) {
            record.setOwnerId(this.ownerId);
        }
        if ((this.changeMask & 0x10) != 0) {
            record.setOrderNo(this.orderNo);
        }
        if ((this.changeMask & 0x200) != 0) {
            record.setModificationContentTime(this.getModificationContentTime());
            record.setModificationUserId(this.contentUserId);
        }
        record.setModificationAttributeTime(this.modificationAttributeTime);
        record.setSessionId(this.sessionId);
        if ((this.changeMask & 4) != 0) {
            record.setRawAttributes(this.rawAttributes);
        }
        if ((this.changeMask & 8) != 0 && this.contentAttr != null) {
            record.setContentAttr(this.contentAttr);
        }
    }

    public void loadReplicationTag(int tag, ModifyNodeArg arg, int mask) throws IOException, InformException, SQLException {
        assert (this.status != null);
        TaggedReader in = arg.in;
        switch (tag) {
            case 3: {
                if ((mask & 1) == 0) break;
                this.name = in.getString();
                this.changeMask |= 2;
                this.applicationId = arg.applicationId;
                this.sessionId = arg.sessionId;
                break;
            }
            case 8: {
                this.loadModifyTag(13, arg);
                break;
            }
            case 20: {
                this.loadModifyTag(21, arg);
                break;
            }
            case 13: {
                this.loadModifyTag(16, arg);
                break;
            }
            case 10: {
                int[] data = LittleEndian.toIntArray(in.getRaw());
                if (data == null || data.length != 2) {
                    this.uiImageId = 0;
                    this.uiStyle = 0;
                } else {
                    this.uiStyle = data[0];
                    this.uiImageId = data[1];
                }
                this.changeMask |= 4;
                break;
            }
            case 22: {
                this.orderNo = in.getInt();
                this.changeMask |= 0x10;
                break;
            }
            case 26: {
                this.creationTime = DateTime.toUnixTime(in.getDouble());
                if (arg.timeZoneHost != null) {
                    this.creationTime += (long)DateTime.serverTimeZoneOffset(arg.timeZoneHost);
                }
                this.changeMask |= 4;
                break;
            }
            case 27: {
                long time = DateTime.toUnixTime(in.getDouble());
                if (arg.timeZoneHost != null) {
                    time += (long)DateTime.serverTimeZoneOffset(arg.timeZoneHost);
                }
                this.setModificationContentTime(time);
                this.changeMask |= 4;
                break;
            }
            case 28: {
                this.modificationAttributeTime = System.currentTimeMillis() / 1000L * 1000L;
                this.changeMask |= 4;
                break;
            }
            case 33: {
                this.loadModifyTag(56, arg);
                break;
            }
            case 9: {
                this.loadModifyTag(12, arg);
            }
        }
    }

    public void loadModifyTag(int tag, ModifyNodeArg arg) throws IOException, InformException, SQLException {
        assert (this.status != null);
        TaggedReader in = arg.in;
        switch (tag) {
            case 3: {
                double loadedId = in.getDouble();
                this.changeParent(loadedId, arg);
                break;
            }
            case 4: {
                String loadedName = in.getString();
                this.changeNameAndParent(loadedName, this.parentId, arg);
                break;
            }
            case 12: {
                String loadedDesc = in.getString();
                this.setDescription(loadedDesc);
                break;
            }
            case 13: {
                String loadedName = in.getString();
                if (this.identName != null && this.identName.equals(loadedName)) break;
                Node conflictNode = MtdEngine.getNodeByIdent(loadedName);
                if (conflictNode != null && conflictNode.id != this.id) {
                    this.throwDuplicateIdentifierError(conflictNode);
                    break;
                }
                this.identName = loadedName;
                this.changeMask |= 0x40;
                break;
            }
            case 8: {
                this.uiStyle = in.getInt();
                this.changeMask |= 4;
                break;
            }
            case 9: {
                this.uiImageId = in.getInt();
                this.changeMask |= 4;
                break;
            }
            case 16: {
                this.defaultAction = in.getInt();
                this.changeMask |= 4;
                break;
            }
            case 21: {
                double loadedId = in.getDouble();
                Node node = MtdEngine.getNode(this.parentId);
                arg.modifiedParents.add(this.parentId);
                if (node == null || !(node instanceof BasicNode)) break;
                BasicNode parent = (BasicNode)node;
                parent.moveNodeAfter(this, loadedId, arg);
                break;
            }
            case 25: {
                Node node = MtdEngine.getNode(this.parentId);
                if (node == null || !(node instanceof BasicNode)) break;
                BasicNode parent = (BasicNode)node;
                parent.moveNodeLast(this, arg);
                break;
            }
            case 56: {
                boolean value = in.getBoolean();
                if (Ini.AuditAll || this.auditEvents == value) break;
                this.changeMask |= 0x4004;
                this.auditEvents = value;
                break;
            }
            case 63: {
                break;
            }
            default: {
                if (this.status == NodeStatus.CREATING) break;
                throw new InformException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0435\u0433 " + tag + " \u043f\u0440\u0438 \u043c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0443\u0437\u043b\u0430");
            }
        }
    }

    private void throwDuplicateIdentifierError(Node conflictNode) throws InformException {
        StringBuilder msg = new StringBuilder();
        msg.append("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 '").append(conflictNode.getIdentName()).append("' \u0443\u0436\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f\n").append("\u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 ").append(this.name).append(" [").append(NumberConverter.doubleToString(this.id)).append("] \u0441 ").append(conflictNode.getName()).append(" [").append(NumberConverter.doubleToString(conflictNode.getId())).append("]");
        throw new InformException(msg.toString());
    }

    void setOrderNo(int orderNo) {
        assert (this.status != null);
        this.orderNo = orderNo;
        this.changeMask |= 0x10;
    }

    protected void setDescription(String description) throws InformException {
        assert (this.status != null);
        if (this.description == null ? description == null || description.isEmpty() : this.description.equals(description)) {
            return;
        }
        this.description = description;
        this.changeMask |= 0x20;
    }

    protected void checkChildName(String newName, double checkedId, ModifyNodeArg arg) throws InformException {
        double[] children;
        for (double childId : children = this.getChildren(arg.connector)) {
            Node node;
            if (childId == checkedId || (node = arg.getNode(childId)) == null || !node.getName().equals(newName)) continue;
            throw new InformException("\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442 \u0438\u043c\u0435\u043d \u0443\u0437\u043b\u043e\u0432 [" + (long)node.getId() + "] \u0441 [" + (long)checkedId + "] \u0438\u043c\u044f:'" + newName + "'").detail("\u041f\u0430\u043f\u043a\u0430 " + this.toLogString());
        }
    }

    protected final void internalSetParent(Node parent) throws InformException {
        assert (this.status != null);
        this.parentId = parent == null ? 0.0 : parent.getId();
    }

    private void changeParent(Node parent, ModifyNodeArg arg) throws InformException {
        assert (this.status != null);
        if (parent.containsParent(this.id)) {
            StringBuilder msg = new StringBuilder();
            msg.append("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0442\u0438 \u0443\u0437\u0435\u043b[").append((long)this.id).append("]  \u0441\u0430\u043c \u0432 \u0441\u0435\u0431\u044f");
            StringBuilder detail = new StringBuilder();
            detail.append("\u0412\u044b\u0448\u0435\u0441\u0442\u043e\u044f\u0449\u0438\u0439 \u0443\u0437\u0435\u043b[").append((long)parent.getId()).append("], \u043f\u043e\u0434 \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043f\u0435\u0440\u0435\u043d\u043e\u0441\u044f\u0442\u044c \u0443\u0437\u0435\u043b[").append((long)this.id).append("], \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u043c \u043f\u043e \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u044e \u043f\u0435\u0440\u0435\u043d\u043e\u0441\u0438\u043c\u043e\u043c\u0443 \u0443\u0437\u043b\u0443");
            throw new InformException(msg.toString()).detail(detail.toString());
        }
        parent.checkChildName(this.name, this.id, arg);
        if (parent.getType() == 1) {
            this.undeletePatentId = this.parentId;
            this.undeleteUserId = arg.userId;
            this.changeMask |= 4;
        }
        arg.modifiedParents.add(this.parentId);
        this.parentId = parent.getId();
        arg.modifiedParents.add(this.parentId);
        this.changeMask |= 1;
        this.applicationId = arg.applicationId;
        this.sessionId = arg.sessionId;
        this.invalidateChildrenAttrTime(arg);
    }

    public void changeParent(double newParentId, ModifyNodeArg arg) throws InformException, SQLException {
        assert (this.status != null);
        if (this.parentId != newParentId) {
            BasicNode parent = arg.getValidTranslatedNode(newParentId);
            this.changeParent(parent, arg);
        }
    }

    private void invalidateChildrenAttrTime(ModifyNodeArg arg) throws InformException {
        double[] children;
        for (double childId : children = this.getChildren(arg.connector)) {
            arg.modifiedParents.add(childId);
            Node child = arg.getNode(childId);
            if (child == null || !(child instanceof BasicNode)) continue;
            child.invalidateChildrenAttrTime(arg);
        }
    }

    public void changeName(String newName, ModifyNodeArg arg) throws InformException {
        assert (this.status != null);
        BasicNode parent = arg.getValidTranslatedNode(this.parentId);
        parent.checkChildName(newName, this.id, arg);
        this.name = newName;
        this.changeMask |= 2;
        this.applicationId = arg.applicationId;
        this.sessionId = arg.sessionId;
    }

    public void changeNameAndParent(String newName, double newParentId, ModifyNodeArg arg) throws InformException {
        assert (this.status != null);
        BasicNode parent = arg.getValidTranslatedNode(newParentId);
        if (this.parentId != newParentId) {
            parent.checkChildName(newName, this.id, arg);
            this.name = newName;
            this.changeParent(parent, arg);
        } else {
            parent.checkChildName(newName, this.id, arg);
            this.name = newName;
            this.changeMask |= 2;
        }
        this.applicationId = arg.applicationId;
        this.sessionId = arg.sessionId;
    }

    protected void setSignificantAttrModified(boolean aclModified) {
        assert (this.status != null);
        this.changeMask |= 0x2004;
        if (aclModified) {
            this.changeMask |= 0x8000;
        }
    }

    protected void setAttrModified() {
        assert (this.status != null);
        this.changeMask |= 4;
    }

    protected void setContentModified() {
        assert (this.status != null);
        this.changeMask |= 0x2200;
    }

    public void setContentModificationUser(double userId) {
        assert (this.status != null);
        this.contentUserId = userId;
    }

    protected void setContentAttrModified() {
        assert (this.status != null);
        this.changeMask |= 0x200;
    }

    protected void dropChildrenAcl(ModifyNodeArg arg) throws InformException {
    }

    public void redistributeAcl(AclEntry aclEntry, ModifyNodeArg arg) throws InformException {
    }

    public void afterCreateSystem() throws InformException {
        this.changeMask |= 0x1000;
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(data);
        try {
            this.storeAttributes(out);
            out.flush();
        }
        catch (IOException ex) {
            throw InformException.wrap(ex);
        }
        this.rawAttributes = data.toByteArray();
    }

    public void afterCreateNew(CreationArg arg) throws InformException {
        assert (this.status != null);
        this.changeMask |= 0x1000;
        this.assignName(MtdEngine.getMtdCache(), arg.name);
        if (MtdEngine.getNodeByIdent(arg.identifier) == null) {
            this.identName = arg.identifier;
        }
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(data);
        try {
            this.storeAttributes(out);
            out.flush();
        }
        catch (IOException ex) {
            throw InformException.wrap(ex);
        }
        this.rawAttributes = data.toByteArray();
    }

    public final void lockBarrier(double sessionId) throws InformException {
        LockEngine.Locker locker = LockEngine.getNodeLocker(this.id, 0.0, 0.0);
        if (locker == null) {
            return;
        }
        if (locker.getSessionId() != sessionId) {
            locker.throwNode(this);
        }
    }

    public long getModificationContentTime() {
        return 0L;
    }

    public void setModificationContentTime(long time) {
    }

    public void setReplId(double replId) {
        this.replId = replId;
    }

    public void setModificationAttributeTime(long modificationAttributeTime) {
        long seconds = modificationAttributeTime / 1000L;
        this.modificationAttributeTime = seconds * 1000L;
    }

    public abstract void setChildrenCache(double[] var1);

    public static class ModifyNodeArg {
        public final ServerSideHost ssHost;
        public final Security security;
        public final Connector connector;
        public int options = 0;
        public double userId = 0.0;
        public double sessionId = 0.0;
        public String auditComment;
        public TaggedReader in = null;
        public DoubleSet modifiedParents = new DoubleSet();
        public DoubleHash<Node> modifiedNodes = new DoubleHash();
        public double applicationId = Core.getApplicationId();
        public long contentModificationTime;
        public double replId = 0.0;
        public double replNodeId = 0.0;
        public final NodeStatus status;
        public SSContext ssContext = null;
        public long contentStamp = 0L;
        public TimeZoneHost timeZoneHost = null;

        public ModifyNodeArg(ServerSideHost ssHost, Connector connector, NodeStatus status, Security security) throws InformException {
            this.ssHost = ssHost;
            this.connector = connector;
            this.status = status;
            this.security = security;
            long seconds = System.currentTimeMillis() / 1000L;
            this.contentModificationTime = seconds * 1000L;
        }

        public <T extends Node> T modifyNode(T node) throws InformException {
            Node modifiedNode = this.modifiedNodes.get(node.getId());
            if (modifiedNode == null) {
                modifiedNode = node.clone(this.applicationId, this.status);
                this.modifiedNodes.add(modifiedNode);
            }
            return (T)modifiedNode;
        }

        public Node getNode(double id) throws InformException {
            Node node = this.modifiedNodes.get(id);
            if (node == null) {
                node = MtdEngine.getNode(id);
            }
            return node;
        }

        public Node getValidNode(double id) throws InformException {
            Node node = this.modifiedNodes.get(id);
            if (node == null) {
                node = MtdEngine.getValidNode(id);
            }
            return node;
        }

        public BasicNode getTranslatedNode(double id) throws InformException {
            Node node = this.getNode(id);
            if (node == null) {
                return null;
            }
            BasicNode refNode = node.getRefNode();
            if (refNode == null) {
                return null;
            }
            return (BasicNode)this.getNode(refNode.getId());
        }

        public BasicNode getValidTranslatedNode(double id) throws InformException {
            BasicNode node = this.getTranslatedNode(id);
            if (node == null) {
                MtdEngine.throwError(id, "\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
            return node;
        }
    }

    public static class NodeInfoArg {
        public final Security security;
        public BitSet nodeTypeFilter;
        public TaggedWriter out;
        public Connector connector;
        public int options = 0;

        public NodeInfoArg(Connector connector, Security security, BitSet nodeTypeFilter, TaggedWriter out) {
            this.security = security;
            this.nodeTypeFilter = nodeTypeFilter;
            this.out = out;
            this.connector = connector;
        }
    }

    public static class CreationArg {
        public String name = "";
        public String identifier = "";
        public double refNodeId = 0.0;
        public boolean clone = false;
    }
}

