/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.nodes;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.collections.DoubleHash;
import inform.agent.Core;
import inform.agent.mtd.MtdCache;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.NodeRecord;
import inform.agent.mtd.nodes.AccountNode;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.LostFoundNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.UserNode;
import inform.agent.mtd.nodes.UserRole;
import inform.agent.mtd.nodes.VirtualUser;
import inform.agent.mtd.request.NodeStatus;
import inform.common.Empty;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class NodeHashTable {
    private final DoubleHash<Node> nodes = new DoubleHash();
    private DoubleHash<Node> contentAttrNodes = null;
    private final DoubleHash<Node> lostNodes = new DoubleHash();
    private final DoubleHash<AccountNode> accountNodes = new DoubleHash();
    private final Map<String, DoubleHash<AccountNode>> accountsByName = new HashMap<String, DoubleHash<AccountNode>>();
    private final HashMap<String, Node> byIdent = new HashMap();
    private final MtdCache mtdCache;

    public NodeHashTable(MtdCache mtdCache) {
        this.mtdCache = mtdCache;
    }

    public synchronized Node get(double id) {
        return this.nodes.get(id);
    }

    public synchronized Node getByIdent(String ident) {
        return this.byIdent.get(ident);
    }

    public synchronized boolean put(Node node) {
        String ident;
        boolean replaced = false;
        Node old = this.nodes.add(node);
        if (old != null) {
            replaced = true;
            ident = old.getIdentName();
            if (!Strings.isVoid(ident)) {
                this.byIdent.remove(ident);
            }
        }
        if (!Strings.isVoid(ident = node.getIdentName())) {
            this.byIdent.put(ident, node);
        }
        if (node instanceof AccountNode) {
            this.accountNodes.add((AccountNode)node);
            String name = node.getName();
            DoubleHash<AccountNode> accounts = this.accountsByName.get(name);
            if (accounts == null) {
                accounts = new DoubleHash();
                this.accountsByName.put(name, accounts);
            }
            accounts.add((AccountNode)node);
        }
        return replaced;
    }

    public synchronized AccountNode getAccount(double id) {
        return this.accountNodes.get(id);
    }

    public synchronized DoubleHash<AccountNode> getAccountsWithName(String name) {
        return this.accountsByName.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserNode getUserNodeByName(String name, boolean external) throws InformException {
        if (external && MtdEngine.serverNode().descriptor().useUsersTable) {
            try {
                VirtualUser node = VirtualUser.getUser(name);
                if (node != null) {
                    return node;
                }
            }
            catch (IOException | SQLException e) {
                throw InformException.wrap(e);
            }
        }
        NodeHashTable nodeHashTable = this;
        synchronized (nodeHashTable) {
            DoubleHash<AccountNode> accounts = this.accountsByName.get(name);
            if (accounts != null) {
                for (AccountNode node : accounts) {
                    node.checkLoaded();
                    if (node.isBlocked() || node.getType() != 3 || node.isInTrashRecursive(this.mtdCache)) continue;
                    return (UserNode)node;
                }
            }
        }
        return null;
    }

    public synchronized UserNode[] findUsersIgnoreCase(String name) throws InformException {
        if (MtdEngine.serverNode().descriptor().useUsersTable) {
            try {
                VirtualUser node = VirtualUser.getUser(name);
                if (node != null) {
                    UserNode[] accounts = new UserNode[]{node};
                    return accounts;
                }
            }
            catch (IOException | SQLException e) {
                throw InformException.wrap(e);
            }
        }
        UserNode[] accounts = new UserNode[this.accountNodes.size()];
        int count = 0;
        for (AccountNode node : this.accountNodes) {
            node.checkLoaded();
            if (node.isBlocked() || node.getType() != 3 || !name.equalsIgnoreCase(node.getName()) || node.isInTrashRecursive(this.mtdCache)) continue;
            accounts[count++] = (UserNode)node;
        }
        return Arrays.copyOf(accounts, count);
    }

    public synchronized AccountNode[] getAccounts() throws InformException {
        AccountNode[] accounts = new AccountNode[this.accountNodes.size()];
        int count = 0;
        for (AccountNode node : this.accountNodes) {
            assert (count < accounts.length);
            node.checkLoaded();
            accounts[count++] = node;
        }
        return accounts;
    }

    public synchronized boolean containsAdminAccount() throws InformException {
        for (AccountNode node : this.accountNodes) {
            node.checkLoaded();
            if (node.isBlocked() || node.getType() != 3 || node.isInTrashRecursive(this.mtdCache) || ((UserNode)node).getRole() != UserRole.ADMIN) continue;
            return true;
        }
        return false;
    }

    public synchronized void init(MtdCache mtdCache) throws InterruptedException, InformException {
        this.contentAttrNodes = new DoubleHash();
        for (Node node : this.nodes) {
            node.initNode(mtdCache);
            if (!node.needCreateContentAttr()) continue;
            this.contentAttrNodes.add(node);
        }
    }

    public synchronized void buildChildrenCache() throws InformException {
        this.lostNodes.clear();
        HashMap<BasicNode, ArrayList<Node>> childrenCache = new HashMap<BasicNode, ArrayList<Node>>();
        for (Node node : this.nodes) {
            BasicNode parent;
            node.setChildrenCache(Empty.doubleArray);
            double nodeId = node.getId();
            if (nodeId == 0.0) continue;
            double parentId = node.getParentId();
            Node parentNode = this.nodes.get(parentId);
            if (parentNode == null) {
                Core.logger.error("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0443\u0437\u0435\u043b(nodeId: {}, parentId: {})", (long)nodeId, (long)parentId);
            }
            if (parentNode instanceof BasicNode) {
                parent = (BasicNode)parentNode;
            } else {
                parent = null;
                Core.logger.error("\u0423\u0437\u0435\u043b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0432\u044b\u0441\u0442\u0443\u043f\u0430\u0442\u044c \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e (nodeId: {}, parentId: {})", (long)nodeId, (long)parentId);
            }
            if (parent == null) {
                this.lostNodes.add(node);
                continue;
            }
            ArrayList<Node> children = (ArrayList<Node>)childrenCache.get(parent);
            if (children == null) {
                children = new ArrayList<Node>();
                childrenCache.put(parent, children);
            }
            children.add(node);
        }
        if (!this.lostNodes.empty() && this.nodes.get(9.0) == null) {
            NodeRecord record = new NodeRecord(NodeStatus.MODIFIED);
            record.setId(9.0);
            record.setType(0);
            record.setParentId(2.0);
            record.setName("lost+found");
            long l = System.currentTimeMillis();
            record.setCreationTime(l);
            record.setModificationContentTime(l);
            record.setModificationAttributeTime(l);
            LostFoundNode lostFound = new LostFoundNode(record);
            lostFound.checkLoaded();
            lostFound.afterCreateSystem();
            this.nodes.add(lostFound);
            ((ArrayList)childrenCache.get(this.nodes.get(lostFound.getParentId()))).add(lostFound);
            ((Node)lostFound).applyChanges();
        }
        for (Map.Entry entry : childrenCache.entrySet()) {
            Node parent = (Node)entry.getKey();
            ArrayList parentChildren = (ArrayList)entry.getValue();
            Collections.sort(parentChildren, new NodeOrderComparator());
            double[] children = new double[parentChildren.size()];
            int index = 0;
            for (Node node : parentChildren) {
                children[index++] = node.getId();
            }
            parent.setChildrenCache(children);
        }
    }

    public synchronized double[] getLostNodes() {
        double[] result = new double[this.lostNodes.size()];
        int idx = 0;
        for (Node n : this.lostNodes) {
            result[idx++] = n.getId();
        }
        return result;
    }

    public void buildRoles() throws InformException {
        long t = System.currentTimeMillis();
        for (AccountNode n : this.accountNodes) {
            n.effectiveGroups();
        }
        Core.logger.info("roles builded in {}ms", (Object)(System.currentTimeMillis() - t));
    }

    public synchronized DoubleHash<Node> getUnsettedContentAttrNodes() {
        DoubleHash<Node> unsettedNodes = this.contentAttrNodes;
        this.contentAttrNodes = null;
        if (unsettedNodes.empty()) {
            unsettedNodes = null;
        }
        return unsettedNodes;
    }

    private static class NodeOrderComparator
    implements Comparator<Node> {
        private NodeOrderComparator() {
        }

        @Override
        public int compare(Node o1, Node o2) {
            int result = o1.getOrderNo() - o2.getOrderNo();
            if (result == 0) {
                if (o1.getId() < o2.getId()) {
                    return -1;
                }
                if (o1.getId() > o2.getId()) {
                    return 1;
                }
                return 0;
            }
            return result;
        }
    }
}

