/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.nodes;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.collections.DoubleList;
import inform.adt.collections.DoubleSet;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.LittleEndianDataOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Ini;
import inform.agent.db.connect.Connector;
import inform.agent.mtd.MtdCache;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.NodeRecord;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Correlations;
import inform.agent.mtd.nodes.Node;
import inform.agent.net.Client;
import inform.agent.net.Security;
import inform.common.Empty;
import java.io.IOException;
import java.sql.SQLException;
import java.util.BitSet;

public class SymLinkNode
extends Node {
    private BasicNode modifiedRefNode = null;
    private double refNodeId;
    private boolean strict;

    public SymLinkNode(NodeRecord record) {
        super(record);
    }

    @Override
    public double getRefNodeId() {
        return this.refNodeId;
    }

    @Override
    public void getNodeInfo(Node.NodeInfoArg arg) throws IOException, InformException, SQLException, InterruptedException {
        arg.out.putDouble(1, this.getId());
        arg.out.putDouble(3, this.getParentId());
        arg.out.putAnsi(4, this.getName());
        arg.out.putDouble(7, this.refNodeId);
        int intProp = this.getUiStyle();
        if (intProp != 0) {
            arg.out.putInt32(8, intProp);
        }
        if ((intProp = this.getUiImageId()) != 0) {
            arg.out.putInt32(9, intProp);
        }
        arg.out.putAnsiIf(13, this.getIdentName());
        intProp = this.getDefaultAction();
        if (intProp != 0) {
            arg.out.putInt32(16, intProp);
        }
        int accessMask = arg.security.accessMask(this);
        arg.out.putInt32(18, accessMask);
        arg.out.putBool(19, this.strict);
        BasicNode ref = this.getRefNode();
        if (ref != null) {
            arg.out.putInt32(2, ref.getType());
            if (!this.strict && !this.isInTrash()) {
                if (arg.nodeTypeFilter == null) {
                    if (ref.hasChilldren(arg.connector)) {
                        arg.out.putEmpty(10);
                    }
                } else {
                    DoubleSet processedNodes = new DoubleSet();
                    if (this.hasFilteredChildren(arg.connector, arg.nodeTypeFilter, processedNodes)) {
                        arg.out.putEmpty(10);
                    }
                }
            }
            arg.out.putBool(20, ref.isInheritedAcl());
            arg.out.putAnsiIf(12, ref.getDescription());
            arg.out.putDouble(46, DateTime.fromUnixTime(this.getCreationTime()));
            arg.out.putDouble(47, DateTime.fromUnixTime(ref.getModificationContentTime()));
            arg.out.putDouble(54, ref.getModificationUserId());
            arg.out.putDouble(48, DateTime.fromUnixTime(this.getModificationAttributeTime()));
            arg.out.putDouble(49, ref.getLastAccessTime());
            arg.out.putBool(56, ref.isAuditEvents() || Ini.AuditAll);
        }
        ByteArrayOutputStream nodeTime = new ByteArrayOutputStream();
        LittleEndianDataOutputStream data = new LittleEndianDataOutputStream(nodeTime);
        data.writeDouble(DateTime.fromUnixTime(this.getCreationTime()));
        data.writeDouble(DateTime.fromUnixTime(this.getModificationContentTime()));
        data.writeDouble(this.getLastAccessTime());
        data.flush();
        arg.out.putRaw(43, nodeTime);
        if (this.isInTrashRecursive() || ref != null && ref.isInTrashRecursive()) {
            arg.out.putEmpty(66);
        }
    }

    @Override
    protected void loadTag(MtdCache mtdCache, TaggedReader in) throws InformException, TaggedReaderException, IOException, InterruptedException {
        switch (in.getCurrentTag()) {
            case 4: {
                double[] data = LittleEndian.toDoubleArray(in.getRaw());
                this.refNodeId = data[0];
                this.loadedCreationTime(data[1]);
                break;
            }
            case 17: {
                this.strict = in.getBooleanDef(true);
                break;
            }
            case 24: {
                this.refNodeId = in.getDouble();
                break;
            }
            default: {
                super.loadTag(null, in);
            }
        }
    }

    public void setModifiedRefNode(BasicNode node) {
        this.modifiedRefNode = node;
    }

    @Override
    protected BasicNode getRefNode(int loops) throws InformException {
        if (this.modifiedRefNode != null) {
            return this.modifiedRefNode;
        }
        if (loops < 0) {
            throw new InformException("Too many resolving cycles for symlink");
        }
        Node node = MtdEngine.getNode(this.refNodeId);
        if (node == null || node.getId() == this.getId()) {
            return null;
        }
        return node.getRefNode(loops - 1);
    }

    @Override
    public BasicNode getRealNode(int loops) throws InformException {
        if (loops < 0) {
            throw new InformException("Too many resolving cycles for symlink");
        }
        return MtdEngine.getValidNode(this.refNodeId).getRealNode(loops - 1);
    }

    @Override
    public void getAclContent(TaggedWriter out) throws InformException {
        BasicNode node = this.getRefNode();
        if (node != null) {
            node.getAclContent(out);
        }
    }

    @Override
    public String getNewChildName(Connector connector, String name) throws InformException {
        BasicNode node = this.getRefNode();
        if (node == null) {
            return name;
        }
        return node.getNewChildName(connector, name);
    }

    @Override
    public void enumerateChildren(Connector connector, BitSet nodeTypeFilter, DoubleSet children, DoubleSet excludeNodes, DoubleList orderedChildren) throws InformException, SQLException {
    }

    @Override
    public void enumerateDependedOn(double dependedId, Connector connector, int tag, TaggedWriter out) throws IOException, SQLException, InterruptedException {
        BasicNode node = this.getRefNode();
        if (node != null) {
            node.enumerateDependedOn(dependedId, connector, tag, out);
        }
    }

    @Override
    public double[] getChildren(Connector connector) throws InformException {
        BasicNode node = this.getRefNode();
        if (node == null) {
            return Empty.doubleArray;
        }
        return node.getChildren(connector);
    }

    @Override
    protected boolean hasFilteredChildren(Connector connector, BitSet nodeTypeFilter, DoubleSet processedNodes) throws InformException, SQLException {
        if (nodeTypeFilter != null && !nodeTypeFilter.get(this.getType())) {
            return false;
        }
        if (!processedNodes.add(this.getId())) {
            return false;
        }
        BasicNode node = this.getRefNode();
        if (node == null) {
            return false;
        }
        return node.hasFilteredChildren(connector, nodeTypeFilter, processedNodes);
    }

    @Override
    protected double[] getFilteredChildren(Connector connector, BitSet nodeTypeFilter) throws InformException, SQLException {
        BasicNode node = this.getRefNode();
        if (node == null) {
            return Empty.doubleArray;
        }
        return node.getFilteredChildren(connector, nodeTypeFilter);
    }

    @Override
    protected void setDescription(String description) throws InformException {
        BasicNode node = this.getRefNode();
        if (node != null) {
            node.setDescription(description);
        }
    }

    @Override
    protected void replicationStoreAttributes(int mask, TaggedWriter out, Connector connector, Client client) throws InformException, IOException {
        super.replicationStoreAttributes(mask, out, connector, client);
        out.putDouble(24, this.refNodeId);
        out.putBool(17, this.strict);
    }

    @Override
    protected double replicationStoreContent(TaggedWriter out, Connector connector, Client client) throws InformException, IOException {
        return 0.0;
    }

    @Override
    public void loadReplicationTag(int tag, Node.ModifyNodeArg arg, int mask) throws IOException, TaggedReaderException, InformException, SQLException {
        assert (this.status != null);
        TaggedReader in = arg.in;
        switch (tag) {
            case 24: {
                this.loadModifyTag(7, arg);
                break;
            }
            case 17: {
                this.loadModifyTag(19, arg);
                break;
            }
            default: {
                super.loadReplicationTag(tag, arg, mask);
            }
        }
    }

    @Override
    public void storeAttributes(TaggedWriter out) throws InformException, IOException {
        super.storeAttributes(out);
        if (this.refNodeId != 0.0) {
            out.putDouble(24, this.refNodeId);
        }
        if (this.strict) {
            out.putEmpty(17);
        }
    }

    @Override
    public void loadModifyTag(int tag, Node.ModifyNodeArg arg) throws IOException, TaggedReaderException, InformException, SQLException {
        assert (this.status != null);
        TaggedReader in = arg.in;
        switch (tag) {
            case 5: 
            case 20: 
            case 64: 
            case 65: {
                BasicNode node = this.getRefNode();
                if (node == null) break;
                node = arg.modifyNode(node);
                node.loadModifyTag(tag, arg);
                break;
            }
            case 7: {
                this.refNodeId = in.getDouble();
                this.setAttrModified();
                break;
            }
            case 19: {
                this.strict = in.getBoolean();
                this.setAttrModified();
                break;
            }
            default: {
                super.loadModifyTag(tag, arg);
            }
        }
    }

    @Override
    public void afterCreateNew(Node.CreationArg arg) throws InformException {
        this.refNodeId = arg.refNodeId;
        this.setAttrModified();
        super.afterCreateNew(arg);
    }

    @Override
    public byte[] replaceDependencies(Correlations dependencies, byte[] content) throws InformException {
        assert (this.status != null);
        this.refNodeId = dependencies.getCorrelation(this.refNodeId);
        return null;
    }

    @Override
    public void setChildrenCache(double[] cache) {
        assert (cache == null || cache.length == 0);
    }

    @Override
    protected boolean hasFilteredChildren(Connector connector, BitSet nodeTypeFilter, int permissions, Security security, DoubleSet processedNodes) throws InformException, SQLException {
        if (nodeTypeFilter != null && !nodeTypeFilter.get(this.getType())) {
            return false;
        }
        if (!processedNodes.add(this.getId())) {
            return false;
        }
        BasicNode node = this.getRefNode();
        if (node == null) {
            return false;
        }
        return node.hasFilteredChildren(connector, nodeTypeFilter, permissions, security, processedNodes);
    }

    @Override
    protected double[] getFilteredChildren(Connector connector, BitSet nodeTypeFilter, int permissions, Security security) throws InformException, SQLException {
        BasicNode node = this.getRefNode();
        if (node == null) {
            return Empty.doubleArray;
        }
        return node.getFilteredChildren(connector, nodeTypeFilter, permissions, security);
    }

    @Override
    public void getChildInfo(Node child, Node.NodeInfoArg arg) throws InformException, IOException, SQLException, InterruptedException {
        if (child.getParentId() != this.refNodeId) {
            return;
        }
        child.getNodeInfo(arg);
    }
}

