/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.nodes;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.collections.DoubleSet;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.connect.Connector;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.NodeRecord;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.SystemNode;
import inform.agent.mtd.nodes.UserRole;
import inform.agent.net.Client;
import inform.agent.net.Security;
import inform.common.Empty;
import java.io.IOException;
import java.sql.SQLException;
import java.util.BitSet;

public class TrashNode
extends SystemNode {
    public TrashNode(NodeRecord record) {
        super(record);
        assert (record.getType() == 1);
        assert (record.getId() == 1.0);
    }

    @Override
    protected void checkChildName(String newName, double checkedId, Node.ModifyNodeArg arg) {
    }

    @Override
    protected double[] getFilteredChildren(Connector connector, BitSet nodeTypeFilter) throws InformException, SQLException {
        return Empty.doubleArray;
    }

    @Override
    protected boolean hasFilteredChildren(Connector connector, BitSet nodeTypeFilter, DoubleSet processedNodes) throws InformException, SQLException {
        return false;
    }

    @Override
    protected boolean hasFilteredChildren(Connector connector, BitSet nodeTypeFilter, int permissions, Security security, DoubleSet processedNodes) throws InformException, SQLException {
        return false;
    }

    @Override
    protected double[] getFilteredChildren(Connector connector, BitSet nodeTypeFilter, int permissions, Security security) throws InformException, SQLException {
        return Empty.doubleArray;
    }

    @Override
    public void getChildInfo(Node child, Node.NodeInfoArg arg) throws InformException, IOException, SQLException, InterruptedException {
        if (child.getParentId() != this.getId()) {
            return;
        }
        if (child.getUndeleteUserId() == arg.security.id || arg.security.role() == UserRole.ADMIN) {
            child.getNodeInfo(arg);
        }
    }

    @Override
    protected void replicationStoreAttributes(int mask, TaggedWriter out, Connector connector, Client client) throws InformException, IOException {
        double[] children;
        super.replicationStoreAttributes(mask, out, connector, client);
        ByteArrayOutputStream deletedNodes = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(deletedNodes);
        for (double childId : children = this.getChildren(connector)) {
            Node node = MtdEngine.getNode(childId);
            if (node == null || client != null && node.getOwnerId() != client.getUserId() && node.getUndeleteUserId() != client.getUserId()) continue;
            double[] data = new double[]{node.getUndeletePatentId(), node.getUndeleteUserId()};
            writer.putDouble(1, childId);
            writer.putRaw(2, LittleEndian.doubleArrayToBinary(data, data.length));
        }
        writer.flush();
        if (deletedNodes.size() != 0) {
            out.putRaw(35, deletedNodes.internalBuffer(), deletedNodes.size());
        }
    }

    @Override
    public void loadReplicationTag(int tag, Node.ModifyNodeArg arg, int mask) throws IOException, TaggedReaderException, InformException, SQLException {
        switch (tag) {
            case 35: {
                TaggedReader reader = arg.in.getStreamReader();
                while (reader.next()) {
                    Node node;
                    double nodeId = reader.getDouble(1);
                    double[] data = LittleEndian.toDoubleArray(reader.getRaw(2));
                    if (data.length != 2 || (node = MtdEngine.getNode(nodeId)) == null) continue;
                    if (node.isInTrashRecursive()) {
                        return;
                    }
                    node = arg.modifyNode(node);
                    node.changeParent(1.0, arg);
                    node.setModificationAttributeTime(System.currentTimeMillis());
                }
                break;
            }
            default: {
                super.loadReplicationTag(tag, arg, mask);
            }
        }
    }

    @Override
    public void enumerateDependedOn(double dependedId, Connector connector, int tag, TaggedWriter out) throws IOException, SQLException, InterruptedException {
    }
}

