/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DAgreementComponent;
import inform.agent.mtd.obj.DAgreementDocInfoComponent;
import inform.agent.mtd.obj.DBarcodeScanner;
import inform.agent.mtd.obj.DComponent;
import inform.agent.mtd.obj.DControl;
import inform.agent.mtd.obj.DDatalocator;
import inform.agent.mtd.obj.DDbfReader;
import inform.agent.mtd.obj.DDocumentComponent;
import inform.agent.mtd.obj.DEditUserComponent;
import inform.agent.mtd.obj.DExternalAppComponent;
import inform.agent.mtd.obj.DExternalFilesComponent;
import inform.agent.mtd.obj.DFormButton;
import inform.agent.mtd.obj.DFormCheckBox;
import inform.agent.mtd.obj.DFormControl;
import inform.agent.mtd.obj.DFormDiagram;
import inform.agent.mtd.obj.DFormDocument;
import inform.agent.mtd.obj.DFormEdit;
import inform.agent.mtd.obj.DFormFrame;
import inform.agent.mtd.obj.DFormGrid;
import inform.agent.mtd.obj.DFormImage;
import inform.agent.mtd.obj.DFormLabel;
import inform.agent.mtd.obj.DFormLauncherComponent;
import inform.agent.mtd.obj.DFormMetaTree;
import inform.agent.mtd.obj.DFormNavigator;
import inform.agent.mtd.obj.DFormPageControl;
import inform.agent.mtd.obj.DFormPanel;
import inform.agent.mtd.obj.DFormRadioButton;
import inform.agent.mtd.obj.DFormRowSelectorComponent;
import inform.agent.mtd.obj.DFormScheme;
import inform.agent.mtd.obj.DFormSplitter;
import inform.agent.mtd.obj.DFormTabs;
import inform.agent.mtd.obj.DFormTabshit;
import inform.agent.mtd.obj.DFormTree;
import inform.agent.mtd.obj.DGanttChartComponent;
import inform.agent.mtd.obj.DMessageExchange;
import inform.agent.mtd.obj.DNodeLauncherComponent;
import inform.agent.mtd.obj.DObject;
import inform.agent.mtd.obj.DParamsInputComponent;
import inform.agent.mtd.obj.DPeriodAdjust;
import inform.agent.mtd.obj.DPopupMenuComponent;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DReplicaLauncherComponent;
import inform.agent.mtd.obj.DReportLauncherComponent;
import inform.agent.mtd.obj.DScriptLauncher;
import inform.agent.mtd.obj.DSecurityComponent;
import inform.agent.mtd.obj.DServerTask;
import inform.agent.mtd.obj.DSignEditorComponent;
import inform.agent.mtd.obj.DSignSelectorComponent;
import inform.agent.mtd.obj.DSpExecComponent;
import inform.agent.mtd.obj.DSpellCheckComponent;
import inform.agent.mtd.obj.NonVisualComponent;
import inform.agent.mtd.obj.RawObject;
import inform.agent.mtd.obj.UnimplementedComponent;
import inform.agent.mtd.obj.UninplementedControl;
import java.io.IOException;
import java.util.ArrayList;

public class DComponents
extends DObject {
    public DComponents(DProperty object, int propOptions) {
        super(object, "components", propOptions | 0x10);
    }

    public void afterLoad() {
        for (DProperty property : this.properties) {
            if (!(property instanceof DComponent)) continue;
            ((DComponent)property).afterLoad();
        }
    }

    @Override
    public int storeTextContent(int textOptions, StringBuilder out, int level, boolean needComma) {
        int propLevel = level + 1;
        int outputCount = this.unhandledItems.size();
        boolean comma = false;
        DComponents.addTextShiftLn(0, out, level).append("components: [");
        for (DProperty property : this.properties) {
            comma = true;
            outputCount += property.storeTextContent(0, out, propLevel, comma);
        }
        if (!this.unhandledItems.isEmpty()) {
            DComponents.addNewLineIfNeed(0, out);
            DComponents.addTextShiftLn(0, out, propLevel);
            DComponents.addComma(out, comma);
            out.append("unknownTags: [");
            int lastIndex = this.unhandledItems.size() - 1;
            for (int index = 0; index <= lastIndex; ++index) {
                RawObject item = (RawObject)this.unhandledItems.get(index);
                item.storeTextContent(textOptions, out, level + 2, index != lastIndex);
            }
            DComponents.addTextShiftLn(0, out, propLevel).append("]");
        }
        DComponents.addComma(DComponents.addTextShiftLn(0, out, level).append("]"), needComma);
        return outputCount;
    }

    public void loadTaggedContent(TaggedReader in, DComponent owner, DControl parent) throws IOException {
        int newComponentIndex = -1;
        DFormControl newControl = null;
        DComponent newComponent = null;
        block25: while (in.next()) {
            switch (in.getCurrentTag()) {
                case 2: {
                    in.checkCurrentTag(2, 28);
                    int[] header = LittleEndian.toIntArray(in.getRaw());
                    newControl = DComponents.loadDesignControl(header, owner, parent, in.getStreamReader(202));
                    newComponent = newControl;
                    if (newControl != null) {
                        newComponentIndex = this.properties.size();
                        this.registerProperty(newControl);
                        newControl.parentFont.value = false;
                        continue block25;
                    }
                    newComponentIndex = -1;
                    continue block25;
                }
                case 20: {
                    in.checkCurrentTag(20, 28);
                    int[] header = LittleEndian.toIntArray(in.getRaw());
                    newComponent = DComponents.loadDesignComponent(header, owner, in.getStreamReader(202));
                    if (newComponent != null) {
                        newComponentIndex = this.properties.size();
                        this.registerProperty(newComponent);
                        continue block25;
                    }
                    newComponentIndex = -1;
                    continue block25;
                }
                case 5: {
                    if (newControl == null) continue block25;
                    in.checkCurrentTag(5, 2);
                    byte[] layout = in.getRaw();
                    newControl.setAlign(layout[0]);
                    newControl.setAnchors(layout[1]);
                    continue block25;
                }
                case 8: {
                    if (newControl == null) continue block25;
                    newControl.setVisible(false);
                    continue block25;
                }
                case 7: {
                    if (newControl == null) continue block25;
                    newControl.setEnabled(false);
                    continue block25;
                }
                case 9: {
                    if (newControl == null) continue block25;
                    newControl.setHint(in.getString());
                    continue block25;
                }
                case 3: {
                    in.skip();
                    if (0 <= newComponentIndex && newComponentIndex <= this.properties.size()) {
                        this.loadTaggedContent(in.getStreamReader(202), owner, newControl);
                        continue block25;
                    }
                    in.skip();
                    continue block25;
                }
                case 10: {
                    if (newControl == null) continue block25;
                    newControl.constraints.loadTaggedContent(in);
                    continue block25;
                }
                case 34: {
                    if (newControl == null) continue block25;
                    in.checkCurrentTag(34, 16);
                    newControl.margins.loadTaggedContent(in);
                    newControl.alignWithMargins.value = true;
                    continue block25;
                }
                case 11: {
                    if (newControl == null) continue block25;
                    newControl.color.loadTaggedContent(in);
                    newControl.parentColor.value = false;
                    continue block25;
                }
                case 30: {
                    if (newControl == null) continue block25;
                    newControl.parentColor.value = true;
                    continue block25;
                }
                case 6: {
                    if (newControl == null) continue block25;
                    newControl.font.loadTaggedContent(in);
                    continue block25;
                }
                case 31: {
                    if (newControl == null) continue block25;
                    newControl.setPopupMenuID(in.getInt());
                    continue block25;
                }
                case 12: {
                    if (newControl == null) continue block25;
                    newControl.parentFont.value = true;
                    continue block25;
                }
                case 19: {
                    if (newControl == null) continue block25;
                    newControl.action.loadTaggedContent(in);
                    continue block25;
                }
                case 13: {
                    DProperty component;
                    if (0 > newComponentIndex || newComponentIndex > this.properties.size() || (component = (DComponent)this.properties.get(newComponentIndex)) == null) continue block25;
                    ((DComponent)component).setScriptName(in.getString());
                    continue block25;
                }
                case 154: {
                    if (newComponent == null) continue block25;
                    newComponent.accessRights.loadTaggedContent(in);
                    continue block25;
                }
                case 16: {
                    newControl = null;
                    newComponentIndex = -1;
                    newComponent = null;
                    continue block25;
                }
                case 21: {
                    newComponentIndex = -1;
                    newComponent = null;
                    continue block25;
                }
                case 39: {
                    DProperty component;
                    switch (in.getInt()) {
                        case 1: {
                            if (newControl == null) continue block25;
                            newControl.ranking.loadTaggedContent(in.getSubStreamReader());
                            continue block25;
                        }
                    }
                    if (0 <= newComponentIndex && newComponentIndex <= this.properties.size()) {
                        component = (DProperty)this.properties.get(newComponentIndex);
                        if (component == null) continue block25;
                        component.addUnhandled().loadTaggedContent(in);
                        continue block25;
                    }
                    this.addUnhandled().loadTaggedContent(in);
                    continue block25;
                }
            }
            this.addUnhandled().loadTaggedContent(in);
        }
    }

    public void storeTaggedChildren(ArrayList<DComponent> components, TaggedWriter out) throws IOException {
        for (DComponent component : components) {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            TaggedWriter stream = new TaggedWriter(data);
            int[] header = new int[7];
            component.storeTaggedContent(header, stream);
            stream.flush();
            if (component instanceof DFormControl) {
                DFormControl control = (DFormControl)component;
                out.putRaw(2, LittleEndian.intArrayToBinary(header, header.length));
                out.putRaw(202, data);
                data.reset();
                stream.reset(data);
                control.ranking.storeTaggedContent(stream);
                stream.flush();
                if (data.size() != 0) {
                    out.putInt32(39, 1);
                    out.putRaw(202, data.internalBuffer(), data.size());
                }
                control.accessRights.storeTaggedContentAs(154, out);
                control.scriptName.storeTaggedContentAs(13, out);
                if (control.enabled.isStorable() && !control.enabled.value) {
                    out.putEmpty(7);
                }
                if (!(!control.align.isStorable() && !control.anchors.isStorable() || control.align.isDefault() && control.anchors.isDefault())) {
                    byte[] layout = new byte[]{(byte)control.align.value, (byte)control.anchors.value};
                    out.putRaw(5, layout);
                }
                control.parentColor.storeTaggedContentAs(30, out);
                control.color.storeTaggedContentAs(11, out);
                control.hint.storeTaggedContentAs(9, out);
                this.storeTaggedChildren(control, out);
                if (control.visible.isStorable() && !control.visible.value) {
                    out.putEmpty(8);
                }
                control.constraints.storeTaggedContentAs(10, out);
                control.margins.storeTaggedContentAs(34, out);
                control.font.storeTaggedContentAs(6, out);
                control.parentFont.storeTaggedContentAs(12, out);
                control.action.storeTaggedContentAs(19, out);
                control.popupMenu.storeTaggedContentAs(31, out);
                out.putEmpty(16);
                continue;
            }
            out.putRaw(20, LittleEndian.intArrayToBinary(header, header.length));
            out.putRaw(202, data);
            component.accessRights.storeTaggedContentAs(154, out);
            component.scriptName.storeTaggedContentAs(13, out);
            this.storeTaggedChildren(component, out);
            out.putEmpty(21);
        }
    }

    public void storeTaggedChildren(DComponent parent, TaggedWriter out) throws IOException {
        ArrayList<DComponent> children = parent.getChildren();
        if (children != null) {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            TaggedWriter stream = new TaggedWriter(data);
            this.storeTaggedChildren(children, stream);
            out.putEmpty(3);
            out.putRaw(202, data);
        }
    }

    public NonVisualComponent findComponent(int id) {
        for (DProperty property : this.properties) {
            if (!(property instanceof DComponent)) continue;
            DComponent component = (DComponent)property;
            if (component.id.value != id || component.isControl() || !(component instanceof NonVisualComponent)) continue;
            return (NonVisualComponent)component;
        }
        return null;
    }

    public DControl findControl(int id) {
        for (DProperty property : this.properties) {
            if (!(property instanceof DComponent)) continue;
            DComponent component = (DComponent)property;
            if (component.id.value != id || !component.isControl() || !(component instanceof DControl)) continue;
            return (DControl)component;
        }
        return null;
    }

    static NonVisualComponent createDesignComponent(int[] header, DComponent owner) {
        NonVisualComponent component;
        int componentType = header[0];
        switch (componentType) {
            case 603: {
                component = new DExternalAppComponent(header[1], header[6]);
                break;
            }
            case 501: {
                component = new DSpExecComponent(header[1], header[6]);
                break;
            }
            case 405: {
                component = new DReplicaLauncherComponent(header[1], header[6]);
                break;
            }
            case 11: {
                component = new DGanttChartComponent(header[1], header[6]);
                break;
            }
            case 201: {
                component = new DReportLauncherComponent(header[1], header[6]);
                break;
            }
            case 701: {
                component = new DSignSelectorComponent(header[1], header[6]);
                break;
            }
            case 702: {
                component = new DSignEditorComponent(header[1], header[6]);
                break;
            }
            case 1501: {
                component = new DEditUserComponent(header[1], header[6]);
                break;
            }
            case 1: {
                component = new DFormLauncherComponent(header[1], header[6]);
                break;
            }
            case 3: {
                component = new DFormRowSelectorComponent(header[1], header[6]);
                break;
            }
            case 8: {
                component = new DPeriodAdjust(header[1], header[6]);
                break;
            }
            case 9: {
                component = new DServerTask(header[1], header[6]);
                break;
            }
            case 301: {
                component = new DScriptLauncher(header[1], header[6]);
                break;
            }
            case 602: {
                component = new DMessageExchange(header[1], header[6]);
                break;
            }
            case 502: {
                component = new DDatalocator(header[1], header[6]);
                break;
            }
            case 5: {
                component = new DPopupMenuComponent(header[1], header[6]);
                break;
            }
            case 404: {
                component = new DBarcodeScanner(header[1], header[6]);
                break;
            }
            case 6: {
                component = new DParamsInputComponent(header[1], header[6]);
                break;
            }
            case 10: {
                component = new DSpellCheckComponent(header[1], header[6]);
                break;
            }
            case 401: {
                component = new DDbfReader(header[1], header[6]);
                break;
            }
            case 1301: {
                component = new DDocumentComponent(header[1], header[6]);
                break;
            }
            case 802: {
                component = new DAgreementDocInfoComponent(header[1], header[6]);
                break;
            }
            case 403: {
                component = new DExternalFilesComponent(header[1], header[6]);
                break;
            }
            case 7: {
                component = new DSecurityComponent(header[1], header[6]);
                break;
            }
            case 801: {
                component = new DAgreementComponent(header[1], header[6]);
                break;
            }
            case 601: {
                component = new DNodeLauncherComponent(header[1], header[6]);
                break;
            }
            default: {
                component = new UnimplementedComponent(componentType, header[1], header[6]);
            }
        }
        return component;
    }

    private static DComponent loadDesignComponent(int[] header, DComponent owner, TaggedReader in) throws IOException {
        NonVisualComponent component = DComponents.createDesignComponent(header, owner);
        component.setOwner(owner);
        component.loadTaggedContent(in);
        return component;
    }

    static DFormControl createDesignControl(int[] header, DComponent owner, DControl parent) {
        DFormControl control;
        int controlType = header[0];
        switch (controlType) {
            case 1: {
                control = new DFormLabel(header[1], header[2], header[3], header[4], header[5], header[6]);
                break;
            }
            case 2: {
                control = new DFormEdit(header[1], header[2], header[3], header[4], header[5], header[6]);
                break;
            }
            case 5: {
                control = new DFormRadioButton(header[1], header[2], header[3], header[4], header[5], header[6]);
                break;
            }
            case 8: {
                control = new DFormImage(header[1], header[2], header[3], header[4], header[5], header[6]);
                break;
            }
            case 26: {
                control = new DFormTabs(header[1], header[2], header[3], header[4], header[5], header[6]);
                break;
            }
            case 4: {
                control = new DFormCheckBox(header[1], header[2], header[3], header[4], header[5], header[6]);
                break;
            }
            case 15: {
                control = new DFormSplitter(header[1], header[2], header[3], header[4], header[5], header[6]);
                break;
            }
            case 21: {
                control = new DFormScheme(header[1], header[2], header[3], header[4], header[5], header[6]);
                break;
            }
            case 7: {
                control = new DFormPanel(header[1], header[2], header[3], header[4], header[5], header[6]);
                break;
            }
            case 3: {
                control = new DFormButton(header[1], header[2], header[3], header[4], header[5], header[6]);
                break;
            }
            case 9: {
                control = new DFormPageControl(header[1], header[2], header[3], header[4], header[5], header[6]);
                break;
            }
            case 10: {
                control = new DFormTabshit(header[1], header[2], header[3], header[4], header[5], header[6]);
                break;
            }
            case 27: {
                control = new DFormDocument(header[1], header[2], header[3], header[4], header[5], header[6]);
                break;
            }
            case 14: {
                control = new DFormDiagram(header[1], header[2], header[3], header[4], header[5], header[6]);
                break;
            }
            case 12: {
                control = new DFormNavigator(header[1], header[2], header[3], header[4], header[5], header[6]);
                break;
            }
            case 13: {
                control = new DFormFrame(header[1], header[2], header[3], header[4], header[5], header[6]);
                break;
            }
            case 17: {
                control = new DFormMetaTree(header[1], header[2], header[3], header[4], header[5], header[6]);
                break;
            }
            case 11: {
                control = new DFormGrid(header[1], header[2], header[3], header[4], header[5], header[6]);
                break;
            }
            case 20: {
                control = new DFormTree(header[1], header[2], header[3], header[4], header[5], header[6]);
                break;
            }
            default: {
                control = new UninplementedControl(controlType, header[1], header[2], header[3], header[4], header[5], header[6]);
            }
        }
        control.setOwner(owner);
        control.setParent(parent);
        return control;
    }

    private static DFormControl loadDesignControl(int[] header, DComponent owner, DControl parent, TaggedReader in) throws IOException {
        DFormControl control = DComponents.createDesignControl(header, owner, parent);
        control.loadTaggedContent(in);
        return control;
    }
}

