/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DBuildupDatasource;
import inform.agent.mtd.obj.DDatamodelNode;
import inform.agent.mtd.obj.DDatasource;
import inform.agent.mtd.obj.DDirectoryDatasource;
import inform.agent.mtd.obj.DParameter;
import inform.agent.mtd.obj.DParameters;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyEnum;
import java.io.IOException;
import java.util.HashSet;

public class DDatamodel
extends DDatamodelNode {
    protected int uidGenerator = 0;
    protected final DPropertyEnum paramApplying = new DPropertyEnum(this, "paramApplying", 32770, PARAM_APPLYING_TO_DATASOURCE_NAMES);
    protected final DParameters parameters = new DParameters((DProperty)this, DParameters.Kind.Client);

    public DDatamodel(DProperty object) {
        super(object, "datamodel", 4, null, "MtdForm.datamodel");
        this.uid.value = -1;
        this.nodeType.value = 1;
        this.unique.setStorable(false);
        this.dsl = "MtdForm.datamodel";
    }

    public DDatasource findDatasource(int uid) {
        DDatamodelNode node = this.find(uid);
        if (node instanceof DDatasource) {
            return (DDatasource)node;
        }
        return null;
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        in.get(150);
        if (in.getInt(3) != 1) {
            throw new InformException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043f\u043e\u0442\u043e\u043a\u0430 \u043c\u043e\u0434\u0435\u043b\u0438 \u0434\u0430\u043d\u043d\u044b\u0445");
        }
        in.skipInt();
        DDatamodelNode node = this;
        HashSet names = new HashSet();
        while (in.next()) {
            if (in.getCurrentTag() == 3) {
                int parentUID;
                DDatamodelNode parent;
                int type = in.getInt();
                node = this.createNode(type, parent = this.find(parentUID = in.getInt(2)));
                if (node == null) continue;
                if (parent != null) {
                    node.parent.datasources.properties.add(node);
                }
            } else if (node != null) {
                ((DDatamodelNode)node).loadTag(in);
            }
            if (this.uidGenerator >= node.uid.value) continue;
            this.uidGenerator = node.uid.value;
        }
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        out.putEmpty(150);
        this.storeTagged(this, out);
    }

    @Override
    protected void loadTag(TaggedReader in) throws IOException {
        switch (in.getCurrentTag()) {
            case 50: {
                this.uidGenerator = in.getInt();
                break;
            }
            case 51: {
                this.paramApplying.loadTaggedContent(in);
                break;
            }
            case 4: 
            case 153: {
                this.parameters.loadTaggedContent(in.getSubStreamReader());
                break;
            }
            case 6: {
                int tag;
                TaggedReader info = in.getSubStreamReader();
                block6: while ((tag = info.getNextTag()) != 0) {
                    if (tag != 30) continue;
                    int id = info.getInt();
                    DParameter par = null;
                    for (DProperty prop : this.parameters.properties) {
                        if (!(prop instanceof DParameter)) continue;
                        DParameter p = (DParameter)prop;
                        if (p.id.value != id) continue;
                        par = p;
                        break;
                    }
                    while ((tag = info.getNextTag()) != 0) {
                        if (tag == 33) {
                            if (par == null) continue;
                            par.onChange.loadTaggedContent(info);
                            continue;
                        }
                        if (tag == 45) {
                            if (par == null) continue;
                            par.onBeforeChange.loadTaggedContent(info);
                            continue;
                        }
                        if (tag != 31) continue;
                        continue block6;
                    }
                }
                break;
            }
            default: {
                super.loadTag(in);
            }
        }
    }

    @Override
    protected void internalStoreTaggedContent(TaggedWriter out) throws IOException {
        super.internalStoreTaggedContent(out);
        out.putInt32(50, this.uidGenerator);
        this.paramApplying.storeTaggedContentIf(51, out);
        this.parameters.storeTaggedContentAsNonEmptyStream(153, out);
        if (!this.parameters.properties.isEmpty()) {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            TaggedWriter stream = new TaggedWriter(data);
            for (DProperty p : this.parameters.properties) {
                if (!(p instanceof DParameter)) continue;
                DParameter par = (DParameter)p;
                stream.putInt32(30, par.id.value);
                if (!par.onChange.isEmpty()) {
                    stream.putAnsiIf(33, par.onChange.value);
                }
                if (!par.onBeforeChange.isEmpty()) {
                    stream.putAnsiIf(45, par.onBeforeChange.value);
                }
                stream.putEmpty(31);
            }
            stream.flush();
            if (data.size() != 0) {
                out.putEmpty(6);
                out.putRaw(202, data);
            }
        }
    }

    private void storeTagged(DDatamodelNode node, TaggedWriter out) throws IOException {
        node.nodeType.storeTaggedContentAs(3, out);
        out.putInt32(2, node.parent != null ? node.parent.uid.value : -1);
        node.internalStoreTaggedContent(out);
        for (DProperty p : node.datasources.properties) {
            if (!(p instanceof DDatamodelNode)) continue;
            this.storeTagged((DDatamodelNode)p, out);
        }
    }

    @Override
    protected DDatamodel getDatamodel() {
        return this;
    }

    DDatamodelNode createNode(int nodeType, DDatamodelNode parent) {
        switch (nodeType) {
            case 2: 
            case 6: 
            case 7: {
                return new DDatasource((DProperty)this, nodeType, parent);
            }
            case 4: {
                return new DDirectoryDatasource((DProperty)this, parent);
            }
            case 5: {
                return new DBuildupDatasource((DProperty)this, parent);
            }
        }
        return null;
    }
}

