/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.TableDescriptor;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.obj.DDatamodelNode;
import inform.agent.mtd.obj.DDatasourceLoadOptions;
import inform.agent.mtd.obj.DDatasourceSortField;
import inform.agent.mtd.obj.DDatasourceSorting;
import inform.agent.mtd.obj.DParametersMap;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyBool;
import inform.agent.mtd.obj.DPropertyDatamodelField;
import inform.agent.mtd.obj.DPropertyEnum;
import inform.agent.mtd.obj.DPropertyFields;
import inform.agent.mtd.obj.DPropertyInt;
import inform.agent.mtd.obj.DPropertyMetadataNode;
import inform.agent.mtd.obj.DPropertyNodeRef;
import inform.agent.mtd.obj.DPropertyPeriodicBind;
import inform.agent.mtd.obj.DPropertySecurity;
import inform.agent.mtd.obj.DPropertyString;
import inform.agent.mtd.obj.DReturnedFields;
import java.io.IOException;

public class DDatasource
extends DDatamodelNode {
    protected final DPropertyMetadataNode tableNode = new DPropertyMetadataNode(this, "tableNode", 0);
    protected final DPropertyNodeRef searchNode = new DPropertyNodeRef(this, "searchNode", 2);
    protected int searchNodeType = 19;
    protected final DParametersMap parameters = new DParametersMap(this);
    protected final DDatasourceSorting sorting = new DDatasourceSorting(this, "sorting");
    protected final DPropertyBool handSort = new DPropertyBool(this, "handSort", 2);
    protected final DPropertyInt link = new DPropertyInt(this, "link", 32770);
    protected final DPropertyEnum subType = new DPropertyEnum(this, "subType", 2, DATAMODEL_TABLE_SUB_TYPE_NAMES);
    protected final DDatasourceLoadOptions loadOptions = new DDatasourceLoadOptions(this, "loadOptions");
    protected final DPropertyEnum relationType = new DPropertyEnum(this, "relationType", 32770, DATAMODEL_RELATION_TYPE_NAMES);
    protected final DReturnedFields returnedFields = new DReturnedFields((DProperty)this, "returnedFields", this);
    protected final DPropertySecurity security = new DPropertySecurity(this, "security");
    protected final DPropertyPeriodicBind periodicBind = new DPropertyPeriodicBind(this, "periodicBind");
    protected final DPropertyString checkReferencesMessage = new DPropertyString(this, "checkReferencesMessage", 0x200002);
    protected final DPropertyString deleteMessage = new DPropertyString(this, "deleteMessage", 0x200002);
    protected final DPropertyBool keepOperationHistory = new DPropertyBool(this, "keepOperationHistory", 4098);
    protected final DPropertyEnum nullSortType = new DPropertyEnum(this, "nullSortType", 32770, DATAMODEL_NULL_SORT_KIND_NAMES);
    protected final DPropertyString onBeforeScroll = new DPropertyString(this, "onBeforeScroll", 0x200002);
    protected final DPropertyString onAfterScroll = new DPropertyString(this, "onAfterScroll", 0x200002);
    protected final DPropertyString onBeforeAppend = new DPropertyString(this, "onBeforeAppend", 0x200002);
    protected final DPropertyString onAfterAppend = new DPropertyString(this, "onAfterAppend", 0x200002);
    protected final DPropertyString onBeforeChange = new DPropertyString(this, "onBeforeChange", 0x200002);
    protected final DPropertyString onAfterChange = new DPropertyString(this, "onAfterChange", 0x200002);
    protected final DPropertyString onBeforeDelete = new DPropertyString(this, "onBeforeDelete", 0x200002);
    protected final DPropertyString onAfterDelete = new DPropertyString(this, "onAfterDelete", 0x200002);
    protected final DPropertyString onFillData = new DPropertyString(this, "onFillData", 0x200002);
    protected final DPropertyString onScrolled = new DPropertyString(this, "onScrolled", 0x200002);
    protected final DPropertyString onCheckConstraints = new DPropertyString(this, "onCheckConstraints", 0x200002);
    protected final DPropertyString onApplyFilter = new DPropertyString(this, "onApplyFilter", 0x200002);
    protected final DPropertyString onGetRecordDescription = new DPropertyString(this, "onGetRecordDescription", 0x200002);
    protected final DPropertyFields redefinedFields = new DPropertyFields(this, "redefinedFields");

    public DDatasource(DProperty object, int nodeType, DDatamodelNode parent) {
        this(object, nodeType, parent, "MtdForm.datasource");
    }

    public DDatasource(DProperty object, int nodeType, DDatamodelNode parent, String dsl) {
        super(object, null, 32, parent, dsl);
        this.nodeType.value = nodeType;
    }

    @Override
    public boolean isTextNameStorable() {
        return !this.scriptName.isEmpty();
    }

    @Override
    public StringBuilder storeTextName(StringBuilder out) {
        if (this.scriptName.isEmpty()) {
            return super.storeTextName(out);
        }
        return out.append(this.scriptName.value);
    }

    @Override
    protected void loadTag(TaggedReader in) throws IOException {
        switch (in.getCurrentTag()) {
            case 151: {
                this.tableNode.value = in.getDouble();
                break;
            }
            case 21: {
                this.link.loadTaggedContent(in);
                break;
            }
            case 28: {
                this.handSort.loadTaggedContent(in);
                break;
            }
            case 22: {
                DDatasourceSortField sortField = new DDatasourceSortField(this);
                this.sorting.properties.add(sortField);
                sortField.fieldId.loadTaggedContent(in);
                break;
            }
            case 23: {
                DDatasourceSortField sortField = this.sorting.lastField();
                if (sortField == null) break;
                sortField.datasource.loadTaggedContent(in);
                break;
            }
            case 27: {
                DDatasourceSortField sortField = this.sorting.lastField();
                if (sortField == null) break;
                sortField.direction.loadTaggedContent(in);
                break;
            }
            case 25: {
                this.searchNode.loadTaggedContent(in);
                break;
            }
            case 26: {
                this.parameters.loadTaggedContent(in.getSubStreamReader());
                break;
            }
            case 48: {
                if (!this.searchNode.isEmpty()) break;
                this.parameters.loadTaggedContent(in.getSubStreamReader());
                break;
            }
            case 6: {
                this.loadExtra(in.getSubStreamReader());
                break;
            }
            case 57: {
                this.loadOptions.dataChunkSize.loadTaggedContent(in);
                break;
            }
            case 31: {
                this.loadOptions.fetchLimit.loadTaggedContent(in);
                break;
            }
            case 51: {
                this.loadOptions.isPageFetch.loadTaggedContent(in);
                break;
            }
            case 56: {
                this.loadOptions.isGradualLoading.loadTaggedContent(in);
                break;
            }
            case 58: {
                this.loadOptions.isAsyncLoading.loadTaggedContent(in);
                break;
            }
            case 30: {
                break;
            }
            case 43: {
                this.searchNodeType = in.getInt();
                break;
            }
            case 40: {
                this.loadOptions.recordCache.value = 2;
                break;
            }
            case 44: {
                this.loadOptions.recordCache.loadTaggedContent(in);
                break;
            }
            case 54: {
                this.loadOptions.cursorCache.loadTaggedContent(in);
                break;
            }
            case 45: {
                this.loadOptions.blobReceiving.loadTaggedContent(in);
                break;
            }
            case 46: {
                this.loadOptions.geometryFormat.loadTaggedContent(in);
                break;
            }
            case 32: {
                this.subType.value = 1;
                break;
            }
            case 33: {
                this.loadOptions.fetchKind.loadTaggedContent(in);
                break;
            }
            case 36: {
                this.relationType.loadTaggedContent(in);
                break;
            }
            case 38: {
                this.loadOptions.fieldMatch.loadTaggedContent(in.getSubStreamReader());
                break;
            }
            case 42: {
                this.returnedFields.loadTaggedContent(in.getSubStreamReader());
                break;
            }
            case 41: {
                this.periodicBind.loadTaggedContent(in.getSubStreamReader());
                break;
            }
            case 47: {
                this.checkReferencesMessage.loadTaggedContent(in);
                break;
            }
            case 53: {
                this.loadOptions.prefetchOptions.loadTaggedContent(in.getStreamReader());
                break;
            }
            case 55: {
                this.loadOptions.virtualDatasourceRefreshType.loadTaggedContent(in);
                break;
            }
            default: {
                super.loadTag(in);
            }
        }
    }

    protected void loadExtraTag(TaggedReader in) throws IOException {
        switch (in.getCurrentTag()) {
            case 1: {
                if (this.subType.value == 2) break;
                this.onBeforeScroll.loadTaggedContent(in);
                break;
            }
            case 2: {
                if (this.subType.value == 2) break;
                this.onAfterScroll.loadTaggedContent(in);
                break;
            }
            case 3: {
                if (this.subType.value == 2) break;
                this.onBeforeAppend.loadTaggedContent(in);
                break;
            }
            case 4: {
                if (this.subType.value == 2) break;
                this.onAfterAppend.loadTaggedContent(in);
                break;
            }
            case 5: {
                if (this.subType.value == 2) break;
                this.onBeforeChange.loadTaggedContent(in);
                break;
            }
            case 6: {
                if (this.subType.value == 2) break;
                this.onAfterChange.loadTaggedContent(in);
                break;
            }
            case 7: {
                if (this.subType.value == 2) break;
                this.onBeforeDelete.loadTaggedContent(in);
                break;
            }
            case 8: {
                if (this.subType.value == 2) break;
                this.onAfterDelete.loadTaggedContent(in);
                break;
            }
            case 9: {
                if (this.subType.value == 2) break;
                this.onFillData.loadTaggedContent(in);
                break;
            }
            case 10: {
                if (this.subType.value == 2) break;
                this.onScrolled.loadTaggedContent(in);
                break;
            }
            case 12: {
                this.onCheckConstraints.loadTaggedContent(in);
                break;
            }
            case 14: {
                this.onApplyFilter.loadTaggedContent(in);
                break;
            }
            case 17: {
                this.onGetRecordDescription.loadTaggedContent(in);
                break;
            }
            case 47: {
                this.loadOptions.refreshOnServerModification.loadTaggedContent(in);
                this.loadOptions.refreshOnExternalChanges.value = this.loadOptions.refreshOnServerModification.value;
                break;
            }
            case 18: {
                this.loadOptions.refreshOnExternalChanges.loadTaggedContent(in);
                break;
            }
            case 51: {
                this.loadOptions.dropBlobCacheOnSave.loadTaggedContent(in);
                break;
            }
            case 53: {
                this.loadOptions.doCompressData.loadTaggedContent(in);
                break;
            }
            case 50: {
                this.loadOptions.refreshPeriod.loadTaggedContent(in);
                break;
            }
            case 30: {
                DPropertyDatamodelField binding = new DPropertyDatamodelField(this);
                binding.fieldId.value = in.getInt();
                binding.loadTaggedContent(in);
                this.redefinedFields.properties.add(binding);
                break;
            }
            case 11: {
                this.security.loadTaggedContent(in);
                break;
            }
            case 13: {
                this.deleteMessage.loadTaggedContent(in);
                break;
            }
            case 15: {
                this.keepOperationHistory.loadTaggedContent(in);
                break;
            }
            case 16: {
                this.nullSortType.loadTaggedContent(in);
                break;
            }
            case 19: {
                this.loadOptions.datasourceExecutionType.loadTaggedContent(in);
                break;
            }
            default: {
                this.addUnhandled().loadTaggedContent(in);
            }
        }
    }

    protected void loadExtra(TaggedReader in) throws IOException {
        while (in.next()) {
            this.loadExtraTag(in);
        }
    }

    @Override
    public int storeTextContent(int textOptions, StringBuilder out, int level, boolean needComma) {
        return super.storeTextContent(textOptions, out, level, needComma);
    }

    @Override
    protected void internalStoreTaggedContent(TaggedWriter out) throws IOException {
        TableDescriptor table;
        super.internalStoreTaggedContent(out);
        this.tableNode.storeTaggedContentAs(151, out);
        this.link.storeTaggedContentAs(21, out);
        this.handSort.storeTaggedContentAs(28, out);
        for (DProperty p : this.sorting.properties) {
            if (!(p instanceof DDatasourceSortField)) continue;
            DDatasourceSortField f = (DDatasourceSortField)p;
            f.fieldId.storeTaggedContentAs(22, out);
            f.datasource.storeTaggedContentAs(23, out);
            f.direction.storeTaggedContentAs(27, out);
        }
        if (this.searchNode.value != 0.0) {
            Node node = MtdEngine.getNode(this.searchNode.value);
            if (node != null) {
                this.searchNodeType = node.getType();
            }
            out.putInt32(43, this.searchNodeType);
            this.searchNode.storeTaggedContentAs(25, out);
            if (!this.parameters.properties.isEmpty()) {
                this.parameters.storeTaggedContentAsNonEmptyStream(26, out);
            }
        } else if (!this.parameters.properties.isEmpty()) {
            this.parameters.storeTaggedContentAsNonEmptyStream(26, out);
        }
        this.relationType.storeTaggedContentAs(36, out);
        this.loadOptions.dataChunkSize.storeTaggedContentAs(57, out);
        if (this.subType.value == 1) {
            out.putEmpty(32);
        }
        this.loadOptions.fetchLimit.storeTaggedContentAs(31, out);
        this.loadOptions.isPageFetch.storeTaggedContentAs(51, out);
        this.loadOptions.isGradualLoading.storeTaggedContentAs(56, out);
        this.loadOptions.isAsyncLoading.storeTaggedContentAs(58, out);
        out.putEmpty(30);
        if (this.loadOptions.recordCache.value == 2) {
            out.putEmpty(40);
        }
        this.loadOptions.recordCache.storeTaggedContentAs(44, out);
        this.loadOptions.cursorCache.storeTaggedContentAs(54, out);
        this.loadOptions.blobReceiving.storeTaggedContentAs(45, out);
        this.loadOptions.geometryFormat.storeTaggedContentAs(46, out);
        ByteArrayOutputStream rawData = new ByteArrayOutputStream();
        TaggedWriter stream = new TaggedWriter(rawData);
        this.loadOptions.prefetchOptions.storeTaggedContent(stream);
        stream.flush();
        if (rawData.size() != 0) {
            out.putRaw(53, rawData);
        }
        this.loadOptions.fetchKind.storeTaggedContentAs(33, out);
        if (this.loadOptions.fetchKind.value == 1) {
            this.loadOptions.fieldMatch.storeTaggedContentAsNonEmptyStream(38, out);
        }
        if (!this.returnedFields.properties.isEmpty()) {
            this.returnedFields.storeTaggedContentAsNonEmptyStream(42, out);
        }
        if (this.tableNode.value != 0.0 && this.searchNode.value == 0.0 && (table = TableDescriptor.getIfExists(this.tableNode.value)) != null && table.isHasPeriodicStorage()) {
            this.periodicBind.storeTaggedContentAsNonEmptyStream(41, out);
        }
        this.checkReferencesMessage.storeTaggedContentAs(47, out);
        if (this.loadOptions.virtualDatasourceRefreshType.value == 1) {
            out.putEmpty(55);
        }
        rawData.reset();
        stream.reset(rawData);
        this.storeExtra(stream);
        stream.flush();
        if (rawData.size() != 0) {
            out.putEmpty(6);
            out.putRaw(202, rawData);
        }
    }

    protected void storeExtra(TaggedWriter out) throws IOException {
        this.onBeforeScroll.storeTaggedContentAs(1, out);
        this.onAfterScroll.storeTaggedContentAs(2, out);
        this.onBeforeAppend.storeTaggedContentAs(3, out);
        this.onAfterAppend.storeTaggedContentAs(4, out);
        this.onBeforeChange.storeTaggedContentAs(5, out);
        this.onAfterChange.storeTaggedContentAs(6, out);
        this.onBeforeDelete.storeTaggedContentAs(7, out);
        this.onAfterDelete.storeTaggedContentAs(8, out);
        this.onFillData.storeTaggedContentAs(9, out);
        this.onScrolled.storeTaggedContentAs(10, out);
        this.onCheckConstraints.storeTaggedContentAs(12, out);
        this.onApplyFilter.storeTaggedContentAs(14, out);
        this.onGetRecordDescription.storeTaggedContentAs(17, out);
        this.security.storeTaggedContentAs(11, out);
        this.loadOptions.refreshOnServerModification.storeTaggedContentAs(47, out);
        if (!this.loadOptions.refreshOnServerModification.value && this.loadOptions.refreshOnExternalChanges.value) {
            out.putEmpty(18);
        }
        this.loadOptions.dropBlobCacheOnSave.storeTaggedContentAs(51, out);
        this.loadOptions.doCompressData.storeTaggedContentAs(53, out);
        this.loadOptions.refreshPeriod.storeTaggedContentAs(50, out);
        this.deleteMessage.storeTaggedContentAs(13, out);
        this.keepOperationHistory.storeTaggedContentAs(15, out);
        this.nullSortType.storeTaggedContentAs(16, out);
        this.loadOptions.datasourceExecutionType.storeTaggedContentAs(19, out);
        for (DProperty p : this.redefinedFields.properties) {
            p.storeTaggedContent(out);
        }
    }
}

