/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DDatasourceSyncList;
import inform.agent.mtd.obj.DObject;
import inform.agent.mtd.obj.DParameterSyncList;
import inform.agent.mtd.obj.DProperty;
import java.io.IOException;

public class DDatasourceSynchronizer
extends DObject {
    protected final DParameterSyncList paramsSync = new DParameterSyncList(this, "paramsSync");
    protected final DDatasourceSyncList datasourceSync = new DDatasourceSyncList(this, "datasourceSync");

    public DDatasourceSynchronizer(DProperty object, String name) {
        super(object, name, 2);
    }

    @Override
    public boolean isDefault() {
        return this.checkPropOptions(2) && this.paramsSync.isEmpty() && this.datasourceSync.isEmpty();
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        int tag;
        while ((tag = in.getNextTag()) != 0) {
            switch (tag) {
                case 1: {
                    this.datasourceSync.loadTaggedContent(in.getSubStreamReader());
                    break;
                }
                case 2: {
                    this.paramsSync.loadTaggedContent(in.getSubStreamReader());
                }
            }
        }
    }

    @Override
    public void storeTaggedContentAs(int tag, TaggedWriter out) throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter stream = new TaggedWriter(data);
        this.datasourceSync.storeTaggedContentAsNonEmptyStream(1, stream);
        this.paramsSync.storeTaggedContentAsNonEmptyStream(2, stream);
        stream.flush();
        if (data.size() != 0) {
            out.putEmpty(tag);
            out.putRaw(202, data);
        }
    }

    public int addDatasourceSync(int kind) {
        return this.datasourceSync.addItem(kind);
    }

    public void setSourceDatasourceId(int index, int uid) {
        this.datasourceSync.setDatasourceId(index, uid);
    }

    public void setTagretDatasourceName(int index, String name) {
        this.datasourceSync.setDatasourceName(index, name);
    }

    public void setSourceParamId(int index, int paramId) {
        this.paramsSync.setSourceParamId(index, paramId);
    }

    public int addParamSync(String name) {
        return this.paramsSync.addItem(name);
    }
}

