/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DFieldArray;
import inform.agent.mtd.obj.DPropertyBool;
import inform.agent.mtd.obj.DPropertyEnum;
import inform.agent.mtd.obj.DPropertyString;
import inform.agent.mtd.obj.NonVisualComponent;
import java.io.IOException;

public class DDbfReader
extends NonVisualComponent {
    protected final DPropertyString fileName = new DPropertyString(this, "fileName", 524288, "");
    protected final DPropertyString dbfDescription = new DPropertyString(this, "dbfDescription", 524290, "");
    protected final DPropertyBool dbfWritable = new DPropertyBool(this, "writable", 4096, false);
    protected final DPropertyEnum codePage = new DPropertyEnum(this, "codePage", 32768, DBF_READER_CODE_PAGES);
    protected final DFieldArray fieldsArr = new DFieldArray(this, "fields");

    public DDbfReader(int id, int options) {
        super(401, id, options);
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        int tag;
        block7: while ((tag = in.getNextTag()) != 0) {
            switch (tag) {
                case 40: {
                    this.fileName.loadTaggedContent(in);
                    continue block7;
                }
                case 22: {
                    this.dbfDescription.loadTaggedContent(in);
                    continue block7;
                }
                case 42: {
                    this.dbfWritable.value = true;
                    continue block7;
                }
                case 41: {
                    this.codePage.loadTaggedContent(in);
                    continue block7;
                }
                case 43: {
                    TaggedReader read = new TaggedReader(in.getStream());
                    while (read.next()) {
                        if (read.getCurrentTag() != 43) continue;
                        this.fieldsArr.loadTaggedContent(read);
                    }
                    continue block7;
                }
            }
            super.loadTag(in);
        }
    }

    @Override
    public void storeTaggedContent(int[] header, TaggedWriter out) throws IOException {
        this.getHeader(header);
        if (!this.dbfDescription.isEmpty()) {
            this.dbfDescription.storeTaggedContentAs(22, out);
        }
        if (!this.fileName.isEmpty()) {
            out.putAnsi(40, this.fileName.value);
        }
        if (this.dbfWritable.value) {
            out.putEmpty(42);
        }
        this.codePage.storeTaggedContentAs(41, out);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter stream = new TaggedWriter(data);
        this.fieldsArr.storeTaggedContent(stream);
        stream.flush();
        out.putEmpty(43);
        out.putRaw(43, data);
    }
}

