/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.taggedio.LittleEndianDataOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DArray;
import inform.agent.mtd.obj.DFieldRef;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DProperty;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DFieldArray
extends DArray {
    public DFieldArray(DProperty object, String name) {
        super(object, name, 2);
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        DFieldRef item = new DFieldRef(this);
        item.loadTaggedContent(in);
        this.properties.add(item);
    }

    @Override
    public DProperty loadScriptArrayItem(Object obj) {
        DFieldRef item = new DFieldRef(this);
        item.loadScriptValue(obj);
        return item;
    }

    @Override
    protected void doAssign(DItem source) {
        if (DFieldArray.checkAssignType(source, this.getClass())) {
            for (DProperty sourceProperty : ((DFieldArray)source).properties) {
                if (!DFieldArray.checkAssignType(sourceProperty, DFieldRef.class)) continue;
                DFieldRef sourceFiled = (DFieldRef)sourceProperty;
                DFieldRef filed = new DFieldRef(this);
                filed.assign(sourceFiled);
                this.properties.add(filed);
            }
        }
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        LittleEndianDataOutputStream data = new LittleEndianDataOutputStream(baos);
        DFieldRef.Kind kind = DFieldRef.Kind.Default;
        for (DProperty p : this.properties) {
            if (!(p instanceof DFieldRef)) continue;
            DFieldRef item = (DFieldRef)p;
            kind = item.kind;
            switch (item.kind) {
                case Default: {
                    out.putInt32(163, item.fieldId.value);
                    break;
                }
                case Dbf: {
                    item.dbfField.storeTaggedContent(new TaggedWriter(data));
                    data.flush();
                    if (baos.size() <= 0) break;
                    out.putRaw(43, baos.toByteArray());
                    baos.reset();
                    break;
                }
                case Dl: {
                    if (item.dlField.isDefault()) break;
                    data.writeInt(item.dlField.fieldId.value);
                }
            }
        }
        if (baos.size() > 0 && kind != DFieldRef.Kind.Dbf) {
            out.putEmpty(41);
            out.putRaw(202, baos.toByteArray());
        }
    }
}

