/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DObject;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyEnum;
import inform.agent.mtd.obj.DPropertyInt;
import inform.agent.mtd.obj.DPropertyString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.mozilla.javascript.ScriptableObject;

public class DFieldRef
extends DObject {
    protected Kind kind;
    protected final DPropertyInt fieldId = new DPropertyInt(this, "fieldId", 32770, 0);
    DFieldDbf dbfField = new DFieldDbf(this, "dbfField");
    DFieldDl dlField = new DFieldDl(this, "dlField");

    public DFieldRef(DProperty object) {
        super(object, null, 32);
        this.kind = Kind.Default;
    }

    public DFieldRef(DProperty object, Kind kind) {
        super(object, null, 32);
        this.kind = kind;
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        switch (in.getCurrentTag()) {
            case 163: {
                this.fieldId.value = in.getInt(163);
                this.kind = Kind.Default;
                break;
            }
            case 41: {
                this.kind = Kind.Dl;
                break;
            }
            case 43: {
                this.dbfField.loadTaggedContent(new TaggedReader(in.getRaw()));
                this.kind = Kind.Dbf;
                break;
            }
            default: {
                this.addUnhandled().loadTaggedContent(in);
            }
        }
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        out.putInt32(163, this.fieldId.value);
    }

    public void setValue(int val) {
        this.fieldId.value = val;
    }

    @Override
    public void loadScriptContent(ScriptableObject obj) {
        super.loadScriptContent(obj);
    }

    @Override
    public boolean isDefault() {
        for (DProperty p : this.properties) {
            if (p.isDefault() || !p.isStorable()) continue;
            return false;
        }
        return true;
    }

    public static class DFieldDl
    extends DObject {
        protected final DPropertyInt fieldId = new DPropertyInt(this, "fieldId", 32770);

        public DFieldDl(DProperty object, String name) {
            super(object, name);
        }

        @Override
        public void loadTaggedContent(TaggedReader in) throws IOException {
            in.skip();
            byte[] data = in.getSubStreamData();
            for (int i = 0; i < data.length; i += 4) {
                ByteBuffer buffer = ByteBuffer.wrap(data, i, 4);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                this.fieldId.value = buffer.getInt();
            }
        }

        @Override
        public void loadScriptContent(ScriptableObject obj) {
            super.loadScriptContent(obj);
        }

        @Override
        public boolean isDefault() {
            for (DProperty p : this.properties) {
                if (p.isDefault() || !p.isStorable()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isStorable() {
            return !this.isDefault();
        }
    }

    public static class DFieldDbf
    extends DObject {
        protected final DPropertyString fieldName = new DPropertyString(this, "fieldName", 524290);
        protected final DPropertyEnum fieldType = new DPropertyEnum((DProperty)this, "fieldType", 32770, FORM_CONTROL_DATA_TYPES_NUM, FORM_CONTROL_DATA_TYPES);
        protected final DPropertyInt fieldSize = new DPropertyInt(this, "fieldSize", 32770);
        protected final DPropertyInt fieldDecimals = new DPropertyInt(this, "fieldDecimals", 32770);

        public DFieldDbf(DProperty object, String name) {
            super(object, name);
        }

        @Override
        public void loadTaggedContent(TaggedReader in) throws IOException {
            this.fieldName.value = in.getAnsi(1);
            this.fieldType.value = in.getInt(2);
            this.fieldSize.value = in.getInt(3);
            this.fieldDecimals.value = in.getInt(4);
        }

        @Override
        public void storeTaggedContent(TaggedWriter out) throws IOException {
            if (this.isDefault()) {
                return;
            }
            this.fieldName.storeTaggedContentAs(1, out);
            this.fieldType.storeTaggedContentAs(2, out);
            this.fieldSize.storeTaggedContentAs(3, out);
            this.fieldDecimals.storeTaggedContentAs(4, out);
        }

        @Override
        public void loadScriptContent(ScriptableObject obj) {
            super.loadScriptContent(obj);
        }

        @Override
        public boolean isDefault() {
            for (DProperty p : this.properties) {
                if (p.isDefault() || !p.isStorable()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isStorable() {
            return !this.isDefault();
        }
    }

    public static enum Kind {
        Default,
        Dl,
        Dbf;

    }
}

