/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DComponent;
import inform.agent.mtd.obj.DComponentContainer;
import inform.agent.mtd.obj.DComponents;
import inform.agent.mtd.obj.DControl;
import inform.agent.mtd.obj.DDatamodel;
import inform.agent.mtd.obj.DDatasource;
import inform.agent.mtd.obj.DFormControl;
import inform.agent.mtd.obj.DFormExtButtons;
import inform.agent.mtd.obj.DFormShortcut;
import inform.agent.mtd.obj.DFormShortcuts;
import inform.agent.mtd.obj.DLayout;
import inform.agent.mtd.obj.DLayoutControl;
import inform.agent.mtd.obj.DParameter;
import inform.agent.mtd.obj.DParameters;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyBool;
import inform.agent.mtd.obj.DPropertyControl;
import inform.agent.mtd.obj.DPropertyDatasource;
import inform.agent.mtd.obj.DPropertyEnum;
import inform.agent.mtd.obj.DPropertyEnumSet;
import inform.agent.mtd.obj.DPropertyInt;
import inform.agent.mtd.obj.DPropertyNodeRef;
import inform.agent.mtd.obj.DPropertyString;
import inform.agent.mtd.obj.NonVisualComponent;
import java.io.IOException;
import java.util.ArrayList;
import org.mozilla.javascript.NativeArray;

public class DForm
extends DControl
implements DComponentContainer,
DLayoutControl {
    private int legacyX = 0;
    private int legacyY = 0;
    private final DDatamodel datamodel = new DDatamodel(this);
    private final DComponents components = new DComponents((DProperty)this, 4);
    private final DPropertyEnum windowKind = new DPropertyEnum(this, "windowKind", 131586, FORM_WINDOW_KIND_NAMES);
    private final DPropertyEnum formPosition = new DPropertyEnum((DProperty)this, "position", 131584, 3, FORM_POSITION_NAMES);
    private final DPropertyInt pixelPerInch = new DPropertyInt(this, "dpi", 33280, 96);
    private final DPropertyInt deltaLeft = new DPropertyInt(this, "deltaLeft", 32770, 0);
    private final DPropertyInt deltaTop = new DPropertyInt(this, "deltaTop", 32898, 0);
    private final DPropertyString caption = new DPropertyString(this, "caption", 0x200002);
    private final DPropertyString configuration = new DPropertyString(this, "configuration", 0x200002);
    private final DLayout layout = new DLayout(this, "layout");
    private final DPropertyEnum mdiTabOrientation = new DPropertyEnum((DProperty)this, "mdiTabOrientation", 32770, 0, MDI_TAB_ORIENTATION_NAMES);
    private final DPropertyBool autoSave = new DPropertyBool(this, "autoSave", 8194, true);
    private final DPropertyBool initialEditMode = new DPropertyBool(this, "initialEditMode", 4098, false);
    private final DPropertyNodeRef backgroundNodeId = new DPropertyNodeRef(this, "backgroundNode", 2, 0.0);
    private final DPropertyControl activeControl = new DPropertyControl(this, "activeControl");
    private final DPropertyEnumSet standardButtons = new DPropertyEnumSet((DProperty)this, "standardButtons", 33280, 7, FORM_STANDARD_BUTTON_NAMES);
    private final DPropertyControl formFilterControl = new DPropertyControl(this, "formFilterControl");
    private final DPropertyNodeRef helpNodeId = new DPropertyNodeRef(this, "helpNode", 2, 0.0);
    private final DPropertyBool statusbarVisible = new DPropertyBool(this, "statusbarVisible", 8194, true);
    private final DPropertyBool mainMenuVisible = new DPropertyBool(this, "mainMenuVisible", 8194, true);
    private final DPropertyBool mainToolbarVisible = new DPropertyBool(this, "mainToolbarVisible", 8194, true);
    private final DPropertyBool minimizeToTray = new DPropertyBool(this, "minimizeToTray", 4098, false);
    private final DPropertyBool jitEnabled = new DPropertyBool(this, "jitEnabled", 8194, true);
    private final DPropertyNodeRef formStyleNodeId = new DPropertyNodeRef(this, "formStyleNodeId", 2, 0.0);
    private final DPropertyInt imageId = new DPropertyInt(this, "formIconId", 32770, 0);
    private final DPropertyBool stayOnTop = new DPropertyBool(this, "stayOnTop", 4098, false);
    private final DFormExtButtons extButtons = new DFormExtButtons(this, "extButtons");
    private final DPropertyDatasource toolbarDatasource = new DPropertyDatasource(this, "toolbarDatasource");
    private final DFormShortcuts shortcuts = new DFormShortcuts(this, "shortcuts");
    private final DPropertyString onHelp = new DPropertyString(this, "onHelp", 0x200002);
    private final DPropertyString onInitialize = new DPropertyString(this, "onInitialize", 0x200002);
    private final DPropertyString onFinalize = new DPropertyString(this, "onFinalize", 0x200002);
    private final DPropertyString onActivate = new DPropertyString(this, "onActivate", 0x200002);
    private final DPropertyString onBeforeInputParams = new DPropertyString(this, "onBeforeInputParams", 0x200002);
    private final DPropertyString onAfterInputParams = new DPropertyString(this, "onAfterInputParams", 0x200002);
    private final DPropertyString onBeforeEditModeChanged = new DPropertyString(this, "onBeforeEditModeChanged", 0x200002);
    private final DPropertyString onAfterEditModeChanged = new DPropertyString(this, "onAfterEditModeChanged", 0x200002);
    private final DPropertyString onCloseQuery = new DPropertyString(this, "onCloseQuery", 0x200002);
    private final DPropertyString onUpdate = new DPropertyString(this, "onUpdate", 0x200002);
    private final DPropertyString onBeforeCommit = new DPropertyString(this, "onBeforeCommit", 0x200002);
    private final DPropertyString onAfterCommit = new DPropertyString(this, "onAfterCommit", 0x200002);
    private final DPropertyString onBeforeRollback = new DPropertyString(this, "onBeforeRollback", 0x200002);
    private final DPropertyString onRollback = new DPropertyString(this, "onRollback", 0x200002);
    private final DPropertyString script = new DPropertyString(this, "script", 0x200002);

    public DForm() {
        this.id.setStorable(false);
        this.color.setDefaultValue(-16777211);
        this.width.setDefaultValue(320);
        this.height.setDefaultValue(240);
        this.parentFont.setStorable(false);
        this.parentColor.setStorable(false);
        this.x.setScriptable(false);
        this.y.setScriptable(false);
        this.datamodel.setStorable(false);
        this.components.setStorable(false);
        this.script.setScriptable(false);
    }

    @Override
    public int getLayoutType() {
        return this.layout.layoutType.value;
    }

    @Override
    public ArrayList<DComponent> getChildren() {
        ArrayList<DComponent> components = new ArrayList<DComponent>();
        for (DProperty p : this.components.properties) {
            if (!p.isStorable() || p.checkPropOptions(2) && p.isDefault() || !(p instanceof DComponent) || ((DComponent)p).isControl()) continue;
            components.add((DComponent)p);
        }
        components.addAll(this.children);
        return components;
    }

    protected void loadProps(TaggedReader in) throws IOException {
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 41: {
                    in.checkCurrentTag(41, 8);
                    int[] ints = LittleEndian.toIntArray(in.getRaw());
                    this.width.setValue(ints[0]);
                    this.height.setValue(ints[1]);
                    break;
                }
                case 84: {
                    in.checkCurrentTag(84, 8);
                    int[] ints = LittleEndian.toIntArray(in.getRaw());
                    this.deltaLeft.setValue(ints[0]);
                    this.deltaTop.setValue(ints[1]);
                    break;
                }
                case 40: {
                    in.checkCurrentTag(40, 8);
                    int[] ints = LittleEndian.toIntArray(in.getRaw());
                    this.width.setValue(ints[0]);
                    this.height.setValue(ints[1]);
                    break;
                }
                case 11: {
                    this.color.setValue(in.getInt());
                    break;
                }
                case 10: {
                    this.constraints.loadTaggedContent(in);
                    break;
                }
                case 15: {
                    this.caption.setValue(in.getString());
                    break;
                }
                case 49: {
                    this.configuration.setValue(in.getString());
                    break;
                }
                case 6: {
                    this.font.loadTaggedContent(in);
                    this.parentFont.setValue(false);
                    break;
                }
                case 43: {
                    this.formPosition.loadTaggedContent(in);
                    break;
                }
                case 42: {
                    this.windowKind.loadTaggedContent(in);
                    break;
                }
                case 80: {
                    this.mdiTabOrientation.loadTaggedContent(in);
                    break;
                }
                case 44: {
                    this.legacyX = in.getInt();
                    break;
                }
                case 45: {
                    this.legacyY = in.getInt();
                    break;
                }
                case 47: {
                    this.formPosition.setValue(1);
                    break;
                }
                case 48: {
                    this.autoSave.loadTaggedContent(in);
                    break;
                }
                case 56: {
                    this.initialEditMode.loadTaggedContent(in);
                    break;
                }
                case 38: {
                    this.onHelp.loadTaggedContent(in);
                    break;
                }
                case 51: {
                    this.onInitialize.loadTaggedContent(in);
                    break;
                }
                case 68: {
                    this.onFinalize.loadTaggedContent(in);
                    break;
                }
                case 93: {
                    this.onActivate.loadTaggedContent(in);
                    break;
                }
                case 52: {
                    this.backgroundNodeId.loadTaggedContent(in);
                    break;
                }
                case 55: {
                    this.activeControl.loadTaggedContent(in);
                    break;
                }
                case 53: {
                    this.onBeforeInputParams.loadTaggedContent(in);
                    break;
                }
                case 54: {
                    this.onAfterInputParams.loadTaggedContent(in);
                    break;
                }
                case 61: {
                    this.onAfterEditModeChanged.loadTaggedContent(in);
                    break;
                }
                case 82: {
                    this.onBeforeEditModeChanged.loadTaggedContent(in);
                    break;
                }
                case 64: {
                    this.onCloseQuery.loadTaggedContent(in);
                    break;
                }
                case 65: {
                    this.onUpdate.loadTaggedContent(in);
                    break;
                }
                case 76: {
                    this.onBeforeCommit.loadTaggedContent(in);
                    break;
                }
                case 66: {
                    this.onAfterCommit.loadTaggedContent(in);
                    break;
                }
                case 67: {
                    this.onRollback.loadTaggedContent(in);
                    break;
                }
                case 88: {
                    this.onBeforeRollback.loadTaggedContent(in);
                    break;
                }
                case 50: {
                    this.standardButtons.loadTaggedContent(in);
                    break;
                }
                case 81: {
                    this.formFilterControl.loadTaggedContent(in);
                    break;
                }
                case 59: {
                    this.toolbarDatasource.loadTaggedContent(in);
                    break;
                }
                case 60: {
                    this.extButtons.loadTaggedContent(in.getSubStreamReader());
                    break;
                }
                case 75: {
                    this.imageId.loadTaggedContent(in);
                    break;
                }
                case 77: {
                    this.stayOnTop.loadTaggedContent(in);
                    break;
                }
                case 78: {
                    TaggedReader stream = in.getStreamReader();
                    DFormShortcut shortcut = null;
                    while (stream.next()) {
                        if (stream.getCurrentTag() == 24) {
                            shortcut = new DFormShortcut(this.shortcuts);
                            this.shortcuts.properties.add(shortcut);
                        }
                        if (shortcut == null) continue;
                        shortcut.loadTaggedContent(stream);
                    }
                    break;
                }
                case 79: {
                    this.helpNodeId.loadTaggedContent(in);
                    break;
                }
                case 83: {
                    this.statusbarVisible.loadTaggedContent(in);
                    break;
                }
                case 85: {
                    this.mainMenuVisible.loadTaggedContent(in);
                    break;
                }
                case 86: {
                    this.mainToolbarVisible.loadTaggedContent(in);
                    break;
                }
                case 87: {
                    this.minimizeToTray.loadTaggedContent(in);
                    break;
                }
                case 91: {
                    this.formStyleNodeId.loadTaggedContent(in);
                    break;
                }
                case 89: {
                    this.jitEnabled.loadTaggedContent(in);
                    break;
                }
                case 90: {
                    this.layout.loadLayoutType(in);
                    this.layout.loadTaggedContent(in.getStreamReader());
                }
            }
        }
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        block11: while (in.next()) {
            switch (in.getCurrentTag()) {
                case 150: {
                    continue block11;
                }
                case 154: {
                    this.accessRights.loadTaggedContent(in);
                    continue block11;
                }
                case 152: {
                    in.skip();
                    this.datamodel.loadTaggedContent(in.getStreamReader(202));
                    continue block11;
                }
                case 42: {
                    this.windowKind.loadTaggedContent(in);
                    continue block11;
                }
                case 4: {
                    in.skip();
                    this.loadProps(in.getStreamReader(202));
                    continue block11;
                }
                case 3: {
                    in.skip();
                    this.components.loadTaggedContent(in.getStreamReader(202), this, this);
                    continue block11;
                }
                case 23: {
                    this.script.loadTaggedContent(in);
                    continue block11;
                }
                case 17: {
                    if (this.script.isEmpty()) continue block11;
                    this.script.loadTaggedContent(in);
                    continue block11;
                }
                case 29: {
                    if (in.getCurrentTagSize() != 4) continue block11;
                    this.pixelPerInch.loadTaggedContent(in);
                    continue block11;
                }
            }
            this.addUnhandled().loadTaggedContent(in);
        }
        this.afterLoad();
    }

    public void createFromJavaScriptObjects(Object jsParameters, Object jsDatamodel, Object jsComponents, Object jsControls, Object jsFormProps, String clientScript) {
        Object item;
        long index;
        long count;
        NativeArray array;
        if (jsParameters instanceof DParameters) {
            this.datamodel.parameters.assign((DParameters)jsParameters);
        } else if (jsParameters instanceof NativeArray) {
            this.datamodel.parameters.loadScriptValue(jsParameters);
        }
        if (jsDatamodel instanceof DDatamodel) {
            this.datamodel.assign((DDatamodel)jsDatamodel);
        }
        int[] header = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        if (jsComponents instanceof NativeArray) {
            array = (NativeArray)jsComponents;
            count = array.getLength();
            for (index = 0L; index < count; ++index) {
                item = array.get(index);
                if (!DForm.checkAssignType(item, NonVisualComponent.class)) continue;
                NonVisualComponent sourceComponent = (NonVisualComponent)item;
                sourceComponent.getHeader(header);
                NonVisualComponent component = DComponents.createDesignComponent(header, this);
                component.assign(sourceComponent);
                this.components.registerProperty(component);
            }
        }
        if (jsControls instanceof NativeArray) {
            array = (NativeArray)jsControls;
            count = array.getLength();
            for (index = 0L; index < count; ++index) {
                item = array.get(index);
                if (!DForm.checkAssignType(item, DFormControl.class)) continue;
                DFormControl sourceControl = (DFormControl)item;
                sourceControl.getHeader(header);
                DFormControl control = DComponents.createDesignControl(header, this, this);
                control.assign(sourceControl);
                this.components.registerProperty(control);
            }
        }
        if (jsFormProps instanceof DForm) {
            this.assign((DForm)jsFormProps);
        }
        this.script.value = clientScript;
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        out.putEmpty(150);
        this.windowKind.storeTaggedContentAs(42, out);
        this.pixelPerInch.storeTaggedContentAs(29, out);
        this.accessRights.storeTaggedContentAs(154, out);
        this.datamodel.storeTaggedContentAsStream(152, out);
        this.script.storeTaggedContentAs(23, out);
        this.storeTaggedFormPropsAs(4, out);
        this.components.storeTaggedChildren(this, out);
    }

    protected void storeTaggedFormPropsAs(int tag, TaggedWriter out) throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter stream = new TaggedWriter(data);
        this.storeTaggedFormProps(stream);
        stream.flush();
        out.putEmpty(tag);
        out.putRaw(202, data);
    }

    protected void storeTaggedFormProps(TaggedWriter out) throws IOException {
        int offset = 0;
        byte[] raw = new byte[16];
        LittleEndian.setInteger(this.width.value, raw, offset);
        LittleEndian.setInteger(this.height.value, raw, offset += 4);
        out.putRaw(41, raw, 8);
        offset = 0;
        LittleEndian.setInteger(this.deltaLeft.value, raw, offset);
        LittleEndian.setInteger(this.deltaTop.value, raw, offset += 4);
        out.putRaw(84, raw, 8);
        this.constraints.storeTaggedContentAs(10, out);
        this.color.storeTaggedContentAs(11, out);
        this.font.storeTaggedContentAs(6, out);
        this.caption.storeTaggedContentAs(15, out);
        this.stayOnTop.storeTaggedContentAs(77, out);
        this.configuration.storeTaggedContentAs(49, out);
        this.formPosition.storeTaggedContentAs(43, out);
        this.windowKind.storeTaggedContentAs(42, out);
        this.mdiTabOrientation.storeTaggedContentAs(80, out);
        this.autoSave.storeTaggedContentAs(48, out);
        this.initialEditMode.storeTaggedContentAs(56, out);
        this.jitEnabled.storeTaggedContentAs(89, out);
        this.onInitialize.storeTaggedContentAs(51, out);
        this.onFinalize.storeTaggedContentAs(68, out);
        this.onBeforeInputParams.storeTaggedContentAs(53, out);
        this.onAfterInputParams.storeTaggedContentAs(54, out);
        this.onAfterEditModeChanged.storeTaggedContentAs(61, out);
        this.onBeforeEditModeChanged.storeTaggedContentAs(82, out);
        this.onCloseQuery.storeTaggedContentAs(64, out);
        this.onUpdate.storeTaggedContentAs(65, out);
        this.onBeforeCommit.storeTaggedContentAs(76, out);
        this.onAfterCommit.storeTaggedContentAs(66, out);
        this.onRollback.storeTaggedContentAs(67, out);
        this.onBeforeRollback.storeTaggedContentAs(88, out);
        this.onHelp.storeTaggedContentAs(38, out);
        this.onActivate.storeTaggedContentAs(93, out);
        if (!this.shortcuts.isEmpty()) {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            TaggedWriter stream = new TaggedWriter(data);
            for (DProperty p : this.shortcuts.properties) {
                p.storeTaggedContent(stream);
            }
            stream.flush();
            out.putRaw(78, data);
        }
        this.backgroundNodeId.storeTaggedContentAs(52, out);
        this.activeControl.storeTaggedContentAs(55, out);
        this.imageId.storeTaggedContentAs(75, out);
        this.helpNodeId.storeTaggedContentAs(79, out);
        this.statusbarVisible.storeTaggedContentAs(83, out);
        this.mainMenuVisible.storeTaggedContentAs(85, out);
        this.mainToolbarVisible.storeTaggedContentAs(86, out);
        this.minimizeToTray.storeTaggedContentAs(87, out);
        this.layout.storeTaggedContentAsNonEmptyStream(90, out);
        this.formStyleNodeId.storeTaggedContentAs(91, out);
        this.toolbarDatasource.storeTaggedContentAs(59, out);
        this.standardButtons.storeTaggedContentAs(50, out);
        this.formFilterControl.storeTaggedContentAs(81, out);
        this.extButtons.storeTaggedContentAsNonEmptyStream(60, out);
    }

    @Override
    public int storeTextContent(int textOptions, StringBuilder out, int level, boolean needComma) {
        textOptions = 0;
        DForm.addNewLineIfNeed(textOptions, out).append("//#region ").append("PARAMETERS").append("\n");
        this.datamodel.parameters.storeTextContent(12, out, 0, false);
        DForm.addNewLineIfNeed(textOptions, out).append("//#endregion ").append("PARAMETERS").append("\n");
        DForm.addNewLineIfNeed(textOptions, out).append("//#region ").append("DATAMODEL").append("\n");
        this.datamodel.storeNamedNodes(out).append('\n');
        StringBuilder props = new StringBuilder();
        int propCount = this.datamodel.storeTextContentProperties(textOptions, props, level + 1);
        out.append("const ").append("datamodel").append(" = ").append(this.datamodel.dsl);
        if (propCount != 0) {
            out.append("\n({").append((CharSequence)props);
            DForm.addNewLineIfNeed(textOptions, out);
            out.append("});");
        } else {
            out.append("();");
        }
        DForm.addNewLineIfNeed(textOptions, out).append("//#endregion ").append("DATAMODEL").append("\n");
        DForm.addNewLineIfNeed(textOptions, out).append("//#region ").append("COMPONENTS").append("\n");
        int itemCount = 0;
        ArrayList<DProperty> propList = new ArrayList<DProperty>();
        props = new StringBuilder();
        for (DProperty p : this.components.properties) {
            if (!p.isStorable() || !p.scriptable() || p.checkPropOptions(2) && p.isDefault() || !(p instanceof DComponent) || ((DComponent)p).isControl()) continue;
            if (itemCount != 0) {
                props.append(',');
            }
            ++itemCount;
            p.storeTextContent(textOptions, props, level + 1, false);
            if (!((DComponent)p).isTextNameStorable()) continue;
            propList.add(p);
        }
        if (itemCount != 0) {
            for (DProperty property : propList) {
                property.storeTextContent(12, out, 0, false);
            }
            DForm.addNewLineIfNeed(textOptions, out).append("const ").append("components").append(" = \n[");
            if (itemCount != 1) {
                out.append('\n');
            }
            out.append((CharSequence)props);
            DForm.addNewLineIfNeed(textOptions, out).append("];\n");
        } else {
            out.append("const ").append("components").append(" = [];\n");
        }
        DForm.addNewLineIfNeed(textOptions, out).append("//#endregion ").append("COMPONENTS").append("\n");
        itemCount = 0;
        propList.clear();
        props = new StringBuilder();
        for (DProperty p : this.components.properties) {
            if (!p.isStorable() || !p.scriptable() || p.checkPropOptions(2) && p.isDefault() || !(p instanceof DComponent) || !((DComponent)p).isControl()) continue;
            if (itemCount != 0) {
                props.append(',');
            }
            ++itemCount;
            p.storeTextContent(textOptions, props, level + 1, false);
            if (!((DComponent)p).isTextNameStorable()) continue;
            propList.add(p);
        }
        DForm.addNewLineIfNeed(textOptions, out).append("//#region ").append("CONTROLS").append("\n");
        if (itemCount != 0) {
            for (DProperty property : propList) {
                property.storeTextContent(12, out, 0, false);
            }
            DForm.addNewLineIfNeed(textOptions, out).append("const ").append("controls").append(" = \n[");
            if (itemCount != 1) {
                out.append('\n');
            }
            out.append((CharSequence)props);
            DForm.addNewLineIfNeed(textOptions, out).append("];\n");
        } else {
            out.append("const ").append("controls").append(" = [];\n");
        }
        DForm.addNewLineIfNeed(textOptions, out).append("//#endregion ").append("CONTROLS").append("\n");
        DForm.addNewLineIfNeed(textOptions, out).append("//#region ").append("FORM").append("\n");
        out.append("const ").append("form").append(" = ").append("MtdForm.form").append("\n({");
        this.storeTextContentProperties(textOptions, out, level + 1);
        DForm.addNewLineIfNeed(textOptions, out).append("});\n");
        DForm.addNewLineIfNeed(textOptions, out).append("//#endregion ").append("FORM").append("\n");
        DForm.addNewLineIfNeed(textOptions, out).append("//#region ").append("CLIENT SCRIPT").append("\n");
        out.append(this.script.value);
        DForm.addNewLineIfNeed(textOptions, out).append("//#endregion ").append("CLIENT SCRIPT").append("\n");
        return 100;
    }

    @Override
    public void afterLoad() {
        this.components.afterLoad();
    }

    @Override
    public NonVisualComponent findComponent(int id) {
        return this.components.findComponent(id);
    }

    @Override
    public NonVisualComponent findComponent(int id, Class cls) {
        NonVisualComponent component = this.components.findComponent(id);
        return cls == null || cls.isInstance(component) ? component : null;
    }

    @Override
    public DControl findControl(int id) {
        return this.components.findControl(id);
    }

    @Override
    public DDatasource findDatasource(int uid) {
        return this.datamodel.findDatasource(uid);
    }

    @Override
    public DParameter findParameter(int paramId) {
        for (DProperty property : this.datamodel.parameters.properties) {
            if (!(property instanceof DParameter) || ((DParameter)property).id.value != paramId) continue;
            return (DParameter)property;
        }
        return null;
    }
}

