/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DDiagramAxis;
import inform.agent.mtd.obj.DDiagramLegend;
import inform.agent.mtd.obj.DDiagramSerie;
import inform.agent.mtd.obj.DDiagramTitle;
import inform.agent.mtd.obj.DDiagramWall;
import inform.agent.mtd.obj.DFont;
import inform.agent.mtd.obj.DFormControl;
import inform.agent.mtd.obj.DFormat;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyBool;
import inform.agent.mtd.obj.DPropertyEnum;
import inform.agent.mtd.obj.DPropertyInt;
import inform.agent.mtd.obj.DPropertyString;
import inform.agent.mtd.obj.DView3D;
import java.io.IOException;

public class DFormDiagram
extends DFormControl {
    protected final DPropertyInt panningMode = new DPropertyInt(this, "panningMode", 32770);
    protected final DPropertyInt maxPointsPerPage = new DPropertyInt(this, "maxPointsPerPage", 32770);
    protected final DPropertyInt hintFormatID = new DPropertyInt(this, "hintFormatID", 32770);
    protected final DPropertyInt diagramBcolor = new DPropertyInt(this, "diagramBcolor", 49154);
    protected final DPropertyInt flBorderRadius = new DPropertyInt(this, "flBorderRadius", 32770);
    protected final DPropertyInt flSelectedColor = new DPropertyInt(this, "flSelectedColor", 49154);
    protected final DPropertyInt printSettingWidth = new DPropertyInt(this, "printSettingWidth", 32770);
    protected final DPropertyInt printSettingHeight = new DPropertyInt(this, "printSettingHeight", 32770);
    protected final DPropertyInt animatedZoomSteps = new DPropertyInt(this, "animatedZoomSteps", 32770);
    protected final DPropertyInt markCursor = new DPropertyInt(this, "markCursor", 32770, -1);
    protected final DPropertyEnum leftButtonMouseMethod = new DPropertyEnum((DProperty)this, "leftButtonMouseMethod", 32770, -1, DIAGRAM_CHART_LEFT_BUTTON_MOUSE_METHODS);
    protected final DPropertyEnum bevelOuter = new DPropertyEnum((DProperty)this, "bevelOuter", 32770, -1, DIAGRAM_BEVEL_CUTS);
    protected final DPropertyBool allowZoom = new DPropertyBool(this, "allowZoom", 4098, true);
    protected final DPropertyBool tabStop = new DPropertyBool(this, "tabStop", 4098, true);
    protected final DPropertyBool animatedZoom = new DPropertyBool(this, "animatedZoom", 4098, true);
    protected final DPropertyBool clipPoints = new DPropertyBool(this, "clipPoints", 4098, true);
    protected final DPropertyBool scaleLastPage = new DPropertyBool(this, "scaleLastPage", 4098, true);
    protected final DPropertyBool drawXYLabels = new DPropertyBool(this, "drawXYLabels", 4098, false);
    protected final DPropertyBool noMargins = new DPropertyBool(this, "noMargins", 4098, false);
    protected final DPropertyBool markParentFont = new DPropertyBool(this, "markParentFont", 4098, false);
    protected final DPropertyString onMouseClick = new DPropertyString(this, "onMouseClick", 0x200002);
    protected final DPropertyString onMouseDoubleClick = new DPropertyString(this, "onMouseDoubleClick", 0x200002);
    protected final DPropertyString onHoverSector = new DPropertyString(this, "onHoverSector", 0x200002);
    protected final DDiagramTitle diagramTitleUp = new DDiagramTitle(this, "diagramTitleUp");
    protected final DDiagramTitle diagramTitleDown = new DDiagramTitle(this, "diagramTitleDown");
    protected final DDiagramLegend diagramLegend = new DDiagramLegend(this, "diagramLegend");
    protected final DView3D view3D = new DView3D(this, "view3D");
    protected final DDiagramSerie diagramSerie = new DDiagramSerie(this, "diagramSerie");
    protected final DDiagramAxis diagramAxisLeft = new DDiagramAxis(this, "diagramAxisLeft");
    protected final DDiagramAxis diagramAxisTop = new DDiagramAxis(this, "diagramAxisTop");
    protected final DDiagramAxis diagramAxisRight = new DDiagramAxis(this, "diagramAxisRight");
    protected final DDiagramAxis diagramAxisBottom = new DDiagramAxis(this, "diagramAxisBottom");
    protected final DDiagramAxis diagramAxisDepth = new DDiagramAxis(this, "diagramAxisDepth");
    protected final DDiagramAxis diagramAxisCustom = new DDiagramAxis(this, "diagramAxisCustom");
    protected final DDiagramWall leftWall = new DDiagramWall(this, "leftWall");
    protected final DDiagramWall bottomWall = new DDiagramWall(this, "bottomWall");
    protected final DDiagramWall backWall = new DDiagramWall(this, "backWall");
    protected final DFont markFont = new DFont(this, "markFont");
    protected final DFormat formatOption = new DFormat(this, "hintFormatOption", 2);
    private boolean diagramTitleExist = false;
    private boolean diagramAxisExist = false;
    private boolean wallExist = false;
    private boolean markExist = false;
    private boolean printSettingExist = false;
    private boolean formatOptionExist = false;

    public DFormDiagram(int id, int left, int top, int right, int bottom, int options) {
        super(14, id, left, top, right, bottom, options);
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        int tag;
        block64: while ((tag = in.getNextTag()) != 0) {
            switch (tag) {
                case 60: {
                    this.allowZoom.value = false;
                    continue block64;
                }
                case 61: {
                    this.animatedZoom.value = !this.animatedZoom.value;
                    continue block64;
                }
                case 75: {
                    this.drawXYLabels.value = true;
                    continue block64;
                }
                case 64: {
                    this.clipPoints.value = !this.clipPoints.value;
                    continue block64;
                }
                case 65: {
                    this.scaleLastPage.value = !this.scaleLastPage.value;
                    continue block64;
                }
                case 66: {
                    this.panningMode.loadTaggedContent(in);
                    continue block64;
                }
                case 67: {
                    this.animatedZoomSteps.loadTaggedContent(in);
                    continue block64;
                }
                case 71: {
                    this.maxPointsPerPage.loadTaggedContent(in);
                    continue block64;
                }
                case 62: {
                    this.tabStop.value = false;
                    continue block64;
                }
                case 63: {
                    this.bevelOuter.loadTaggedContent(in);
                    continue block64;
                }
                case 54: {
                    this.hintFormatID.loadTaggedContent(in);
                    continue block64;
                }
                case 56: {
                    this.diagramBcolor.loadTaggedContent(in);
                    continue block64;
                }
                case 72: {
                    this.onMouseClick.loadTaggedContent(in);
                    continue block64;
                }
                case 74: {
                    this.leftButtonMouseMethod.loadTaggedContent(in);
                    continue block64;
                }
                case 77: {
                    this.onMouseDoubleClick.loadTaggedContent(in);
                    continue block64;
                }
                case 78: {
                    this.onHoverSector.loadTaggedContent(in);
                    continue block64;
                }
                case 79: {
                    this.flSelectedColor.loadTaggedContent(in);
                    continue block64;
                }
                case 80: {
                    this.flBorderRadius.loadTaggedContent(in);
                    continue block64;
                }
                case 40: {
                    this.diagramSerie.loadTaggedContent(in.getSubStreamReader());
                    continue block64;
                }
                case 43: {
                    TaggedReader groupAxis = in.getSubStreamReader();
                    this.diagramAxisExist = true;
                    while (groupAxis.next()) {
                        AxisPlace place = AxisPlace.None;
                        switch (groupAxis.getCurrentTag()) {
                            case 61: {
                                place = AxisPlace.Left;
                                break;
                            }
                            case 63: {
                                place = AxisPlace.Top;
                                break;
                            }
                            case 62: {
                                place = AxisPlace.Right;
                                break;
                            }
                            case 64: {
                                place = AxisPlace.Bottom;
                                break;
                            }
                            case 65: {
                                place = AxisPlace.Depth;
                                break;
                            }
                            case 66: {
                                place = AxisPlace.Custom;
                            }
                        }
                        if (place == AxisPlace.None) continue;
                        TaggedReader axisReader = groupAxis.getSubStreamReader();
                        switch (place) {
                            case Left: {
                                this.diagramAxisLeft.loadTaggedContent(axisReader);
                                break;
                            }
                            case Top: {
                                this.diagramAxisTop.loadTaggedContent(axisReader);
                                break;
                            }
                            case Right: {
                                this.diagramAxisRight.loadTaggedContent(axisReader);
                                break;
                            }
                            case Bottom: {
                                this.diagramAxisBottom.loadTaggedContent(axisReader);
                                break;
                            }
                            case Depth: {
                                this.diagramAxisDepth.loadTaggedContent(axisReader);
                                break;
                            }
                            case Custom: {
                                this.diagramAxisCustom.loadTaggedContent(axisReader);
                            }
                        }
                    }
                    continue block64;
                }
                case 42: {
                    TaggedReader subdata = in.getSubStreamReader();
                    this.diagramTitleExist = true;
                    while (subdata.next()) {
                        switch (subdata.getCurrentTag()) {
                            case 60: {
                                this.diagramTitleUp.loadTaggedContent(subdata.getSubStreamReader());
                                break;
                            }
                            case 61: {
                                this.diagramTitleDown.loadTaggedContent(subdata.getSubStreamReader());
                            }
                        }
                    }
                    continue block64;
                }
                case 45: {
                    this.diagramLegend.loadTaggedContent(in.getSubStreamReader());
                    continue block64;
                }
                case 46: {
                    this.view3D.loadTaggedContent(in.getSubStreamReader());
                    continue block64;
                }
                case 44: {
                    in.skip();
                    TaggedReader reader = in.getStreamReader(202);
                    this.wallExist = true;
                    block67: while (reader.next()) {
                        switch (reader.getCurrentTag()) {
                            case 60: {
                                this.leftWall.loadTaggedContent(reader.getSubStreamReader());
                                continue block67;
                            }
                            case 62: {
                                this.bottomWall.loadTaggedContent(reader.getSubStreamReader());
                                continue block67;
                            }
                            case 61: {
                                this.backWall.loadTaggedContent(reader.getSubStreamReader());
                                continue block67;
                            }
                        }
                    }
                    continue block64;
                }
                case 53: {
                    in.skip();
                    TaggedReader reader = in.getStreamReader(202);
                    this.printSettingExist = true;
                    block68: while (reader.next()) {
                        switch (reader.getCurrentTag()) {
                            case 1: {
                                this.printSettingWidth.loadTaggedContent(reader);
                                continue block68;
                            }
                            case 2: {
                                this.printSettingHeight.loadTaggedContent(reader);
                                continue block68;
                            }
                        }
                    }
                    continue block64;
                }
                case 73: {
                    in.skip();
                    TaggedReader reader = in.getStreamReader(202);
                    this.markExist = true;
                    while (reader.next()) {
                        switch (reader.getCurrentTag()) {
                            case 61: {
                                reader.skip();
                                this.markFont.loadTaggedContent(reader);
                                break;
                            }
                            case 62: {
                                this.markCursor.loadTaggedContent(reader);
                                break;
                            }
                            case 63: {
                                this.markParentFont.value = true;
                            }
                        }
                    }
                    continue block64;
                }
                case 55: {
                    this.formatOptionExist = true;
                    this.formatOption.loadTaggedContent(new TaggedReader(in.getRaw(55)));
                    continue block64;
                }
                case 76: {
                    this.noMargins.value = true;
                    continue block64;
                }
            }
            super.loadTag(in);
        }
    }

    @Override
    public void storeTaggedContent(int[] header, TaggedWriter out) throws IOException {
        this.getHeader(header);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TaggedWriter data = new TaggedWriter(baos);
        this.panningMode.storeTaggedContentAs(66, out);
        this.maxPointsPerPage.storeTaggedContentAs(71, out);
        this.hintFormatID.storeTaggedContentAs(54, out);
        this.diagramBcolor.storeTaggedContentAs(56, out);
        this.leftButtonMouseMethod.storeTaggedContentAs(74, out);
        this.flBorderRadius.storeTaggedContentAs(80, out);
        this.flSelectedColor.storeTaggedContentAs(79, out);
        this.animatedZoomSteps.storeTaggedContentAs(67, out);
        this.bevelOuter.storeTaggedContentAs(63, out);
        this.onMouseClick.storeTaggedContentAs(72, out);
        this.onMouseDoubleClick.storeTaggedContentAs(77, out);
        this.onHoverSector.storeTaggedContentAs(78, out);
        this.diagramSerie.storeTaggedContentAs(40, out);
        this.view3D.storeTaggedContentAs(46, out);
        this.diagramLegend.storeTaggedContentAs(45, out);
        if (this.noMargins.value) {
            out.putEmpty(76);
        }
        if (this.drawXYLabels.value) {
            out.putEmpty(75);
        }
        if (!this.allowZoom.value) {
            out.putEmpty(60);
        }
        if (!this.tabStop.value) {
            out.putEmpty(62);
        }
        if (!this.animatedZoom.value) {
            out.putEmpty(61);
        }
        if (!this.clipPoints.value) {
            out.putEmpty(64);
        }
        if (!this.scaleLastPage.value) {
            out.putEmpty(65);
        }
        if (this.diagramAxisExist) {
            this.diagramAxisLeft.storeTaggedContentAs(61, data);
            this.diagramAxisTop.storeTaggedContentAs(63, data);
            this.diagramAxisRight.storeTaggedContentAs(62, data);
            this.diagramAxisBottom.storeTaggedContentAs(64, data);
            this.diagramAxisDepth.storeTaggedContentAs(65, data);
            this.diagramAxisCustom.storeTaggedContentAs(66, data);
            data.flush();
            out.putEmpty(43);
            out.putRaw(202, baos);
            baos.reset();
        }
        if (this.diagramTitleExist) {
            this.diagramTitleUp.storeTaggedContentAs(60, data);
            this.diagramTitleDown.storeTaggedContentAs(61, data);
            data.flush();
            out.putEmpty(42);
            out.putRaw(202, baos);
            baos.reset();
        }
        if (this.wallExist) {
            this.leftWall.storeTaggedContentAs(60, data);
            this.bottomWall.storeTaggedContentAs(62, data);
            this.backWall.storeTaggedContentAs(61, data);
            data.flush();
            out.putEmpty(44);
            out.putRaw(202, baos);
            baos.reset();
        }
        if (this.markExist) {
            if (!this.markFont.isDefault()) {
                data.putEmpty(61);
                this.markFont.storeTaggedContentAs(202, data);
            }
            this.markCursor.storeTaggedContentAs(62, data);
            this.markParentFont.storeTaggedContentAs(63, data);
            data.flush();
            out.putEmpty(73);
            out.putRaw(202, baos);
            baos.reset();
        }
        if (this.printSettingExist) {
            this.printSettingWidth.storeTaggedContentAs(1, data);
            this.printSettingHeight.storeTaggedContentAs(2, data);
            data.flush();
            out.putEmpty(53);
            out.putRaw(202, baos);
            baos.reset();
        }
        if (this.formatOptionExist) {
            this.formatOption.storeTaggedContent(data);
            data.flush();
            out.putRaw(55, baos);
            baos.reset();
        }
    }

    @Override
    public boolean isDefault() {
        for (DProperty p : this.properties) {
            if (p.isDefault() || !p.isStorable()) continue;
            return false;
        }
        return true;
    }

    private static enum AxisPlace {
        None,
        Left,
        Top,
        Right,
        Bottom,
        Depth,
        Custom;

    }
}

