/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DFormControl;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyBool;
import inform.agent.mtd.obj.DPropertyDatasource;
import inform.agent.mtd.obj.DPropertyDouble;
import inform.agent.mtd.obj.DPropertyEnum;
import inform.agent.mtd.obj.DPropertyField;
import inform.agent.mtd.obj.DPropertyInt;
import inform.agent.mtd.obj.DPropertyString;
import inform.agent.mtd.obj.DVisibilityItem;
import inform.agent.mtd.obj.DVisibilityItems;
import java.io.IOException;

public class DFormDocument
extends DFormControl {
    protected final DPropertyString docDescription = new DPropertyString(this, "docDescription", 524290);
    protected final DPropertyDatasource datasourceId = new DPropertyDatasource(this, "dsId", 32770);
    protected final DPropertyField datasourceField = new DPropertyField((DProperty)this, "dsField", 32770, this.datasourceId);
    protected final DPropertyInt securityCtrl = new DPropertyInt(this, "securityCtrl", 32770);
    protected final DPropertyInt tField = new DPropertyInt(this, "tField", 32770);
    protected final DPropertyInt tSrcId = new DPropertyInt(this, "tSrcId", 32770);
    protected final DPropertyInt schemeCtrl = new DPropertyInt(this, "schemeCtrl", 32770);
    protected final DPropertyEnum scrolls = new DPropertyEnum((DProperty)this, "scrolls", 32770, -1, DOC_SCROLLS);
    protected final DPropertyEnum borderStyle = new DPropertyEnum((DProperty)this, "borderStyle", 131074, -1, DOC_BORDER_STYLES);
    protected final DPropertyEnum codepage = new DPropertyEnum((DProperty)this, "codepage", 32770, -1, DOC_CODEPAGES);
    protected final DPropertyDouble styleLib = new DPropertyDouble(this, "styleLib", 2);
    protected final DPropertyDouble baseLibraryID = new DPropertyDouble(this, "baseLibraryID", 2);
    protected final DPropertyBool scrollToEnd = new DPropertyBool(this, "scrollToEnd", 4098, false);
    protected final DPropertyBool readonly = new DPropertyBool(this, "readonly", 4098, false);
    protected final DVisibilityItems groupsVisibility = new DVisibilityItems(this, "groupsVisibility");
    protected final DVisibilityItems itemsVisibility = new DVisibilityItems(this, "itemsVisibility");

    public DFormDocument(int id, int left, int top, int right, int bottom, int options) {
        super(27, id, left, top, right, bottom, options);
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        int tag;
        block20: while ((tag = in.getNextTag()) != 0) {
            switch (tag) {
                case 22: {
                    this.docDescription.loadTaggedContent(in);
                    continue block20;
                }
                case 1: {
                    this.datasourceId.loadTaggedContent(in);
                    continue block20;
                }
                case 2: {
                    this.datasourceField.loadTaggedContent(in);
                    continue block20;
                }
                case 37: {
                    this.securityCtrl.loadTaggedContent(in);
                    continue block20;
                }
                case 3: {
                    this.readonly.value = true;
                    continue block20;
                }
                case 4: {
                    int innerTag;
                    in.skip();
                    TaggedReader inner = in.getStreamReader();
                    while ((innerTag = inner.getNextTag()) != 0) {
                        switch (innerTag) {
                            case 4: 
                            case 5: {
                                inner.skip();
                                TaggedReader r = inner.getStreamReader();
                                while (r.next()) {
                                    DVisibilityItem prop = new DVisibilityItem(this);
                                    prop.tlbValue.value = r.getBoolean() ? 1 : 0;
                                    prop.tlbCurrentTag.value = r.getCurrentTag();
                                    if (innerTag == 5) {
                                        this.itemsVisibility.properties.add(prop);
                                        continue;
                                    }
                                    this.groupsVisibility.properties.add(prop);
                                }
                                break;
                            }
                        }
                    }
                    continue block20;
                }
                case 5: {
                    this.tField.loadTaggedContent(in);
                    continue block20;
                }
                case 6: {
                    this.tSrcId.loadTaggedContent(in);
                    continue block20;
                }
                case 7: {
                    this.borderStyle.value = in.getByte();
                    continue block20;
                }
                case 8: {
                    this.styleLib.loadTaggedContent(in);
                    continue block20;
                }
                case 9: {
                    this.schemeCtrl.loadTaggedContent(in);
                    continue block20;
                }
                case 10: {
                    this.scrolls.loadTaggedContent(in);
                    continue block20;
                }
                case 11: {
                    this.scrollToEnd.value = true;
                    continue block20;
                }
                case 12: {
                    this.codepage.loadTaggedContent(in);
                    continue block20;
                }
                case 151: {
                    this.baseLibraryID.loadTaggedContent(in);
                    continue block20;
                }
            }
            super.loadTag(in);
        }
    }

    @Override
    public void storeTaggedContent(int[] header, TaggedWriter out) throws IOException {
        this.getHeader(header);
        if (!this.docDescription.isEmpty()) {
            this.docDescription.storeTaggedContentAs(22, out);
        }
        if (!this.datasourceId.isDefault()) {
            this.datasourceId.storeTaggedContentAs(1, out);
        }
        if (!this.datasourceField.isDefault()) {
            this.datasourceField.storeTaggedContentAs(2, out);
        }
        if (!this.securityCtrl.isDefault()) {
            this.securityCtrl.storeTaggedContentAs(37, out);
        }
        if (!this.tField.isDefault()) {
            this.tField.storeTaggedContentAs(5, out);
        }
        if (!this.tSrcId.isDefault()) {
            this.tSrcId.storeTaggedContentAs(6, out);
        }
        if (!this.schemeCtrl.isDefault()) {
            this.schemeCtrl.storeTaggedContentAs(9, out);
        }
        if (!this.scrolls.isDefault()) {
            this.scrolls.storeTaggedContentAs(10, out);
        }
        if (!this.codepage.isDefault()) {
            this.codepage.storeTaggedContentAs(12, out);
        }
        if (!this.styleLib.isDefault()) {
            this.styleLib.storeTaggedContentAs(8, out);
        }
        if (!this.borderStyle.isDefault()) {
            this.borderStyle.storeTaggedContentAs(7, out);
        }
        if (!this.baseLibraryID.isDefault()) {
            this.baseLibraryID.storeTaggedContentAs(151, out);
        }
        if (!this.groupsVisibility.properties.isEmpty() || !this.itemsVisibility.properties.isEmpty()) {
            ByteArrayOutputStream subData = new ByteArrayOutputStream();
            this.storeVisibility(subData);
            out.putEmpty(4);
            out.putRaw(202, subData);
        }
        if (this.scrollToEnd.value) {
            out.putEmpty(11);
        }
        if (this.readonly.value) {
            out.putEmpty(3);
        }
    }

    private void storeVisibility(ByteArrayOutputStream subData) throws IOException {
        DVisibilityItem prop;
        TaggedWriter innerOut;
        ByteArrayOutputStream innerData;
        TaggedWriter out = new TaggedWriter(subData);
        if (!this.groupsVisibility.properties.isEmpty()) {
            out.putEmpty(4);
            innerData = new ByteArrayOutputStream();
            innerOut = new TaggedWriter(innerData);
            for (DProperty p : this.groupsVisibility.properties) {
                prop = (DVisibilityItem)p;
                innerOut.putInt08(prop.tlbCurrentTag.value, (byte)(prop.tlbValue.value & 0xFF));
            }
            innerOut.flush();
            out.putRaw(202, innerData);
        }
        if (!this.itemsVisibility.properties.isEmpty()) {
            out.putEmpty(5);
            innerData = new ByteArrayOutputStream();
            innerOut = new TaggedWriter(innerData);
            for (DProperty p : this.itemsVisibility.properties) {
                prop = (DVisibilityItem)p;
                innerOut.putInt08(prop.tlbCurrentTag.value, (byte)(prop.tlbValue.value & 0xFF));
            }
            innerOut.flush();
            out.putRaw(202, innerData);
        }
        out.flush();
    }

    @Override
    public boolean isDefault() {
        for (DProperty p : this.properties) {
            if (p.isDefault() || !p.isStorable()) continue;
            return false;
        }
        return true;
    }
}

