/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DArray;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DObject;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyNodeRef;
import java.io.IOException;

public class DParametersPlugin
extends DArray {
    public DParametersPlugin(DProperty object) {
        super(object, "pluginParameters", 2);
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        while (in.next()) {
            if (in.getCurrentTag() != 1) continue;
            DParameterPlugin item = new DParameterPlugin(this);
            item.loadTaggedContent(in);
            this.properties.add(item);
        }
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter subOut = new TaggedWriter(data);
        for (DProperty p : this.properties) {
            if (!(p instanceof DParameterPlugin)) continue;
            DParameterPlugin plugin = (DParameterPlugin)p;
            plugin.storeTaggedContent(subOut);
        }
        subOut.flush();
        if (data.size() != 0) {
            out.putRaw(121, data);
        }
    }

    @Override
    public DProperty loadScriptArrayItem(Object obj) {
        DParameterPlugin item = new DParameterPlugin(this);
        item.loadScriptValue(obj);
        return item;
    }

    @Override
    protected void doAssign(DItem source) {
        if (DParametersPlugin.checkAssignType(source, this.getClass())) {
            for (DProperty sourceProperty : ((DParametersPlugin)source).properties) {
                if (!DParametersPlugin.checkAssignType(sourceProperty, DParametersPlugin.class)) continue;
                DParametersPlugin sourcePlugin = (DParametersPlugin)sourceProperty;
                DParametersPlugin plugin = new DParametersPlugin(this);
                plugin.assign(sourcePlugin);
                this.properties.add(plugin);
            }
        }
    }

    public static class DParameterPlugin
    extends DObject {
        protected final DPropertyNodeRef node = new DPropertyNodeRef(this, "nodeID", 2);

        public DParameterPlugin(DProperty object) {
            super(object, null, 32);
        }

        @Override
        public void loadTaggedContent(TaggedReader in) throws IOException {
            this.node.value = in.getDouble(1);
        }

        @Override
        public void storeTaggedContent(TaggedWriter out) throws IOException {
            out.putDouble(1, this.node.value);
        }
    }
}

