/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyEnum;

public class DPropertyEnumSet
extends DPropertyEnum {
    public DPropertyEnumSet(DProperty object, String name, int tagOption, int defaultValue, String[] mapNames) {
        super(object, name, tagOption, defaultValue, mapNames);
    }

    public DPropertyEnumSet(DProperty object, String name, int tagOption, int defaultValue, int[] mapValues, String[] mapNames) {
        super(object, name, tagOption, defaultValue, mapValues, mapNames);
    }

    public DPropertyEnumSet(DProperty object, String name, int tagOption, String[] mapNames) {
        super(object, name, tagOption, mapNames);
    }

    public DPropertyEnumSet(DProperty object, String name, int tagOption, int[] mapValues, String[] mapNames) {
        super(object, name, tagOption, mapValues, mapNames);
    }

    @Override
    public void setValue(String value) {
        this.value = 0;
        int start = DPropertyEnumSet.skipSeparators(value, 0);
        int count = value.length();
        while (start < count) {
            int end = DPropertyEnumSet.nextWord(value, start);
            if (end != start) {
                int v = this.stringToValue(value.substring(start, end));
                start = end;
                this.value |= 1 << v;
            }
            start = DPropertyEnumSet.skipSeparators(value, start);
        }
    }

    @Override
    public int storeTextContent(int textOptions, StringBuilder out, int level, boolean needComma) {
        DPropertyEnumSet.textContentAddHexProp(textOptions, out, level, this.name, this.value);
        boolean comma = false;
        for (int i = 0; i < 32; ++i) {
            if ((this.value & 1 << i) == 0) continue;
            if (comma) {
                out.append(", ");
            } else {
                comma = true;
                out.append("/*");
            }
            String v = this.mapValue(i);
            if (v != null) {
                out.append(v);
                continue;
            }
            out.append(i);
        }
        if (comma) {
            out.append("*/");
        }
        DPropertyEnumSet.addComma(out, needComma);
        return 1;
    }

    private static int skipSeparators(String name, int offset) {
        int count = name.length();
        block3: while (offset < count) {
            switch (name.charAt(offset)) {
                case ' ': 
                case ',': 
                case ';': 
                case '[': 
                case ']': {
                    break;
                }
                default: {
                    break block3;
                }
            }
            ++offset;
        }
        return offset;
    }

    private static int nextWord(String name, int offset) {
        int count = name.length();
        block3: while (offset < count) {
            switch (name.charAt(offset)) {
                case ' ': 
                case ',': 
                case ';': 
                case '[': 
                case ']': {
                    break block3;
                }
                default: {
                    ++offset;
                    continue block3;
                }
            }
        }
        return offset;
    }
}

