/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.types.ValueCaster;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DProperty;
import java.io.IOException;

public class DPropertyInt
extends DProperty {
    protected int value;
    protected int defaultValue;

    public DPropertyInt(DProperty object, String name, int tagOption) {
        this(object, name, tagOption, 0);
    }

    public DPropertyInt(DProperty object, String name, int tagOption, int defaultValue) {
        super(object, name, tagOption);
        this.value = this.defaultValue = defaultValue;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(int defaultValue) {
        this.value = this.defaultValue = defaultValue;
    }

    public void assignValue(Object value) {
        this.value = ValueCaster.toInt(value);
    }

    @Override
    public boolean isDefault() {
        return this.checkPropOptions(2) && this.value == this.defaultValue;
    }

    @Override
    public boolean scriptable() {
        return super.scriptable() && (!this.checkPropOptions(512) || this.value != this.defaultValue);
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        this.value = this.checkPropOptions(131072) || this.checkPropOptions(262144) ? (this.checkPropOptions(262144) ? in.getByte() & 0xFF : (int)in.getByte()) : (this.checkPropOptions(65536) ? (int)in.getShort() : in.getInt());
    }

    @Override
    protected void doAssign(DItem source) {
        if (DPropertyInt.checkAssignType(source, this.getClass())) {
            this.value = ((DPropertyInt)source).value;
        }
    }

    @Override
    public void loadScriptValue(Object obj) {
        this.value = ValueCaster.toInt(obj);
    }

    @Override
    public void storeTaggedContentAs(int tag, TaggedWriter out) throws IOException {
        if (!this.isStorable() || this.isDefault()) {
            return;
        }
        if (this.checkPropOptions(131072) || this.checkPropOptions(262144)) {
            out.putInt08(tag, (byte)this.value);
            if (this.checkPropOptions(262144)) {
                out.putInt08(tag, (byte)(this.value & 0xFF));
            }
        } else if (this.checkPropOptions(65536)) {
            out.putInt16(tag, (short)this.value);
        } else {
            out.putInt32(tag, this.value);
        }
    }

    @Override
    public int storeTextContent(int textOptions, StringBuilder out, int level, boolean needComma) {
        DPropertyInt.addComma(DPropertyInt.addComment(this.checkPropOptions(16384) ? DPropertyInt.textContentAddHexProp(textOptions, out, level, this.name, this.value) : DPropertyInt.textContentAddProp(textOptions, out, level, this.name, this.value), this.getComment()), needComma);
        return 1;
    }

    protected String getComment() {
        return null;
    }
}

