/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.Strings;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyEnum;

public class DPropertyMaskSet
extends DPropertyEnum {
    public DPropertyMaskSet(DProperty object, String name, int tagOption, int defaultValue, int[] mapValues, String[] mapNames) {
        super(object, name, tagOption, defaultValue, mapValues, mapNames);
    }

    public DPropertyMaskSet(DProperty object, String name, int tagOption, int[] mapValues, String[] mapNames) {
        super(object, name, tagOption, mapValues, mapNames);
    }

    @Override
    public void setValue(String value) {
        this.value = 0;
        int start = DPropertyMaskSet.skipSeparators(value, 0);
        int count = value.length();
        while (start < count) {
            int end = DPropertyMaskSet.nextWord(value, start);
            if (end != start) {
                int v = this.stringToValue(value.substring(start, end));
                start = end;
                this.value |= v;
            }
            start = DPropertyMaskSet.skipSeparators(value, start);
        }
    }

    @Override
    public int storeTextContent(int textOptions, StringBuilder out, int level, boolean needComma) {
        DPropertyMaskSet.textContentAddHexProp(textOptions, out, level, this.name, this.value);
        boolean comma = false;
        int applyedMask = 0;
        for (int i = 0; i < this.mapValues.length; ++i) {
            int mask = this.mapValues[i];
            if ((this.value & mask) != mask || (applyedMask & mask) != 0) continue;
            applyedMask |= mask;
            if (comma) {
                out.append(", ");
            } else {
                out.append("/*");
                comma = true;
            }
            String v = this.mapValue(mask);
            if (!Strings.isVoid(v)) {
                out.append(v);
                continue;
            }
            out.append(Integer.toHexString(i));
        }
        if (comma) {
            out.append("*/");
        }
        DPropertyMaskSet.addComma(out, needComma);
        return 1;
    }

    private static final int skipSeparators(String name, int offset) {
        int count = name.length();
        block3: while (offset < count) {
            switch (name.charAt(offset)) {
                case ' ': 
                case ',': 
                case ';': 
                case '[': 
                case ']': {
                    break;
                }
                default: {
                    break block3;
                }
            }
            ++offset;
        }
        return offset;
    }

    private static final int nextWord(String name, int offset) {
        int count = name.length();
        block3: while (offset < count) {
            switch (name.charAt(offset)) {
                case ' ': 
                case ',': 
                case ';': 
                case '[': 
                case ']': {
                    break block3;
                }
                default: {
                    ++offset;
                    continue block3;
                }
            }
        }
        return offset;
    }
}

