/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DObject;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyDouble;
import inform.agent.mtd.obj.DPropertyEnum;
import inform.agent.mtd.obj.DPropertyField;
import inform.agent.mtd.obj.DPropertyInt;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class DPropertyPeriodicBind
extends DObject {
    protected final DPropertyEnum bindType = new DPropertyEnum(this, "bindType", 32770, PERIODIC_BIND_TYPE_NAMES);
    protected final DPropertyInt fieldId = new DPropertyInt(this, "fieldId", 32770, 0);
    protected final DPropertyDouble date = new DPropertyDouble(this, "date", 2, 0.0);
    protected final DPropertyInt refDatasourceId = new DPropertyInt(this, "refDatasourceId", 32770, 0);
    protected DPropertyField refFieldId = new DPropertyField((DProperty)this, "refFieldId", 32770, this.refDatasourceId);

    public DPropertyPeriodicBind(DProperty object, String name) {
        super(object, name, 2);
    }

    @Override
    public boolean isDefault() {
        if (!this.checkPropOptions(2)) {
            return false;
        }
        for (DProperty p : this.properties) {
            if (p.isDefault() || !p.isStorable()) continue;
            return false;
        }
        return this.bindType.value == 0 || this.checkPropOptions(2);
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        if (!in.next()) {
            return;
        }
        byte[] data = in.getStream().readAllBytes();
        int bindType = in.getCurrentTag();
        if (data.length < 1) {
            return;
        }
        try {
            switch (bindType) {
                case 1: {
                    if (data.length != 8) {
                        return;
                    }
                    this.refDatasourceId.value = ByteBuffer.wrap(data, 0, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                    this.refFieldId.value = ByteBuffer.wrap(data, 4, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
                    break;
                }
                case 2: {
                    this.date.loadTaggedContent(in);
                    break;
                }
                case 3: {
                    this.fieldId.loadTaggedContent(in);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception e) {
            return;
        }
        this.bindType.value = bindType;
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        if (this.bindType.value == 1) {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(this.refDatasourceId.value);
            buffer.putInt(this.refFieldId.value);
            out.putRaw(1, buffer.array());
        } else if (this.bindType.value == 2) {
            this.date.storeTaggedContentAs(2, out);
        } else if (this.bindType.value == 3) {
            this.fieldId.storeTaggedContentAs(3, out);
        }
    }
}

