/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.DateTime;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DPropertyEnum;
import java.util.ArrayList;
import java.util.Date;
import org.mozilla.javascript.NativeArray;
import org.postgresql.shaded.com.ongres.scram.common.bouncycastle.base64.Base64;

public class DPropertyValues
extends DProperty {
    protected final DPropertyEnum dataType;
    protected final ArrayList<Object> value = new ArrayList();

    public DPropertyValues(DProperty object, String name, DPropertyEnum dataType) {
        super(object, name, 2);
        this.dataType = dataType;
    }

    @Override
    public boolean isDefault() {
        return this.checkPropOptions(2) && this.value.isEmpty();
    }

    @Override
    public void loadScriptValue(Object obj) {
        this.value.clear();
        DataType type = DataType.getDataTypeById(this.dataType.value);
        if (obj == null) {
            this.value.add(null);
        } else if (obj instanceof NativeArray) {
            NativeArray array = (NativeArray)obj;
            long count = array.getLength();
            for (long index = 0L; index < count; ++index) {
                this.value.add(ValueCaster.getCastedValue(type, array.get(index)));
            }
        } else {
            this.value.add(ValueCaster.getCastedValue(type, obj));
        }
    }

    @Override
    protected void doAssign(DItem source) {
        if (DPropertyValues.checkAssignType(source, this.getClass())) {
            this.value.clear();
            for (Object v : ((DPropertyValues)source).value) {
                this.value.add(v);
            }
        }
    }

    @Override
    public int storeTextContent(int textOptions, StringBuilder out, int level, boolean needComma) {
        boolean multiple;
        if (this.value.size() > 1) {
            textOptions &= 0xFFFFFFFE;
        }
        DPropertyValues.addTextShiftLn(textOptions, out, level).append(this.name).append(": ");
        boolean bl = multiple = this.value.size() > 1;
        if (multiple) {
            out.append('[');
        }
        if (this.value.isEmpty()) {
            out.append("null");
        } else {
            boolean comma = false;
            block7: for (Object v : this.value) {
                if (comma) {
                    out.append(", ");
                } else {
                    comma = true;
                }
                if (v == null) {
                    out.append("null");
                    continue;
                }
                switch (this.dataType.value) {
                    case -1: 
                    case 1: 
                    case 2: 
                    case 5: 
                    case 6: 
                    case 10: {
                        out.append(ValueCaster.toString(ValueCaster.toNumber(v)));
                        continue block7;
                    }
                    case 3: 
                    case 12: 
                    case 13: {
                        DPropertyValues.textContentAddString(out, ValueCaster.toString(v));
                        continue block7;
                    }
                    case 4: {
                        Date date = ValueCaster.toDate(v);
                        out.append('\"').append(DateTime.toLogString(DateTime.fromUnixTime(date.getTime()))).append('\"');
                        continue block7;
                    }
                    case 7: {
                        out.append(ValueCaster.toBoolean(v));
                        continue block7;
                    }
                    case 8: {
                        if (v instanceof byte[]) {
                            out.append('\"').append(Base64.toBase64String((byte[])((byte[])v))).append('\"');
                            continue block7;
                        }
                        out.append("null");
                        continue block7;
                    }
                }
                out.append("null");
            }
        }
        if (multiple) {
            DPropertyValues.addTextShiftLn(textOptions, out, level).append(']');
        }
        DPropertyValues.addComma(out, needComma);
        return this.value.size();
    }
}

