/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.mtd.obj.DArray;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DProperty;
import inform.agent.mtd.obj.DTreeFooterCell;
import java.io.IOException;

public class DTreeColumnFooter
extends DArray {
    public DTreeColumnFooter(DProperty object, String name) {
        super(object, name, 2);
    }

    @Override
    public DProperty loadScriptArrayItem(Object obj) {
        DTreeFooterCell item = new DTreeFooterCell(this);
        item.loadScriptValue(obj);
        return item;
    }

    @Override
    protected void doAssign(DItem source) {
        if (DTreeColumnFooter.checkAssignType(source, this.getClass())) {
            for (DProperty sourceProperty : ((DTreeColumnFooter)source).properties) {
                if (!DTreeColumnFooter.checkAssignType(sourceProperty, DTreeFooterCell.class)) continue;
                DTreeFooterCell sourceCell = (DTreeFooterCell)sourceProperty;
                DTreeFooterCell footerCell = new DTreeFooterCell(this);
                footerCell.assign(sourceCell);
                this.properties.add(footerCell);
            }
        }
    }

    @Override
    public void loadTaggedContent(TaggedReader in) throws IOException {
        DTreeFooterCell footerCell = null;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 5: {
                    footerCell = new DTreeFooterCell(this);
                    this.properties.add(footerCell);
                    break;
                }
                case 7: {
                    if (footerCell == null) break;
                    footerCell.font.loadTaggedContent(in);
                    break;
                }
                case 6: {
                    if (footerCell == null) break;
                    footerCell.parentFont.value = true;
                    break;
                }
                case 8: {
                    if (footerCell == null) break;
                    footerCell.color.loadTaggedContent(in);
                    break;
                }
                case 9: {
                    if (footerCell == null) break;
                    footerCell.summaryFunction.loadTaggedContent(in);
                    break;
                }
                case 10: {
                    if (footerCell == null) break;
                    footerCell.onGetData.loadTaggedContent(in);
                    break;
                }
                case 11: {
                    if (footerCell == null) break;
                    footerCell.formatId.loadTaggedContent(in);
                    break;
                }
                case 12: {
                    if (footerCell == null) break;
                    footerCell.formatOption.loadTaggedContent(in.getStreamReader());
                }
            }
        }
    }

    @Override
    public void storeTaggedContentAs(int tag, TaggedWriter out) throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter stream = new TaggedWriter(data);
        this.storeTaggedContent(stream);
        stream.flush();
        if (data.size() != 0) {
            out.putRaw(tag, data);
        }
    }

    @Override
    public void storeTaggedContent(TaggedWriter out) throws IOException {
        for (DProperty p : this.properties) {
            if (!(p instanceof DTreeFooterCell)) continue;
            DTreeFooterCell footerCell = (DTreeFooterCell)p;
            out.putEmpty(5);
            footerCell.storeTaggedContent(out);
        }
    }
}

