/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.obj;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.DirectoryRowset;
import inform.agent.db.utils.DirectoryRowsetCacheKey;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DPropertyEnum;
import inform.agent.mtd.obj.DslRuntimeForm;
import inform.agent.scripts.ComponentList;
import inform.agent.scripts.Constants;
import inform.agent.scripts.Database;
import inform.agent.scripts.GenericServerSideExecutable;
import inform.agent.scripts.ParametersList;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.ScriptableRequest;
import inform.agent.scripts.Task;
import inform.agent.scripts.stat.DatasourceProfile;
import inform.agent.scripts.stat.DirectoryProfile;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;

public abstract class DslRuntime
extends GenericServerSideExecutable
implements Task {
    protected final String dslContent;
    protected final BasicNode node;
    protected final String dslTitle;
    protected Context context = null;
    protected Scriptable topLevelScope = null;
    protected final int[] offsets = new int[]{-1, -1};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getContent(SSContext parentContext, Task parentTask, ServerSideHost ssHost, BasicNode node, String dslContent) throws Exception {
        try (DslRuntime runtime = DslRuntime.createRuntime(parentContext, parentTask, ssHost, node, dslContent);){
            runtime.evaluateContent();
            byte[] byArray = runtime.getContent();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkDslContent(SSContext parentContext, Task parentTask, ServerSideHost ssHost, BasicNode node, String dslContent) throws Exception {
        try (DslRuntime runtime = DslRuntime.createRuntime(parentContext, parentTask, ssHost, node, dslContent);){
            runtime.evaluateContent();
        }
    }

    protected static DslRuntime createRuntime(SSContext parentContext, Task parentTask, ServerSideHost ssHost, BasicNode node, String dslContent) {
        DslRuntimeForm runtime;
        if (dslContent == null) {
            MtdEngine.throwDetailError("\u0423\u0437\u0435\u043b \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u043e\u0435 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435", node.getId());
        }
        switch (node.getType()) {
            case 11: {
                runtime = new DslRuntimeForm(parentContext, parentTask, ssHost, node, dslContent);
                break;
            }
            default: {
                StringBuilder detail = new StringBuilder();
                MtdEngine.appendNodeNameForLog(detail, node.getId());
                detail.append("\n\u0422\u0438\u043f \u0443\u0437\u043b\u0430 ").append(DPropertyEnum.mapValue(node.getType(), DItem.NODE_TYPE_VALUES, DItem.NODE_TYPE_TITLES));
                throw new InformException("DSL \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430 \u0443\u0437\u043b\u0430").detail(detail.toString());
            }
        }
        return runtime;
    }

    private static int[] getRegionOffsets(String mergedDsl, String section) {
        int beginOffset;
        String region = "//#region " + section + "\n";
        if (mergedDsl.startsWith(region)) {
            beginOffset = 0;
        } else {
            region = "\n//#region " + section + "\n";
            beginOffset = mergedDsl.indexOf(region);
            if (beginOffset < 0) {
                return null;
            }
        }
        beginOffset += region.length();
        region = "\n//#endregion " + section + "\n";
        int endOffset = mergedDsl.indexOf(region, beginOffset);
        if (endOffset < 0) {
            if (mergedDsl.charAt(mergedDsl.length() - 1) != '\n' && mergedDsl.endsWith(region = "\n//#endregion " + section)) {
                endOffset = mergedDsl.length() - region.length() + 1;
            }
            if (endOffset < 0) {
                return null;
            }
        }
        return new int[]{beginOffset, endOffset};
    }

    protected static String extractRegions(String mergedDsl, String beginSection, String endSection, int[] offset) {
        int[] begin = DslRuntime.getRegionOffsets(mergedDsl, beginSection);
        if (begin == null) {
            return null;
        }
        int[] end = DslRuntime.getRegionOffsets(mergedDsl, endSection);
        if (end == null) {
            return null;
        }
        int beginOffset = Math.min(begin[0], end[0]);
        int endOffset = Math.max(begin[1], end[1]);
        offset[0] = beginOffset;
        return mergedDsl.substring(beginOffset, endOffset);
    }

    protected DslRuntime(SSContext parentContext, Task parentTask, ServerSideHost ssHost, BasicNode node, String dslContent) {
        super(parentContext, 10, node.getId(), ssHost, parentTask);
        this.dslContent = dslContent;
        this.node = node;
        this.dslTitle = node.toLogString();
    }

    protected abstract void evaluateContent() throws Exception;

    protected abstract byte[] getContent() throws Exception;

    protected void createTopLevelScope() {
        this.topLevelScope = ScriptableRequest.createTopLevelScopeForDsl(this.context, this, this.ssHost);
    }

    protected void closeTopLevelScope() {
        this.context = null;
        this.topLevelScope = null;
    }

    protected Object getJavaScriptObject(String name) {
        if (this.topLevelScope.has(name, null)) {
            return this.topLevelScope.get(name, this.topLevelScope);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evaluateRegions(String beginSection, String beginTitle, String endSection, RegionsEvaluated callback) throws Exception {
        this.context = Core.asmoJsContextFactory.enterContext();
        try {
            try {
                this.createTopLevelScope();
                String dsl = DslRuntime.extractRegions(this.dslContent, beginSection, endSection, this.offsets);
                if (!Strings.isVoid(dsl)) {
                    this.context.evaluateString(this.topLevelScope, dsl, this.dslTitle + " - region " + beginSection, 1, null);
                }
                callback.evaluated();
            }
            catch (RhinoException e) {
                Throwable cause = e.getCause();
                String text = cause == null || cause instanceof RhinoException ? e.details() : cause.getMessage();
                Object errorText = Strings.isVoid(text) ? "" : ":\n" + text;
                throw new InformException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u043e\u043c \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0438 " + DPropertyEnum.mapValue(this.node.getType(), DItem.NODE_TYPE_VALUES, DItem.NODE_TYPE_TITLES_GENITIVE) + " \"" + this.node.getName() + "\" (" + beginTitle + ", " + e.lineNumber() + " : " + e.columnNumber() + ")" + (String)errorText, e);
            }
            catch (Throwable e) {
                String text = e.getMessage();
                Object errorText = Strings.isVoid(text) ? "" : ":\n" + text;
                throw new InformException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u043e\u043c \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0438 " + DPropertyEnum.mapValue(this.node.getType(), DItem.NODE_TYPE_VALUES, DItem.NODE_TYPE_TITLES_GENITIVE) + " \"" + this.node.getName() + "\" (\u0441\u0435\u043a\u0446\u0438\u044f " + beginTitle + ")" + (String)errorText, e);
            }
        }
        finally {
            Context.exit();
            this.closeTopLevelScope();
        }
    }

    @Override
    public void commitTransaction() {
        throw new IllegalStateException();
    }

    @Override
    public void startTransaction() {
        throw new IllegalStateException();
    }

    @Override
    public void rollbackTransaction() {
        throw new IllegalStateException();
    }

    @Override
    public void save() throws Exception {
        throw new IllegalStateException();
    }

    @Override
    public Object createDatasource(double tableId, double searchId) {
        throw new IllegalStateException();
    }

    @Override
    public Scriptable createSqlStatement(double connectionID) {
        throw new IllegalStateException();
    }

    @Override
    public Scriptable createCallableStatement(double connectionID) {
        throw new IllegalStateException();
    }

    @Override
    public AbstractConnectionManager getDBManager() {
        throw new IllegalStateException();
    }

    @Override
    public Database getDatabase(double dbId) {
        throw new IllegalStateException();
    }

    @Override
    public ParametersList getParameters() {
        throw new IllegalStateException();
    }

    @Override
    public Constants getConstants() {
        throw new IllegalStateException();
    }

    @Override
    public byte[] getConstantsContent() {
        throw new IllegalStateException();
    }

    @Override
    public DirectoryRowset getDirectoryRowset(DirectoryRowsetCacheKey cacheKey) {
        throw new IllegalStateException();
    }

    @Override
    public void setDatasourceProfile() {
        throw new IllegalStateException();
    }

    @Override
    public boolean isDatasourceProfile() {
        throw new IllegalStateException();
    }

    @Override
    public DatasourceProfile addDatasourceProfile(int uid, double nodeId, double filterId, double moduleId) {
        throw new IllegalStateException();
    }

    @Override
    public DirectoryProfile addDirectory(double nodeId, double moduleId) {
        throw new IllegalStateException();
    }

    @Override
    public String getProfile() {
        throw new IllegalStateException();
    }

    @Override
    public ComponentList getComponents() {
        throw new IllegalStateException();
    }

    @FunctionalInterface
    protected static interface RegionsEvaluated {
        public void evaluated() throws Exception;
    }
}

