/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.srv.ExternalConverter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class ConversionService
extends Request {
    public static int CHUNK_SIZE = 0x400000;
    public static final int MICRO_SERVICE_CONVERT_VSD_2_VSDX = 1;
    public static final int MICRO_SERVICE_CONVERT_VSDX_2_VSD = 2;
    public static final int TAG_MICRO_SERVICE_OPERATION = 1;
    public static final int TAG_MICRO_SERVICE_IN = 2;
    public static final int TAG_MICRO_SERVICE_EXECUTE = 3;
    public static final int TAG_MICRO_SERVICE_OUT = 4;
    private int operation = 0;
    private File fileIn = null;
    private FileOutputStream sourceFileStream = null;
    private File fileOut = null;

    public ConversionService(RequestHeader rq) {
        super(rq, RequestDuration.COMPLEX);
        this.setChunkedInput();
    }

    @Override
    public void execute() throws Throwable {
        try {
            this.processInputChunk(this.getRequestContent());
            this.processChunkedInput();
            this.sendResult();
        }
        finally {
            this.deleteTempFiles();
        }
    }

    @Override
    protected void processInputChunk(byte[] chunk) throws Throwable {
        if (chunk == null || chunk.length == 0) {
            return;
        }
        TaggedReader in = new TaggedReader(new ByteArrayInputStream(chunk), chunk.length);
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    this.operation = in.getInt();
                    break;
                }
                case 2: {
                    this.writeFile(in.getRaw());
                    break;
                }
                case 3: {
                    this.executeService();
                }
            }
        }
    }

    private void deleteTempFiles() {
        try {
            if (this.fileIn != null) {
                if (this.fileIn.exists()) {
                    this.fileIn.delete();
                }
                this.fileIn = null;
            }
        }
        catch (Throwable e) {
            Core.logger.error(null, e);
        }
        try {
            if (this.fileOut != null) {
                if (this.fileOut.exists()) {
                    this.fileOut.delete();
                }
                this.fileOut = null;
            }
        }
        catch (Throwable e) {
            Core.logger.error(null, e);
        }
    }

    private void writeFile(byte[] data) throws IOException {
        if (this.fileIn == null) {
            String outExt;
            String inExt;
            this.deleteTempFiles();
            switch (this.operation) {
                case 1: {
                    inExt = ".vsd";
                    outExt = ".vsdx";
                    break;
                }
                case 2: {
                    inExt = ".vsdx";
                    outExt = ".vsd";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown microservice operation");
                }
            }
            File tempFolder = null;
            if (Core.mountfs.hasMountPoint("temp")) {
                tempFolder = new File(Core.mountfs.resolvePath("temp:/"));
            }
            Object prefix = Strings.isVoid(Ini.AgentID) ? "srv-" : Ini.AgentID + "-";
            this.fileIn = File.createTempFile((String)prefix, inExt, tempFolder);
            this.fileOut = File.createTempFile((String)prefix, outExt, tempFolder);
        }
        if (this.sourceFileStream == null) {
            this.sourceFileStream = new FileOutputStream(this.fileIn);
        }
        this.sourceFileStream.write(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeService() throws Exception {
        try {
            this.sourceFileStream.close();
            this.sourceFileStream = null;
            if (!ExternalConverter.convertVsdToVsdx(this.fileIn, this.fileOut, this) || !this.fileOut.exists() || this.fileOut.length() == 0L) {
                throw new InformException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u0435 vsd-vsdx");
            }
            long fileSize = this.fileOut.length();
            int bufferSize = fileSize > (long)CHUNK_SIZE ? CHUNK_SIZE : (int)fileSize;
            byte[] buffer = new byte[CHUNK_SIZE];
            try (FileInputStream fileInputStream = new FileInputStream(this.fileOut);){
                int bytesReaden;
                do {
                    if ((bytesReaden = fileInputStream.read(buffer)) > 0) {
                        this.sendChunk(buffer, bytesReaden);
                    }
                    this.idle();
                } while (bytesReaden > -1);
            }
            this.operation = 0;
        }
        finally {
            this.deleteTempFiles();
        }
    }
}

