/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.InformException;
import inform.adt.collections.DoubleHash;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.RequestResult;
import inform.agent.db.ClosableResult;
import inform.agent.db.connect.Connector;
import inform.agent.db.connect.ResultSet;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.MtdCache;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.NodeRecord;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Correlations;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.request.NodeStatus;
import java.sql.SQLException;

public class CopyNode
extends Request {
    private NodeRecord record = new NodeRecord(NodeStatus.COPIED);
    private Dependencies dependencies = null;
    private long time;

    public CopyNode(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        if (Ini.ReadonlyMode) {
            this.sendError("\u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f!", "");
            return;
        }
        Node sourceNode = MtdEngine.getValidNode(this.getTranslatedNodeID());
        this.checkRequestAccess(sourceNode, Integer.MIN_VALUE);
        TaggedReader in = this.createRequestContentReader();
        double parentNodeId = -1.0;
        String nodeName = null;
        double historyId = 0.0;
        boolean copyWithChildren = false;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 3: {
                    parentNodeId = in.getDouble();
                    break;
                }
                case 4: {
                    nodeName = in.getString();
                    break;
                }
                case 26: {
                    historyId = in.getDouble();
                    break;
                }
                case 22: {
                    int options = in.getInt();
                    copyWithChildren = (options & 0x20) != 0;
                }
            }
        }
        if (nodeName == null) {
            throw new InformException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0438\u043c\u044f \u0443\u0437\u043b\u0430");
        }
        if (parentNodeId == 0.0) {
            parentNodeId = this.getRootNodeID();
        }
        BasicNode parentNode = MtdEngine.getValidTranslatedNode(parentNodeId);
        this.checkNodeAccess(parentNode, 0x10000000, "\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0443\u0437\u043b\u0430");
        RequestResult result = new RequestResult(this);
        try (Connector.Metabase connector = new Connector.Metabase();){
            this.time = System.currentTimeMillis();
            this.copyNode(sourceNode, connector, parentNode, historyId, nodeName, copyWithChildren);
            if (this.dependencies != null) {
                for (NodeCopy nodeCopy : this.dependencies) {
                    nodeCopy.content = nodeCopy.node.replaceDependencies(this.dependencies, nodeCopy.content);
                    MtdEngine.createNewNode(null, connector, nodeCopy.node, null);
                    if ((nodeCopy.content == null || nodeCopy.content.length == 0) && nodeCopy.dslContent == null) continue;
                    MtdEngine.setNodeContent(this.ssContext, this, nodeCopy.node.getId(), 0L, nodeCopy.content, nodeCopy.dslContent, this.getUserID(), this.getSessionID(), this.security());
                }
            }
            result.getWriter().putDouble(1, this.record.getId());
        }
        result.sendResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyNode(Node sourceNode, Connector connector, BasicNode parentNode, double historyId, String name, boolean withChildren) throws InformException, SQLException {
        byte[] content;
        String dslContent = null;
        ClosableResult closableResult = MetadataNodeReader.getHistoryEntryResultSet(null, sourceNode.getId(), historyId, connector.connection());
        if (closableResult == null) {
            return;
        }
        try {
            ResultSet resultSet = closableResult.getResultSet();
            MetadataNodeReader.loadNodeRecord(resultSet, this.record);
            this.record.setCreationTime(this.time);
            this.record.setModificationAttributeTime(this.time);
            this.record.setSessionId(this.getSessionID());
            this.record.setModificationUserId(this.getUserID());
            content = resultSet.getBlobBytes(resultSet.findColumn("RAW_CONTENT"));
            dslContent = resultSet.getString(resultSet.findColumn("DSL_CONTENT"));
        }
        finally {
            closableResult.close();
        }
        this.record.setId(Core.generateId());
        this.record.setParentId(parentNode.getId());
        this.record.setName(parentNode.getNewChildName(connector, name));
        this.record.setOrderNo(parentNode.getNewOrderNo(connector));
        MtdEngine.checkNodeRecord(this.record);
        Node node = MtdCache.createNodeInstance(this.record);
        if (!this.record.isAttributesEmpty()) {
            node.load(null, this.record.createAttributesReader());
        }
        Node.CreationArg arg = new Node.CreationArg();
        arg.clone = true;
        arg.identifier = node.getIdentName();
        arg.name = node.getName();
        arg.refNodeId = node.getRefNodeId();
        node.afterCreateNew(arg);
        this.dependencies = new Dependencies();
        this.dependencies.add(new NodeCopy(sourceNode.getId(), node, content, dslContent));
        if (withChildren) {
            this.copyChildren(node, sourceNode.getChildren(connector), connector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyChildren(Node parentNode, double[] children, Connector connector) throws InformException, SQLException {
        for (double childId : children) {
            String dslContent;
            byte[] content;
            Node child = MtdEngine.getNode(childId);
            if (child == null) continue;
            this.record.clear();
            try (ClosableResult closableResult = MetadataNodeReader.getHistoryEntryResultSet(null, childId, 0.0, connector.connection());){
                if (closableResult == null) {
                    return;
                }
                ResultSet resultSet = closableResult.getResultSet();
                MetadataNodeReader.loadNodeRecord(resultSet, this.record);
                this.record.setCreationTime(this.time);
                this.record.setModificationAttributeTime(this.time);
                this.record.setSessionId(this.getSessionID());
                this.record.setModificationUserId(this.getUserID());
                content = resultSet.getBlobBytes(resultSet.findColumn("RAW_CONTENT"));
                dslContent = resultSet.getString(resultSet.findColumn("DSL_CONTENT"));
            }
            this.record.setCreationTime(this.time);
            this.record.setModificationAttributeTime(this.time);
            this.record.setSessionId(this.getSessionID());
            this.record.setModificationUserId(this.getUserID());
            this.record.setId(Core.generateId());
            this.record.setParentId(parentNode.getId());
            MtdEngine.checkNodeRecord(this.record);
            Node node = MtdCache.createNodeInstance(this.record);
            if (!this.record.isAttributesEmpty()) {
                node.load(null, this.record.createAttributesReader());
            }
            Node.CreationArg arg = new Node.CreationArg();
            arg.identifier = node.getIdentName();
            arg.name = node.getName();
            arg.refNodeId = node.getRefNodeId();
            node.afterCreateNew(arg);
            this.dependencies.add(new NodeCopy(childId, node, content, dslContent));
            this.copyChildren(node, child.getChildren(connector), connector);
        }
    }

    private static class Dependencies
    extends DoubleHash<NodeCopy>
    implements Correlations {
        private Dependencies() {
        }

        @Override
        public double getCorrelation(double key) {
            NodeCopy nodeCopy = (NodeCopy)this.get(key);
            if (nodeCopy == null) {
                return key;
            }
            return nodeCopy.node.getId();
        }
    }

    private static class NodeCopy
    implements DoubleHash.Entry {
        final double sourceId;
        Node node;
        byte[] content;
        String dslContent;

        public NodeCopy(double sourceId, Node node, byte[] content, String dslContent) {
            this.sourceId = sourceId;
            this.node = node;
            this.content = content;
            this.dslContent = dslContent;
        }

        @Override
        public double key() {
            return this.sourceId;
        }
    }
}

