/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.InformException;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.connect.Connector;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.UserRole;
import inform.common.Empty;
import java.util.Arrays;

public class EmptyTrash
extends Request {
    private static final String selectSql = "select ID from %s where PARENT_ID = ? and OWNER_ID = ?";
    private static final String restoreSql = "update %s set PARENT_ID = ? where ID = ?";
    private static final String deleteSql = "delete from %s where ID = ?";

    public EmptyTrash(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    private static int nodeTypeByNodeId(double nodeId) throws InformException {
        Node node = MtdEngine.getNode(nodeId);
        return node != null ? node.getType() : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static double[] getTrashedNodeIdsForCurrentUser(DatabaseConnection connection, double user_id) throws Throwable {
        try (PreparedStatement ps = connection.prepareStatement(String.format(selectSql, MetadataNodeReader.mtdTreeTableName));){
            int count;
            double[] ids;
            ResultSet rs;
            block13: {
                block12: {
                    double[] dArray;
                    ps.setDouble(1, 1.0);
                    ps.setDouble(2, user_id);
                    rs = ps.executeQuery(null);
                    try {
                        ids = new double[32];
                        count = 0;
                        while (rs.next()) {
                            if (count >= ids.length) {
                                ids = Arrays.copyOf(ids, ids.length + 32);
                            }
                            ids[count++] = rs.getDouble(1);
                        }
                        if (count != 0) break block12;
                        dArray = Empty.doubleArray;
                    }
                    catch (Throwable throwable) {
                        rs.close();
                        throw throwable;
                    }
                    rs.close();
                    return dArray;
                }
                if (count != ids.length) break block13;
                double[] dArray = ids;
                rs.close();
                return dArray;
            }
            double[] dArray = Arrays.copyOf(ids, count);
            rs.close();
            return dArray;
        }
    }

    private static double[] getTrashedNodeIdsWithChilds(DatabaseConnection connection, double[] NodeIds) throws Throwable {
        double[] result = Arrays.copyOf(NodeIds, NodeIds.length);
        int limit = result.length;
        while (limit > 0) {
            int offset = 0;
            for (int i = 0; i < limit; ++i) {
                double[] childIds = MetadataNodeReader.getNodeChildrenIds(null, connection, result[i + offset]);
                if (childIds.length == 0) continue;
                double[] newNodeIds = new double[result.length + childIds.length];
                System.arraycopy(childIds, 0, newNodeIds, 0, childIds.length);
                System.arraycopy(result, 0, newNodeIds, childIds.length, result.length);
                offset += childIds.length;
                result = newNodeIds;
            }
            limit = offset;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeInStatement(DatabaseConnection connection, String statementSql, ExecuteInStatement executor) throws Throwable {
        try (PreparedStatement ps = connection.prepareStatement(String.format(statementSql, MetadataNodeReader.mtdTreeTableName));){
            executor.execute(ps);
        }
    }

    private static void executeInConnector(Connector connector, ExecuteInConnection executor) throws Throwable {
        executor.execute(connector.connection());
        connector.commit();
    }

    public static void EmptySingleNode(final Request req, Connector connector, final double nodeId) throws Throwable {
        EmptyTrash.executeInConnector(connector, new ExecuteInConnection(){

            @Override
            public void execute(final DatabaseConnection connection) throws Throwable {
                EmptyTrash.executeInStatement(connection, EmptyTrash.restoreSql, new ExecuteInStatement(){

                    @Override
                    public void execute(PreparedStatement ps) throws Throwable {
                        ps.setDouble(1, MtdEngine.getValidNode(nodeId).getUndeletePatentId());
                        ps.setDouble(2, nodeId);
                        ps.executeUpdate(null);
                    }
                });
                double[] node_ar = new double[]{nodeId};
                final double[] allTrashedNodeIds = EmptyTrash.getTrashedNodeIdsWithChilds(connection, node_ar);
                EmptyTrash.executeInStatement(connection, EmptyTrash.deleteSql, new ExecuteInStatement(){

                    @Override
                    public void execute(PreparedStatement ps) throws Throwable {
                        for (double node_id : allTrashedNodeIds) {
                            ps.setDouble(1, node_id);
                            MtdEngine.registerMtdOperation(null, connection, node_id, req.getUserID(), req.getSessionID(), null, 3, true, EmptyTrash.nodeTypeByNodeId(node_id));
                            ps.executeUpdate(null);
                        }
                    }
                });
                EmptyTrash.executeInStatement(connection, EmptyTrash.deleteSql, new ExecuteInStatement(){

                    @Override
                    public void execute(PreparedStatement ps) throws Throwable {
                        ps.setDouble(1, nodeId);
                        MtdEngine.registerMtdOperation(null, connection, nodeId, req.getUserID(), req.getSessionID(), null, 3, true, EmptyTrash.nodeTypeByNodeId(nodeId));
                        ps.executeUpdate(null);
                    }
                });
            }
        });
    }

    @Override
    public void execute() throws Throwable {
        if (Ini.ReadonlyMode) {
            this.sendError("\u0410\u0433\u0435\u043d\u0442 \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f!", "");
            return;
        }
        try (Connector.Metabase connector = new Connector.Metabase();){
            EmptyTrash.executeInConnector(connector, new ExecuteInConnection(){

                @Override
                public void execute(final DatabaseConnection connection) throws Throwable {
                    final double[] rootTrashedNodeIds = EmptyTrash.this.security().role() == UserRole.ADMIN ? MetadataNodeReader.getNodeChildrenIds(null, connection, 1.0) : EmptyTrash.getTrashedNodeIdsForCurrentUser(connection, EmptyTrash.this.getUserID());
                    final double[] allTrashedNodeIds = EmptyTrash.getTrashedNodeIdsWithChilds(connection, rootTrashedNodeIds);
                    EmptyTrash.executeInStatement(connection, EmptyTrash.restoreSql, new ExecuteInStatement(){

                        @Override
                        public void execute(PreparedStatement ps) throws Throwable {
                            for (double nodeId : rootTrashedNodeIds) {
                                ps.setDouble(1, MtdEngine.getValidNode(nodeId).getUndeletePatentId());
                                ps.setDouble(2, nodeId);
                                ps.executeUpdate(null);
                            }
                        }
                    });
                    EmptyTrash.executeInStatement(connection, EmptyTrash.deleteSql, new ExecuteInStatement(){

                        @Override
                        public void execute(PreparedStatement ps) throws Throwable {
                            for (double nodeId : allTrashedNodeIds) {
                                ps.setDouble(1, nodeId);
                                MtdEngine.registerMtdOperation(null, connection, nodeId, EmptyTrash.this.getUserID(), EmptyTrash.this.getSessionID(), null, 3, true, EmptyTrash.nodeTypeByNodeId(nodeId));
                                ps.executeUpdate(null);
                            }
                        }
                    });
                }
            });
        }
        MtdEngine.getValidNode(1.0).dropChildrenCache();
        this.sendResult();
    }

    private static interface ExecuteInConnection {
        public void execute(DatabaseConnection var1) throws Throwable;
    }

    private static interface ExecuteInStatement {
        public void execute(PreparedStatement var1) throws Throwable;
    }
}

