/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.AccountNode;
import inform.agent.mtd.nodes.Node;

public class GetAccountNode
extends Request {
    private static final int TAG_GET_USER_NODE_NEED_HASH = 1;
    private static final int TAG_GET_USER_NODE_NEED_METADATANODE = 2;
    private static final int TAG_GET_USER_NODE_REQUESTING_PARENT = 3;

    public GetAccountNode(RequestHeader rq) {
        super(rq, RequestDuration.SHORT);
    }

    @Override
    public void execute() throws Throwable {
        AccountNode account;
        TaggedReader in = this.createRequestContentReader();
        boolean needHash = false;
        boolean needMetadata = false;
        boolean requestingParent = false;
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    needHash = true;
                    needMetadata = true;
                    break;
                }
                case 2: {
                    needMetadata = true;
                    break;
                }
                case 3: {
                    requestingParent = true;
                    needMetadata = true;
                }
            }
        }
        if (requestingParent) {
            Node node = MtdEngine.getNode(this.getNodeID());
            if (node == null || !(node instanceof AccountNode)) {
                this.sendResult();
                return;
            }
            account = (AccountNode)node;
        } else {
            account = needMetadata ? MtdEngine.getValidAccountMetadataNode(this.getNodeID()) : MtdEngine.getValidAccountNode(this.getNodeID());
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        out.putRaw(84, account.getInheritedActualConstants());
        out.putAnsi(4, account.getName());
        account.getAccountInfo(out, needHash);
        out.putRaw(83, account.findStartup());
        out.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }
}

