/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.DateTime;
import inform.adt.LittleEndian;
import inform.adt.collections.Cursor;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.DoubleList;
import inform.adt.collections.DoubleSet;
import inform.adt.collections.IntHashMap;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.ClosableResult;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.Connector;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.utils.SqlParameter;
import inform.agent.mtd.AccessMask;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.UsersTable;
import inform.agent.mtd.nodes.AccountNode;
import inform.agent.mtd.nodes.GroupNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.NodeHashTable;
import inform.agent.mtd.nodes.UserNode;
import inform.agent.mtd.nodes.VirtualUser;
import java.util.ArrayList;
import java.util.BitSet;

public class GetAccountNodeInfo
extends Request {
    private static final int GETUSERNODEINFO_OPTIONS_EXPLICIT_GROUPS = 1;
    private static final int GETUSERNODEINFO_OPTIONS_ALL_GROUPS = 2;
    private static final int GETUSERNODEINFO_OPTIONS_PARENT_GROUPS = 4;
    private static final int GETUSERNODEINFO_OPTIONS_HAS_PASSWORD = 8;
    private static final int GETUSERNODEINFO_OPTIONS_IDM_USERS = 16;
    private static final int GETUSERNODEINFO_OPTIONS_IDM_USERS_WITH_NAME = 32;
    private static final int GETUSERNODEINFO_OPTIONS_IDM_USER_LIST = 64;
    private static final int GETUSERNODEINFO_OPTIONS_IDM_DELETE = 128;
    private static final int GETUSERNODEINFO_OPTIONS_IDM_UNDELETE = 256;
    private static final int TAG_GETUSERNODEINFO_OPTIONS = 1;
    private static final int TAG_GETUSERNODEINFO_GET_ROLE_PATH = 2;
    private static final int TAG_GETUSERNODEINFO_ROLE = 3;
    private static final int TAG_GETUSERNODEINFO_NAME = 4;
    private static final int TAG_GETUSERNODEINFO_GET_DELETED = 5;
    private static final int TAG_GETUSERNODEINFO_FILTER_FIELD = 6;
    private static final int TAG_GETUSERNODEINFO_FILTER_VAL_NUMBER = 7;
    private static final int TAG_GETUSERNODEINFO_FILTER_VAL_STRING = 8;
    private static final int TAG_GETUSERNODEINFO_FILTER_VAL_BOOL = 9;
    private static final int TAG_GETUSERNODEINFO_FILTER_VAL_DATE = 10;

    public GetAccountNodeInfo(RequestHeader rq) {
        super(rq, RequestDuration.SHORT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        UserNode userNode;
        double[] groups;
        CalcTree tree;
        CalcNode calcNode;
        Node node;
        UsersTable ut = null;
        TableDescriptor table = null;
        if (MtdEngine.serverNode().descriptor().useUsersTable) {
            ut = new UsersTable();
            if (ut.enabled()) {
                table = ut.table();
            } else {
                ut = null;
            }
        }
        TaggedReader in = this.createRequestContentReader();
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        double nodeId = this.getTranslatedNodeID();
        int options = 0;
        double[] calcGroups = null;
        double role = 0.0;
        String name = null;
        boolean getDeletedUsers = false;
        IntHashMap<SqlParameter> fieldFilter = null;
        int fieldId = 0;
        SqlParameter parameter = null;
        while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 1: {
                    options = in.getInt();
                    break;
                }
                case 2: {
                    calcGroups = LittleEndian.toDoubleArray(in.getRaw());
                    break;
                }
                case 3: {
                    role = in.getDouble();
                    break;
                }
                case 4: {
                    name = in.getString();
                    break;
                }
                case 5: {
                    getDeletedUsers = true;
                    break;
                }
                case 6: {
                    if (table == null) break;
                    if (fieldFilter == null) {
                        fieldFilter = new IntHashMap<SqlParameter>();
                    }
                    if (fieldFilter.contains(fieldId = in.getInt())) break;
                    FieldDescriptor field = table.getExistingFieldDescriptor(fieldId);
                    parameter = new SqlParameter(field.getType().toSqlDataType());
                    parameter.setId(fieldId);
                    parameter.setNull();
                    fieldFilter.put(fieldId, parameter);
                    break;
                }
                case 7: {
                    if (parameter == null) break;
                    parameter.setDouble(in.getDouble());
                    break;
                }
                case 8: {
                    if (parameter == null) break;
                    parameter.setString(in.getString());
                    break;
                }
                case 9: {
                    if (parameter == null) break;
                    parameter.setBoolean(in.getBoolean());
                    break;
                }
                case 10: {
                    if (parameter == null) break;
                    parameter.setDateTime(DateTime.toServerTime(in.getDouble(), this));
                }
            }
        }
        if ((options & 0x20) != 0) {
            ClosableResult r;
            boolean usersFound = false;
            if (ut != null && (r = ut.selectAll(this.ssContext, name)) != null) {
                try {
                    ResultSet rs = r.getResultSet();
                    while (rs.next()) {
                        SqlParameter[] fields = ut.getValues(rs);
                        out.putDouble(1, fields[0].getDouble());
                        usersFound = true;
                    }
                }
                finally {
                    r.close();
                }
            }
            if (!usersFound) {
                DoubleHash<AccountNode> users = MtdEngine.getAccountsWithName(name);
                if (users == null) {
                    this.sendResult();
                    return;
                }
                for (AccountNode user : users) {
                    if (user.getType() != 3) continue;
                    out.putDouble(1, user.getId());
                }
            }
            out.flush();
            this.sendResult(result.internalBuffer(), result.size());
            return;
        }
        if ((options & 0x10) != 0) {
            UserNode user;
            if (name != null && (user = MtdEngine.getUserNodeByName(name)) != null) {
                try (Connector.Metabase connector = new Connector.Metabase();){
                    Node.NodeInfoArg arg = new Node.NodeInfoArg(connector, this.security(), null, out);
                    arg.options = options;
                    user.getNodeInfo(arg);
                }
            }
            if (ut != null) {
                ClosableResult r = ut.selectByGroup(this.ssContext, role);
                if (r == null) {
                    return;
                }
                try {
                    ResultSet rs = r.getResultSet();
                    while (rs.next()) {
                        VirtualUser user2 = VirtualUser.loadTempUser(ut.getValues(rs));
                        out.putDouble(1, user2.getId());
                        out.putString(4, user2.getName());
                        if (role != 0.0) {
                            out.putDouble(3, role);
                        }
                        out.putInt32(2, 3);
                        out.putRaw(42, user2.props().getVirtualUserProps());
                        out.putBool(82, user2.isActiveDirectoryAuthorization());
                        out.putBool(52, user2.isBlocked());
                    }
                }
                finally {
                    r.close();
                }
            }
            node = MtdEngine.getNode(nodeId);
            if (node != null) {
                double userId = this.getUserID();
                try (Connector.Metabase connection = new Connector.Metabase("rq:GetAccountNodeInfo");){
                    double[] children;
                    BitSet nodeTypeFilter = new BitSet();
                    nodeTypeFilter.set(3);
                    Node.NodeInfoArg arg = new Node.NodeInfoArg(connection, this.security(), nodeTypeFilter, out);
                    for (double childId : children = node.getChildren(connection, nodeTypeFilter)) {
                        Node childNode = MtdEngine.getNode(childId);
                        if (childNode == null) continue;
                        int accessMask = this.security().accessMask(childNode);
                        if (childNode.getOwnerId() != userId && AccessMask.accessDenied(Integer.MIN_VALUE, accessMask)) continue;
                        node.getChildInfo(childNode, arg);
                    }
                    connection.commit();
                }
            }
            out.flush();
            this.sendResult(result.internalBuffer(), result.size());
            return;
        }
        if ((options & 0x40) != 0) {
            if (ut == null) {
                this.sendResult();
                return;
            }
            DoubleSet users = new DoubleSet();
            ut.selectFiltered(this.ssContext, users, getDeletedUsers, fieldFilter);
            for (Cursor.Double user : users) {
                out.putDouble(1, user.value);
            }
            out.flush();
            this.sendResult(result.internalBuffer(), result.size());
            return;
        }
        if ((options & 0x80) != 0) {
            if (ut != null) {
                ut.markDelete(this.ssContext, this, nodeId, true);
            }
            this.sendResult();
            return;
        }
        if ((options & 0x100) != 0) {
            if (ut != null) {
                ut.markDelete(this.ssContext, this, nodeId, false);
            }
            this.sendResult();
            return;
        }
        node = MtdEngine.getValidAccountNode(nodeId);
        if (calcGroups != null && calcGroups.length != 0 && (calcNode = (tree = new CalcTree()).calc(role, calcGroups)) != null) {
            DoubleList list = new DoubleList(4);
            calcNode.getNodePath(list);
            out.putRaw(15, LittleEndian.doubleArrayToBinary(list.toArray()));
        }
        if ((options & 2) != 0) {
            groups = ((AccountNode)node).effectiveGroups();
            if (groups != null && groups.length > 0) {
                out.putRaw(34, LittleEndian.doubleArrayToBinary(groups));
            }
        } else if ((options & 1) != 0) {
            groups = ((AccountNode)node).explicitGroups();
            if (groups != null && groups.length > 0) {
                out.putRaw(34, LittleEndian.doubleArrayToBinary(groups));
            }
        } else if ((options & 4) != 0) {
            groups = ((AccountNode)node).parentGroups();
            if (groups != null && groups.length > 0) {
                out.putRaw(34, LittleEndian.doubleArrayToBinary(groups));
            }
        } else if ((options & 8) != 0 && node.getType() == 3 && !(userNode = (UserNode)node).checkPassword("")) {
            out.putEmpty(55);
        }
        if (node.getType() == 3) {
            userNode = (UserNode)node;
            out.putInt32(38, userNode.getRole().toInt());
        }
        out.putBool(52, ((AccountNode)node).isBlocked());
        if (node.isInTrashRecursive()) {
            out.putEmpty(66);
        }
        out.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }

    public static double[] calcEffectiveRoles(double[] parents, double[] roles) {
        DoubleSet effective = new DoubleSet();
        if (parents != null && parents.length != 0) {
            GetAccountNodeInfo.calcEffective(parents, effective);
        }
        if (roles != null && roles.length != 0) {
            GetAccountNodeInfo.calcEffective(roles, effective);
        }
        return effective.toArray();
    }

    static void calcEffective(NodeHashTable nht, double[] groups, DoubleSet effective) {
        for (double g : groups) {
            AccountNode account;
            if (effective.contains(g) || (account = nht.getAccount(g)) == null || account.isInTrashRecursive() || !(account instanceof GroupNode)) continue;
            effective.add(account.getId());
            double[] accountGroups = account.parentGroups();
            GetAccountNodeInfo.calcEffective(nht, accountGroups, effective);
            accountGroups = account.explicitGroups();
            GetAccountNodeInfo.calcEffective(nht, accountGroups, effective);
        }
    }

    static void calcEffective(double[] groups, DoubleSet effective) {
        NodeHashTable nht = MtdEngine.getMtdCache().getNodes();
        for (double g : groups) {
            double[] accountGroups;
            AccountNode account = nht.getAccount(g);
            if (account == null || account.isInTrashRecursive() || !(account instanceof GroupNode)) continue;
            effective.add(g);
            for (double e : accountGroups = account.effectiveGroups()) {
                effective.add(e);
            }
        }
    }

    static class CalcTree {
        final ArrayList<CalcNode> nodes = new ArrayList();
        final DoubleSet loaded = new DoubleSet();
        final NodeHashTable nht = MtdEngine.getMtdCache().getNodes();

        CalcTree() {
        }

        CalcNode calc(double nodeId, double[] groups) {
            for (double g : groups) {
                AccountNode account;
                if (this.loaded.contains(g) || (account = this.nht.getAccount(g)) == null || account.isInTrashRecursive() || !(account instanceof GroupNode)) continue;
                CalcNode node = new CalcNode(account, null, g, this);
                if (g == nodeId) {
                    return node;
                }
                this.nodes.add(node);
                this.loaded.add(g);
                node = node.calc(nodeId);
                if (node == null) continue;
                return node;
            }
            return null;
        }
    }

    static class CalcNode {
        final AccountNode account;
        final CalcNode parent;
        final double nodeId;
        final CalcTree tree;
        final ArrayList<CalcNode> nodes = new ArrayList();

        CalcNode(AccountNode account, CalcNode parent, double nodeId, CalcTree tree) {
            this.account = account;
            this.parent = parent;
            this.nodeId = nodeId;
            this.tree = tree;
        }

        CalcNode calc(double nodeId, double[] groups) {
            for (double g : groups) {
                AccountNode accountNode;
                if (this.tree.loaded.contains(g) || (accountNode = this.tree.nht.getAccount(g)) == null || accountNode.isInTrashRecursive() || !(accountNode instanceof GroupNode)) continue;
                CalcNode node = new CalcNode(accountNode, this, g, this.tree);
                if (g == nodeId) {
                    return node;
                }
                this.nodes.add(node);
                this.tree.loaded.add(g);
                node = node.calc(nodeId);
                if (node == null) continue;
                return node;
            }
            return null;
        }

        CalcNode calc(double nodeId) {
            double[] groups = this.account.parentGroups();
            CalcNode node = this.calc(nodeId, groups);
            if (node != null) {
                return node;
            }
            groups = this.account.explicitGroups();
            node = this.calc(nodeId, groups);
            return node;
        }

        void getNodePath(DoubleList path) {
            if (this.parent != null) {
                this.parent.getNodePath(path);
            }
            path.add(this.nodeId);
        }
    }
}

