/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.mtd.Acl;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.AccountNode;
import inform.agent.net.Security;

public class GetAccountPermissions
extends Request {
    public GetAccountPermissions(RequestHeader rq) {
        super(rq, RequestDuration.SHORT);
    }

    @Override
    public void execute() throws Throwable {
        TaggedReader in = this.createRequestContentReader();
        Acl acl = new Acl();
        double accountId = 0.0;
        while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 154: {
                    acl.load(in);
                    break;
                }
                case 1: {
                    accountId = in.getDouble();
                }
            }
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        if (accountId == 0.0 || accountId == -1.0) {
            out.putInt32(156, 0);
        } else {
            AccountNode account = MtdEngine.getValidAccountNode(accountId);
            out.putInt32(156, Security.calculateAccessMask(acl, accountId, account.effectiveGroups()));
        }
        out.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }
}

