/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.mtd.AuditJournal;
import java.util.ArrayList;

public class GetAuditReplications
extends Request {
    private static final int TAG_AREPLICATIONS_CODE = 1;
    private static final int TAG_AREPLICATIONS_NUM_RECS = 2;
    private static final int TAG_AREPLICATIONS_PAR_SUCCESSFUL = 3;
    private static final int TAG_AREPLICATIONS_PAR_BEGIN_TIME = 4;
    private static final int TAG_AREPLICATIONS_PAR_END_TIME = 5;
    private static final int TAG_AREPLICATIONS_PAR_FILEID = 6;
    private static final int TAG_AREPLICATIONS_PAR_RESULT_MSG = 7;
    private static final int TAG_AREPLICATIONS_PAR_SLICE_BEGIN_TIME = 8;
    private static final int TAG_AREPLICATIONS_PAR_SLICE_END_TIME = 9;
    private static final int TAG_AREPLICATIONS_PAR_FILE_SIZE = 10;
    private static final int TAG_AREPLICATIONS_PAR_FILE_NAME = 11;
    private static final int TAG_AREPLICATIONS_PAR_NOTE = 12;
    private static final int TAG_AREPLICATIONS_PAR_USER_NODE = 13;
    private static final int TAG_AREPLICATIONS_PAR_REPL_NODE = 14;
    private static final int TAG_AREPLICATIONS_PAR_CHANNEL = 15;
    private static final int TAG_AREPLICATIONS_PAR_OP_CODE = 16;

    public GetAuditReplications(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    @Override
    public void execute() throws Throwable {
        Object startDate = null;
        Object endDate = null;
        int numRec = 0;
        int code = 0;
        TaggedReader reader = this.createRequestContentReader();
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    code = reader.getInt();
                    break;
                }
                case 2: {
                    numRec = reader.getInt();
                }
            }
        }
        AuditJournal journal = new AuditJournal(AuditJournal.Journal.REPLICATION);
        ArrayList<AuditJournal.ReplicationParams> paramsList = journal.getAuditReplications(this.ssContext, numRec, code);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        for (AuditJournal.ReplicationParams p : paramsList) {
            ByteArrayOutputStream paramResult = new ByteArrayOutputStream();
            TaggedWriter paramOut = new TaggedWriter(paramResult);
            paramOut.putBool(3, p.successfullyResult);
            paramOut.putDouble(4, p.timeBeginOperation);
            paramOut.putDouble(5, p.timeEndOperation);
            paramOut.putDouble(6, p.replicaId);
            paramOut.putString(7, p.resultMessage);
            paramOut.putDouble(8, p.dataSliceBegin);
            paramOut.putDouble(9, p.dataSliceEnd);
            paramOut.putDouble(10, p.replicaSize);
            paramOut.putString(11, p.fileName);
            paramOut.putString(12, p.note);
            paramOut.putDouble(13, p.userNodeId);
            paramOut.putDouble(14, p.replNodeId);
            paramOut.putDouble(15, p.channelId);
            paramOut.putInt32(16, p.opCode);
            paramOut.flush();
            out.putRaw(202, paramResult);
        }
        out.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }
}

