/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.obj.DForm;
import inform.agent.mtd.obj.DItem;
import inform.agent.mtd.obj.DPropertyEnum;

public class GetDSLPresentation
extends Request {
    public static final int TAG_GET_DSL_PRESENTATION_PIN_ID = 1;

    public GetDSLPresentation(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    @Override
    public void execute() throws Throwable {
        double nodeId = this.getTranslatedNodeID();
        BasicNode node = MtdEngine.getValidNode(nodeId).getRealNode();
        if (node.getType() != 11) {
            StringBuilder detail = new StringBuilder();
            MtdEngine.appendNodeNameForLog(detail, nodeId);
            detail.append("\n\u0422\u0438\u043f \u0443\u0437\u043b\u0430 ").append(DPropertyEnum.mapValue(node.getType(), DItem.NODE_TYPE_VALUES, DItem.NODE_TYPE_TITLES));
            throw new InformException("DSL \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430 \u0443\u0437\u043b\u0430").detail(detail.toString());
        }
        double pinId = 0.0;
        TaggedReader in = this.createRequestContentReader();
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    pinId = in.getDouble();
                }
            }
        }
        BasicNode.NodeContent nodeContent = node.getNodeContent(pinId, pinId == 0.0);
        if (nodeContent.dslContent != null) {
            this.sendResult(nodeContent.dslContent.toString().getBytes(TaggedWriter.UTF8));
        } else {
            byte[] content = nodeContent.content;
            DForm form = new DForm();
            form.loadTaggedContent(new TaggedReader(content));
            StringBuilder textContent = new StringBuilder();
            form.storeTextContent(0, textContent, 0, false);
            textContent.toString();
            this.sendResult(textContent.toString().getBytes(TaggedWriter.UTF8));
        }
    }
}

