/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.collections.DoubleHash;
import inform.adt.collections.DoubleSet;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderSizeOverflowException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.NodeHashTable;
import inform.agent.mtd.request.NodeDependeceEngine;
import inform.common.Empty;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;

public class GetGlobalDependency
extends Request {
    private static final int CONTENT_RECORDS_PREFETCH = 1000;
    private int progress = 0;

    public GetGlobalDependency(RequestHeader rq) {
        super(rq, RequestDuration.COMPLEX);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void execute() throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void appendWhere(StringBuilder sql, int[] types) {
        if (types == null) {
            return;
        }
        if (types.length == 0) {
            return;
        }
        sql.append(" where ").append("NODE_TYPE").append(" in (");
        int l = types.length;
        for (int i = 0; i != l; ++i) {
            if (i != 0) {
                sql.append(',');
            }
            sql.append('?');
        }
        sql.append(')');
    }

    private static void setWhereParams(StringBuilder sql, int[] types, PreparedStatement ps) throws SQLException {
        if (types == null) {
            return;
        }
        int l = types.length;
        for (int i = 0; i != l; ++i) {
            ps.setInt(i + 1, types[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processNext(DoubleHash<NodeRefsSet> nodes, DatabaseConnection connection, NodeHashTable cache, TaggedWriter out) throws SQLException, IOException {
        StringBuilder sql = new StringBuilder();
        sql.append("select ").append("ID").append(',').append("MOD_CONTENT_TIME").append(',').append("RAW_CONTENT").append(',').append("DSL_CONTENT").append(" from ").append(MetadataNodeReader.mtdTreeTableName).append(" where ").append("ID").append(" in (");
        int l = nodes.size();
        for (int i = 0; i != l; ++i) {
            if (i != 0) {
                sql.append(',');
            }
            sql.append('?');
        }
        sql.append(')');
        try (PreparedStatement ps = connection.prepareStatement("rqGetGlobalDependency.next", sql.toString());){
            int idx = 0;
            for (NodeRefsSet n : nodes) {
                ps.setDouble(++idx, n.nodeId);
            }
            try (ResultSet rs = ps.executeQuery(this.ssContext);){
                int colId = rs.findColumn("ID");
                int colModTime = rs.findColumn("MOD_CONTENT_TIME");
                int colContent = rs.findColumn("RAW_CONTENT");
                int colDslContent = rs.findColumn("DSL_CONTENT");
                while (rs.next()) {
                    this.idle();
                    double id = rs.getDouble(colId);
                    try {
                        NodeRefsSet n;
                        Timestamp time = rs.getTimestamp(colModTime);
                        long mtime = time == null ? 0L : time.getTime();
                        byte[] content = rs.getBlobBytes(colContent);
                        String dslContent = rs.getString(colDslContent);
                        if (content == null || content.length == 0 || (n = nodes.get(id)) == null) continue;
                        Node node = cache.get(id);
                        if (node instanceof BasicNode) {
                            double[] deps = Empty.doubleArray;
                            try {
                                deps = ((BasicNode)node).findAndCacheRefs(mtime, content, dslContent);
                            }
                            catch (TaggedReaderSizeOverflowException ex) {
                                String msg = ex.getMessage() + ":\n\u0443\u0437\u0435\u043b \u0441 \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u043c \u0442\u0435\u0433\u043e\u0432\u044b\u043c \u043f\u043e\u0442\u043e\u043a\u043e\u043c " + id;
                                Core.logger.error(msg);
                            }
                            for (double d : deps) {
                                n.set.add(d);
                            }
                        } else {
                            try {
                                NodeDependeceEngine.parseContentForDependencies(new TaggedReader(content), n.set);
                            }
                            catch (TaggedReaderSizeOverflowException ex) {
                                String msg = ex.getMessage() + ":\n\u0443\u0437\u0435\u043b \u0441 \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u043c \u0442\u0435\u0433\u043e\u0432\u044b\u043c \u043f\u043e\u0442\u043e\u043a\u043e\u043c " + id;
                                Core.logger.error(msg);
                            }
                        }
                        this.putRequestStateProgressPosition(++this.progress);
                        GetGlobalDependency.writeResultPart(out, id, n.set);
                    }
                    catch (Throwable ex) {
                        throw InformException.detail(InformException.wrap(ex, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u044f \u0432\u0437\u0430\u0438\u043c\u043e\u0441\u0432\u044f\u0437\u0435\u0439 \u0443\u0437\u043e\u0432"), "\u0443\u0437\u0435\u043b: " + (long)id);
                        return;
                    }
                }
            }
        }
    }

    private static void writeResultPart(TaggedWriter out, double nodeId, DoubleSet set) throws IOException {
        out.putDouble(5, nodeId);
        out.putRaw(2, LittleEndian.doubleArrayToBinary(set.toArray()));
    }

    private static class NodeRefsSet
    implements DoubleHash.Entry {
        final double nodeId;
        final DoubleSet set;

        NodeRefsSet(double nodeId, DoubleSet set) {
            this.nodeId = nodeId;
            this.set = set;
        }

        @Override
        public double key() {
            return this.nodeId;
        }
    }
}

