/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.db.connect.Connector;
import inform.agent.mtd.AccessMask;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.VirtualUser;
import java.util.ArrayList;
import java.util.BitSet;

public class GetNodeChildrenInfo
extends Request {
    public GetNodeChildrenInfo(RequestHeader rq) {
        super(rq, RequestDuration.SHORT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        double nodeId = this.getTranslatedNodeID();
        boolean enumConf = false;
        BitSet nodeTypeFilter = null;
        TaggedReader in = this.createRequestContentReader();
        block7: while (in.getNextTag() != 0) {
            switch (in.getCurrentTag()) {
                case 3: {
                    int[] types;
                    nodeTypeFilter = new BitSet();
                    for (int typeId : types = LittleEndian.toIntArray(in.getRaw())) {
                        nodeTypeFilter.set(typeId);
                    }
                    if (!nodeTypeFilter.isEmpty()) continue block7;
                    nodeTypeFilter = null;
                    break;
                }
                case 6: {
                    enumConf = true;
                }
            }
        }
        Node node = null;
        if (!enumConf) {
            if (this.getNodeID() == 0.0) {
                node = MtdEngine.getNode(nodeId);
                if (node == null) {
                    throw new InformException("\u041a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u0443\u0437\u0435\u043b \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                }
            } else {
                node = MtdEngine.getNode(nodeId);
                if (node == null && MtdEngine.serverNode().descriptor().useUsersTable) {
                    node = VirtualUser.getUser(nodeId);
                }
                if (node == null) {
                    MtdEngine.throwError(nodeId, "\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                }
            }
        }
        double userId = this.getUserID();
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        try (Connector.Metabase connection = new Connector.Metabase("rq:GetNodeChildrenInfo");){
            connection.markAsReadonly();
            if (enumConf) {
                ArrayList<MetadataNodeReader.ConfNode> conf = MetadataNodeReader.ConfNode.selectUserConf(userId, connection.connection());
                String prevName = null;
                for (MetadataNodeReader.ConfNode c : conf) {
                    if (c.name.equals(prevName)) continue;
                    out.putDouble(1, c.id);
                    out.putAnsi(4, c.name);
                    prevName = c.name;
                }
            } else {
                double[] children;
                if (nodeTypeFilter != null && this.getRootNodeID() != 0.0 && !nodeTypeFilter.get(2)) {
                    nodeTypeFilter.set(2);
                }
                Node.NodeInfoArg arg = new Node.NodeInfoArg(connection, this.security(), nodeTypeFilter, out);
                for (double childId : children = node.getChildren(connection, nodeTypeFilter)) {
                    int accessMask;
                    Node childNode = MtdEngine.getNode(childId);
                    if (childNode == null || AccessMask.accessDenied(Integer.MIN_VALUE, accessMask = this.security().accessMask(childNode))) continue;
                    node.getChildInfo(childNode, arg);
                }
            }
            connection.commit();
        }
        out.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }
}

