/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.collections.DoubleList;
import inform.adt.collections.IntegerList;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.nodes.UserRole;
import inform.agent.net.Security;
import java.sql.Timestamp;
import java.util.ArrayList;

public class GetNodeHistory
extends Request {
    public static final int TAG_NHISTORY_DATE = 1;
    public static final int TAG_NHISTORY_USER = 2;
    public static final int TAG_NHISTORY_OPERATION = 3;
    public static final int TAG_NHISTORY_ENTRY_ID = 4;
    public static final int TAG_NHISTORY_START_DATE = 5;
    public static final int TAG_NHISTORY_END_DATE = 6;
    public static final int TAG_NHISTORY_NODE_ID = 7;
    public static final int TAG_NHISTORY_NODE_TYPE = 8;
    public static final int TAG_NHISTORY_NODE_NAME = 9;
    public static final int TAG_NHISTORY_INCLUDE_ATTRS_CHANGE = 10;
    public static final int TAG_NHISTORY_NUM_RECS = 11;
    public static final int TAG_NHISTORY_USER_ID = 12;
    public static final int TAG_NHISTORY_PARENT_ID = 13;
    public static final int TAG_NHISTORY_ENTRY_COMMENT = 14;
    public static final int TAG_NHISTORY_IN_USERS_VIEW = 15;
    public static final int TAG_NHISTORY_REPL_ID = 16;
    public static final int TAG_NHISTORY_MOD_USER_ID = 17;
    public static final int TAG_NHISTORY_MOD_CONTENT_TIME = 18;
    public static final int TAG_NHISTORY_ACL = 19;
    public static final int TAG_NHISTORY_BLOB_SIZE = 20;
    public static final int TAG_NHISTORY_NODE_CONTENT_KIND = 21;

    public GetNodeHistory(RequestHeader rq) {
        super(rq, RequestDuration.DATA_ACCESS);
    }

    @Override
    public void execute() throws Throwable {
        Security security = this.security();
        if (security.role() != UserRole.ADMIN && !security.getUserInterface().canViewMetadataHistory) {
            return;
        }
        double nodeId = this.getNodeID();
        Timestamp startDate = null;
        Timestamp endDate = null;
        boolean includeAttrChange = false;
        int numRec = 0;
        boolean inUsersView = false;
        IntegerList operations = new IntegerList(1);
        IntegerList nodeTypes = new IntegerList(1);
        DoubleList users = new DoubleList(1);
        TaggedReader reader = this.createRequestContentReader();
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 5: {
                    startDate = new Timestamp(reader.getDate(this).getTime());
                    break;
                }
                case 6: {
                    endDate = new Timestamp(reader.getDate(this).getTime());
                    break;
                }
                case 3: {
                    operations.add(reader.getInt());
                    break;
                }
                case 8: {
                    nodeTypes.add(reader.getInt());
                    break;
                }
                case 12: {
                    users.add(reader.getDouble());
                    break;
                }
                case 10: {
                    includeAttrChange = true;
                    break;
                }
                case 11: {
                    numRec = reader.getInt();
                    break;
                }
                case 15: {
                    inUsersView = true;
                }
            }
        }
        MetadataNodeReader MetaReader = new MetadataNodeReader();
        ArrayList<MetadataNodeReader.NodeHistoryEntry> history = MetaReader.getNodeHistory(null, nodeId, startDate, endDate, includeAttrChange, numRec, operations, nodeTypes, users, inUsersView);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(result);
        for (MetadataNodeReader.NodeHistoryEntry entry : history) {
            ByteArrayOutputStream nodeResult = new ByteArrayOutputStream();
            TaggedWriter nodeOut = new TaggedWriter(nodeResult);
            nodeOut.putDouble(4, entry.id);
            nodeOut.putDate(1, entry.date);
            nodeOut.putDouble(2, entry.user);
            nodeOut.putInt32(3, entry.operation);
            nodeOut.putInt32(8, entry.nodeType);
            nodeOut.putDouble(7, entry.nodeId);
            nodeOut.putInt32(21, entry.nodeContentKind);
            nodeOut.putString(9, entry.nodeName == null ? "" : entry.nodeName);
            nodeOut.putDouble(13, entry.parentId);
            nodeOut.putString(14, entry.comment == null ? "" : entry.comment);
            if (entry.replId != 0.0) {
                nodeOut.putDouble(16, entry.replId);
            }
            if (entry.modUserId != -1.0) {
                nodeOut.putDouble(17, entry.modUserId);
            }
            if (entry.modContentTime != null) {
                nodeOut.putDate(18, entry.modContentTime);
            }
            if (entry.acl != null) {
                nodeOut.putRaw(19, entry.acl);
            }
            nodeOut.putInt32(20, entry.blobSize);
            nodeOut.flush();
            out.putRaw(202, nodeResult);
        }
        out.flush();
        this.sendResult(result.internalBuffer(), result.size());
    }
}

