/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.mtd.request;

import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.RequestResult;
import inform.agent.mtd.TicketEngine;

public class GetTicket
extends Request {
    public static final int TAG_TICKET_NODE_ID = 1;
    public static final int TAG_TICKET_OP_CODE = 2;
    public static final int TAG_TICKET_FAIL_MESSAGE = 3;
    public static final int TAG_TICKET_KEY = 4;

    public GetTicket(RequestHeader rq) {
        super(rq, RequestDuration.NORMAL);
    }

    @Override
    public void execute() throws Throwable {
        TicketEngine.Ticket ticket;
        double nodeId = 0.0;
        int opCode = 0;
        TaggedReader in = this.createRequestContentReader();
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 1: {
                    nodeId = in.getDouble();
                    break;
                }
                case 2: {
                    opCode = in.getInt();
                }
            }
        }
        boolean fail = false;
        RequestResult result = new RequestResult(this);
        TaggedWriter out = result.getWriter();
        if (!fail && nodeId <= 0.0) {
            out.putString(3, "The nodeId is incorrect.");
            fail = true;
        }
        if (!fail && opCode != 1) {
            out.putString(3, "OpCode is incorrect.");
            fail = true;
        }
        if (!fail && (ticket = TicketEngine.getNewTicket(nodeId, opCode, this.client())) != null && !ticket.getKey().isEmpty()) {
            out.putString(4, ticket.getKey());
        }
        out.flush();
        result.sendResult();
    }
}

